/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.effects;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeMod;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.effects.ITextureOverlayEffect;
import xyz.pixelatedw.mineminenomi.api.effects.ModEffect;
import xyz.pixelatedw.mineminenomi.api.enums.NetType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.packets.server.SToggleAnimationPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class CaughtInNetEffect
extends ModEffect
implements ITextureOverlayEffect {
    public static final ResourceLocation NET_TEXTURE = new ResourceLocation("mineminenomi", "textures/models/armor/net.png");
    public static final ResourceLocation KAIROSEKI_NET_TEXTURE = new ResourceLocation("mineminenomi", "textures/models/armor/kairoseki_net.png");
    private NetType type;

    public CaughtInNetEffect(NetType type) {
        super(EffectType.HARMFUL, WyHelper.hexToRGB("#000000").getRGB());
        this.type = type;
        this.func_220304_a(Attributes.field_233821_d_, "0e091520-be78-40aa-9e74-22aa34f506cf", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.func_220304_a((Attribute)ForgeMod.SWIM_SPEED.get(), "71ada06a-e999-4408-9d43-6f205379b52a", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.func_220304_a((Attribute)ModAttributes.JUMP_HEIGHT.get(), "7cadbf47-441b-4cd8-b93f-4e0c1147c7c8", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.func_220304_a(Attributes.field_233825_h_, "21006ee0-bf00-4ef7-90b0-d6ba8c003a4f", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.func_220304_a((Attribute)ModAttributes.MINING_SPEED.get(), "7adfb66b-5442-4b9e-8a42-5b1e25c39226", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    @Override
    public boolean shouldUpdateClient() {
        return true;
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return true;
    }

    public void func_76394_a(LivingEntity entity, int amplifier) {
        EffectInstance instance = entity.func_70660_b((Effect)this);
        if (instance.func_76459_b() <= 1) {
            entity.func_195063_d((Effect)this);
            AbilityHelper.enableAbilities(entity, ability -> ability != null && ability.getCore().getCategory() == AbilityCategory.DEVIL_FRUITS);
            return;
        }
        if (this.type == NetType.NORMAL) {
            if (entity.func_70027_ad()) {
                entity.func_195063_d((Effect)this);
            }
            if (AbilityHelper.isLogiaBlocking((Entity)entity, entity)) {
                entity.func_195063_d((Effect)this);
            }
        } else if (this.type == NetType.KAIROSEKI) {
            AbilityHelper.disableAbilities(entity, instance.func_76459_b(), ability -> ability != null && ability.getCore().getCategory() == AbilityCategory.DEVIL_FRUITS);
        }
    }

    @Override
    public void startEffect(LivingEntity entity, EffectInstance instance) {
        WyNetwork.sendToAllTrackingAndSelf(SToggleAnimationPacket.playAnimation(entity, ModAnimations.CAUGHT_IN_NET, instance.func_76459_b(), true), (Entity)entity);
    }

    @Override
    public void stopEffect(LivingEntity entity) {
        WyNetwork.sendToAllTrackingAndSelf(SToggleAnimationPacket.stopAnimation(entity, ModAnimations.CAUGHT_IN_NET), (Entity)entity);
    }

    @Override
    public boolean isRemoveable() {
        return false;
    }

    @Override
    public boolean isBlockingSwings() {
        return true;
    }

    @Override
    public boolean isBlockingRotations() {
        return true;
    }

    public NetType getType() {
        return this.type;
    }

    @Override
    public ResourceLocation getBodyTexture(int duration, int amplifier) {
        switch (this.type) {
            case KAIROSEKI: {
                return KAIROSEKI_NET_TEXTURE;
            }
        }
        return NET_TEXTURE;
    }
}

