/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.datagen.loottables;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.conditions.RandomChance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xyz.pixelatedw.mineminenomi.data.functions.FruitAlreadyExistsFunction;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiBoxItem;
import xyz.pixelatedw.mineminenomi.wypi.LootTablesDataGen;

public class DFBoxesLootTablesDataGen
extends LootTablesDataGen {
    private final Map<AkumaNoMiBoxItem, LootTable.Builder> lootTables = new HashMap<AkumaNoMiBoxItem, LootTable.Builder>();

    public DFBoxesLootTablesDataGen(DataGenerator dataGenerator) {
        super(dataGenerator);
    }

    public void func_200398_a(DirectoryCache cache) {
        this.addLootTable((AkumaNoMiBoxItem)ModItems.TIER_1_BOX.get());
        this.addLootTable((AkumaNoMiBoxItem)ModItems.TIER_2_BOX.get());
        this.addLootTable((AkumaNoMiBoxItem)ModItems.TIER_3_BOX.get());
        HashMap<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();
        this.lootTables.forEach((item, builder) -> {
            ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item);
            ResourceLocation key = new ResourceLocation(resourcelocation.func_110624_b(), "dfboxes/" + resourcelocation.func_110623_a());
            tables.put(key, builder.func_216038_b());
        });
        this.writeTables(cache, tables);
    }

    protected void addLootTable(AkumaNoMiBoxItem item) {
        LootTable.Builder builder = LootTable.func_216119_b();
        LootPool.Builder sameTierFruits = LootPool.func_216096_a().name("mineminenomi:fruits").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)5)).func_212840_b_(RandomChance.func_216004_a((float)0.95f));
        ModValues.DEVIL_FRUITS.stream().filter(df -> df.getTier() == item.getTierLevel()).forEach(df -> sameTierFruits.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)df).func_216086_a(100).func_212841_b_(FruitAlreadyExistsFunction.builder())));
        if (item.getTierLevel() < 3) {
            LootPool.Builder nextTierFruits = LootPool.func_216096_a().name("mineminenomi:next_tier_fruits").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(RandomChance.func_216004_a((float)0.05f));
            ModValues.DEVIL_FRUITS.stream().filter(df -> df.getTier() == item.getTierLevel() + 1).forEach(df -> nextTierFruits.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)df).func_216086_a(100).func_212841_b_(FruitAlreadyExistsFunction.builder())));
            builder.func_216040_a(nextTierFruits);
        }
        builder.func_216040_a(sameTierFruits);
        this.lootTables.put(item, builder);
    }

    @Override
    public String func_200397_b() {
        return "DF Boxes Loot Pools";
    }
}

