/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import xyz.pixelatedw.mineminenomi.api.DFEncyclopediaEntry;
import xyz.pixelatedw.mineminenomi.init.ModLootTypes;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;
import xyz.pixelatedw.mineminenomi.items.DFEncyclopediaItem;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class EncyclopediaCompletionFunction
extends LootFunction {
    protected EncyclopediaCompletionFunction(ILootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected ItemStack func_215859_a(ItemStack stack, LootContext context) {
        int attempts = context.func_216032_b().nextInt(5) + 1;
        for (int i = 0; i < attempts; ++i) {
            AkumaNoMiItem fruit = WyHelper.shuffle(new ArrayList<AkumaNoMiItem>(ModValues.DEVIL_FRUITS)).stream().findFirst().orElse(null);
            if (fruit == null) continue;
            DFEncyclopediaEntry template = fruit.getRandomElements((IWorld)context.func_202879_g());
            Optional<Object> shape = Optional.empty();
            Optional<Object> baseColor = Optional.empty();
            Optional<Object> stemColor = Optional.empty();
            int rolls = context.func_216032_b().nextInt(2);
            if (context.func_216032_b().nextInt(128) == 0) {
                rolls = 3;
            }
            if (rolls < 3) {
                for (int j = 0; j < rolls; ++j) {
                    int rand = context.func_216032_b().nextInt(3);
                    if (rand == 0) {
                        shape = template.getShape();
                        continue;
                    }
                    if (rand == 1) {
                        baseColor = template.getBaseColor();
                        continue;
                    }
                    stemColor = template.getStemColor();
                }
            } else {
                shape = template.getShape();
                baseColor = template.getBaseColor();
                stemColor = template.getStemColor();
            }
            if (!shape.isPresent() && !baseColor.isPresent() && !stemColor.isPresent()) continue;
            ResourceLocation key = fruit.getRegistryName();
            DFEncyclopediaEntry clue = new DFEncyclopediaEntry(shape, baseColor, stemColor);
            DFEncyclopediaItem.addFruitClues(stack, key, clue);
            stack.func_190920_e(1);
        }
        return stack;
    }

    public LootFunctionType func_230425_b_() {
        return ModLootTypes.ENCYCLOPEDIA_COMPLETION;
    }

    public static LootFunction.Builder<?> builder() {
        return EncyclopediaCompletionFunction.func_215860_a(condition -> new EncyclopediaCompletionFunction((ILootCondition[])condition));
    }

    public static class Serializer
    extends LootFunction.Serializer<EncyclopediaCompletionFunction> {
        public void serialize(JsonObject object, EncyclopediaCompletionFunction functionClazz, JsonSerializationContext serializationContext) {
            super.func_230424_a_(object, (LootFunction)functionClazz, serializationContext);
        }

        public EncyclopediaCompletionFunction deserialize(JsonObject object, JsonDeserializationContext deserializationContext, ILootCondition[] conditionsIn) {
            return new EncyclopediaCompletionFunction(conditionsIn);
        }
    }
}

