/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.entity.quests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.api.quests.QuestId;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.Objective;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;

public class QuestDataBase
implements IQuestData {
    private PlayerEntity owner;
    private Quest[] inProgressQuests = new Quest[4];
    private List<QuestId> finishedQuests = new ArrayList<QuestId>();

    @Override
    public IQuestData setOwner(PlayerEntity entity) {
        this.owner = entity;
        return this;
    }

    @Override
    public boolean addInProgressQuest(Quest quest) {
        for (int i = 0; i < this.inProgressQuests.length; ++i) {
            Quest ogQuest = this.inProgressQuests[i];
            if (ogQuest != null) continue;
            this.inProgressQuests[i] = quest;
            return true;
        }
        return false;
    }

    @Override
    public boolean setInProgressQuest(int slot, Quest quest) {
        Quest ogQuest = this.getInProgressQuest(quest);
        if (ogQuest == null && slot <= 4) {
            this.inProgressQuests[slot] = quest;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeInProgressQuest(QuestId quest) {
        QuestId ogQuest = this.getInProgressQuest((Quest)((Object)quest));
        if (ogQuest != null) {
            for (int i = 0; i < this.inProgressQuests.length; ++i) {
                Quest inProgressQuest = this.inProgressQuests[i];
                if (inProgressQuest == null || !inProgressQuest.equals((Object)ogQuest)) continue;
                inProgressQuest.resetProgress(this.owner);
                this.inProgressQuests[i] = null;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean removeInProgressQuest(Quest quest) {
        Quest ogQuest = this.getInProgressQuest(quest);
        if (ogQuest != null) {
            for (int i = 0; i < this.inProgressQuests.length; ++i) {
                Quest inProgressQuest = this.inProgressQuests[i];
                if (inProgressQuest == null || !inProgressQuest.equals(ogQuest)) continue;
                inProgressQuest.resetProgress(this.owner);
                this.inProgressQuests[i] = null;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasInProgressQuest(QuestId quest) {
        return Arrays.stream(this.inProgressQuests).filter(qst -> qst != null).anyMatch(qst -> ((Object)((Object)qst.getCore())).equals((Object)quest));
    }

    @Override
    public boolean hasInProgressQuest(Quest quest) {
        return Arrays.stream(this.inProgressQuests).filter(qst -> qst != null).anyMatch(qst -> qst.equals(quest));
    }

    @Override
    public <T extends Quest> T getInProgressQuest(QuestId<T> quest) {
        return (T)((Quest)Arrays.stream(this.inProgressQuests).filter(qst -> qst != null && ((Object)((Object)qst.getCore())).equals((Object)quest)).findFirst().orElse(null));
    }

    @Override
    public <T extends Quest> T getInProgressQuest(T quest) {
        return (T)((Quest)Arrays.stream(this.inProgressQuests).filter(qst -> qst != null && qst.equals(quest)).findFirst().orElse(null));
    }

    @Override
    public <T extends Quest> T getInProgressQuest(int slot) {
        return (T)this.inProgressQuests[slot];
    }

    @Override
    public int getInProgressQuestSlot(Quest quest) {
        for (int i = 0; i < this.inProgressQuests.length; ++i) {
            if (this.inProgressQuests[i] == null || !this.inProgressQuests[i].equals(quest)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public <T extends Objective> List<T> getInProgressObjectives() {
        return Arrays.stream(this.getInProgressQuests()).filter(q -> q != null && !q.isComplete()).flatMap(q -> q.getObjectives().stream()).filter(o -> !o.isHidden() && !o.isLocked()).collect(Collectors.toList());
    }

    @Override
    public Quest[] getInProgressQuests() {
        return this.inProgressQuests;
    }

    @Override
    public void clearInProgressQuests() {
        for (int i = 0; i < this.inProgressQuests.length; ++i) {
            Quest quest = this.inProgressQuests[i];
            if (quest == null) continue;
            this.inProgressQuests[i] = null;
        }
    }

    @Override
    public int countInProgressQuests() {
        return Arrays.stream(this.inProgressQuests).filter(quest -> quest != null).mapToInt(q -> 1).sum();
    }

    @Override
    public boolean addFinishedQuest(QuestId quest) {
        QuestId ogQuest = this.getFinishedQuest(quest);
        if (ogQuest == null) {
            this.finishedQuests.add(quest);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeFinishedQuest(QuestId quest) {
        QuestId ogQuest = this.getFinishedQuest(quest);
        if (ogQuest != null) {
            this.finishedQuests.remove((Object)ogQuest);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasFinishedQuest(QuestId quest) {
        if (!CommonConfig.INSTANCE.isQuestProgressionEnabled()) {
            return true;
        }
        return this.finishedQuests.stream().filter(q -> q != null).anyMatch(qst -> ((Object)qst).equals((Object)quest));
    }

    @Override
    public <T extends QuestId> T getFinishedQuest(T quest) {
        return (T)((Object)((QuestId)this.finishedQuests.stream().filter(qst -> qst != null && ((Object)qst).equals((Object)quest)).findFirst().orElse(null)));
    }

    @Override
    public List<QuestId> getFinishedQuests() {
        return this.finishedQuests.stream().filter(q -> q != null).collect(Collectors.toList());
    }

    @Override
    public void clearFinishedQuests() {
        this.finishedQuests.clear();
    }

    @Override
    public int countFinishedQuests() {
        return this.finishedQuests.size();
    }
}

