/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.entity.haki;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.api.enums.HakiType;
import xyz.pixelatedw.mineminenomi.api.enums.StatChangeSource;
import xyz.pixelatedw.mineminenomi.api.events.stats.HakiExpEvent;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;

public class HakiDataBase
implements IHakiData {
    private LivingEntity owner;
    private float kenbunshokuExp;
    private float busoshokuHardeningExp;
    private int hakiOveruse;
    private int haoshokuHakiColour;

    @Override
    public IHakiData setOwner(LivingEntity owner) {
        this.owner = owner;
        return this;
    }

    @Override
    public float getTotalHakiExp() {
        return this.kenbunshokuExp + this.busoshokuHardeningExp;
    }

    @Override
    public float getMaxHakiExp() {
        return CommonConfig.INSTANCE.getHakiExpLimit() * (HakiType.values().length - 1);
    }

    @Override
    public int getHakiOveruse() {
        return this.hakiOveruse;
    }

    @Override
    public int getMaxOveruse() {
        return (int)(this.getTotalHakiExp() * 140.0f);
    }

    @Override
    public void alterHakiOveruse(int value) {
        this.hakiOveruse = MathHelper.func_76125_a((int)(this.hakiOveruse + value), (int)0, (int)this.getMaxOveruse());
    }

    @Override
    public void setHakiOveruse(int value) {
        this.hakiOveruse = MathHelper.func_76125_a((int)value, (int)0, (int)this.getMaxOveruse());
    }

    @Override
    public float getKenbunshokuHakiExp() {
        return this.kenbunshokuExp;
    }

    @Override
    public boolean alterKenbunshokuHakiExp(float value, StatChangeSource source) {
        if (this.owner instanceof PlayerEntity) {
            HakiExpEvent.Pre pre = new HakiExpEvent.Pre((PlayerEntity)this.owner, value, HakiType.KENBUNSHOKU, source);
            if (MinecraftForge.EVENT_BUS.post((Event)pre)) {
                return false;
            }
            value = pre.getHakiExp();
        }
        this.kenbunshokuExp = MathHelper.func_76131_a((float)(this.kenbunshokuExp + value), (float)0.0f, (float)CommonConfig.INSTANCE.getHakiExpLimit());
        HakiExpEvent.Post post = new HakiExpEvent.Post((PlayerEntity)this.owner, value, HakiType.KENBUNSHOKU, source);
        MinecraftForge.EVENT_BUS.post((Event)post);
        return true;
    }

    @Override
    public void setKenbunshokuHakiExp(float value) {
        this.kenbunshokuExp = MathHelper.func_76131_a((float)value, (float)0.0f, (float)CommonConfig.INSTANCE.getHakiExpLimit());
    }

    @Override
    public float getBusoshokuHakiExp() {
        return this.busoshokuHardeningExp;
    }

    @Override
    public boolean alterBusoshokuHakiExp(float value, StatChangeSource source) {
        if (this.owner instanceof PlayerEntity) {
            HakiExpEvent.Pre pre = new HakiExpEvent.Pre((PlayerEntity)this.owner, value, HakiType.BUSOSHOKU, source);
            if (MinecraftForge.EVENT_BUS.post((Event)pre)) {
                return false;
            }
            value = pre.getHakiExp();
        }
        this.busoshokuHardeningExp = MathHelper.func_76131_a((float)(this.busoshokuHardeningExp + value), (float)0.0f, (float)CommonConfig.INSTANCE.getHakiExpLimit());
        HakiExpEvent.Post post = new HakiExpEvent.Post((PlayerEntity)this.owner, value, HakiType.BUSOSHOKU, source);
        MinecraftForge.EVENT_BUS.post((Event)post);
        return true;
    }

    @Override
    public void setBusoshokuHakiExp(float value) {
        this.busoshokuHardeningExp = MathHelper.func_76131_a((float)value, (float)0.0f, (float)CommonConfig.INSTANCE.getHakiExpLimit());
    }

    @Override
    public int getHaoshokuHakiColour() {
        return this.haoshokuHakiColour;
    }

    @Override
    public void setHaoshokuHakiColour(int colour) {
        this.haoshokuHakiColour = colour;
    }
}

