/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.entity.ability;

import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.util.LazyOptional;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCoreUnlockWrapper;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponentKey;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataBase;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;

public class AbilityDataCapability {
    @CapabilityInject(value=IAbilityData.class)
    public static final Capability<IAbilityData> INSTANCE = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IAbilityData.class, (Capability.IStorage)new Capability.IStorage<IAbilityData>(){

            public INBT writeNBT(Capability<IAbilityData> capability, IAbilityData instance, Direction side) {
                CompoundNBT props = new CompoundNBT();
                try {
                    ListNBT unlockedAbilities = new ListNBT();
                    for (AbilityCoreUnlockWrapper abilityCoreUnlockWrapper : instance.getUnlockedAbilities()) {
                        unlockedAbilities.add((Object)abilityCoreUnlockWrapper.save());
                    }
                    props.func_218657_a("unlocked_abilities", (INBT)unlockedAbilities);
                    ListNBT passiveAbilities = new ListNBT();
                    for (IAbility abl : instance.getPassiveAbilities()) {
                        CompoundNBT nbt = new CompoundNBT();
                        nbt.func_74778_a("id", abl.getCore().getRegistryName().toString());
                        nbt = abl.save(nbt);
                        CompoundNBT components = new CompoundNBT();
                        for (Map.Entry<AbilityComponentKey<?>, AbilityComponent<?>> entry : abl.getComponents().entrySet()) {
                            CompoundNBT compNbt = entry.getValue().save();
                            if (compNbt == null) continue;
                            components.func_218657_a(entry.getKey().getId().toString(), (INBT)compNbt);
                        }
                        nbt.func_218657_a("components", (INBT)components);
                        passiveAbilities.add((Object)nbt);
                    }
                    props.func_218657_a("passive_abilities", (INBT)passiveAbilities);
                    ListNBT listNBT = new ListNBT();
                    int slotId = 0;
                    for (IAbility abl : instance.getRawEquippedAbilities()) {
                        CompoundNBT nbt;
                        if (abl == null) {
                            nbt = new CompoundNBT();
                            nbt.func_74768_a("slot", slotId);
                            listNBT.add((Object)nbt);
                        } else {
                            nbt = new CompoundNBT();
                            nbt.func_74768_a("slot", slotId);
                            nbt.func_74778_a("id", abl.getCore().getRegistryName().toString());
                            nbt = abl.save(nbt);
                            CompoundNBT components = new CompoundNBT();
                            for (Map.Entry<AbilityComponentKey<?>, AbilityComponent<?>> entry : abl.getComponents().entrySet()) {
                                CompoundNBT compNbt = entry.getValue().save();
                                if (compNbt == null) continue;
                                components.func_218657_a(entry.getKey().getId().toString(), (INBT)compNbt);
                            }
                            nbt.func_218657_a("components", (INBT)components);
                            listNBT.add((Object)nbt);
                        }
                        ++slotId;
                    }
                    props.func_218657_a("equipped_abilities", (INBT)listNBT);
                    props.func_74768_a("combat_bar_set", instance.getCombatBarSet());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return props;
            }

            public void readNBT(Capability<IAbilityData> capability, IAbilityData instance, Direction side, INBT nbtData) {
                CompoundNBT props = (CompoundNBT)nbtData;
                try {
                    HashSet updatedUnlockSet = new HashSet();
                    ListNBT unlockedAbilities = props.func_150295_c("unlocked_abilities", 10);
                    for (int i = 0; i < unlockedAbilities.size(); ++i) {
                        CompoundNBT nbt = unlockedAbilities.func_150305_b(i);
                        AbilityCoreUnlockWrapper wrapper = AbilityCoreUnlockWrapper.of(nbt);
                        instance.addUnlockedAbility(wrapper);
                        updatedUnlockSet.add(wrapper.getAbilityCore());
                    }
                    instance.clearUnlockedAbilities(core -> !updatedUnlockSet.contains(core));
                    HashSet<AbilityCore> updatedPassiveSet = new HashSet<AbilityCore>();
                    ListNBT passiveAbilities = props.func_150295_c("passive_abilities", 10);
                    for (int i = 0; i < passiveAbilities.size(); ++i) {
                        Object ability;
                        CompoundNBT nbt = passiveAbilities.func_150305_b(i);
                        String coreId = nbt.func_74779_i("id");
                        AbilityCore core2 = (AbilityCore)ModRegistries.ABILITIES.getValue(new ResourceLocation(coreId));
                        if (core2 == null || (ability = core2.createAbility()) == null) continue;
                        ability.load(nbt);
                        CompoundNBT components = nbt.func_74775_l("components");
                        for (Map.Entry<AbilityComponentKey<?>, AbilityComponent<?>> entry : ability.getComponents().entrySet()) {
                            CompoundNBT compNbt = components.func_74775_l(entry.getKey().getId().toString());
                            if (compNbt == null) continue;
                            entry.getValue().load(compNbt);
                        }
                        instance.addPassiveAbility((IAbility)ability);
                        updatedPassiveSet.add(ability.getCore());
                    }
                    instance.clearPassiveAbilities(abl -> !updatedPassiveSet.contains(abl.getCore()));
                    HashSet<AbilityCore> updatedEquipSet = new HashSet<AbilityCore>();
                    ListNBT equippedAbilities = props.func_150295_c("equipped_abilities", 10);
                    for (int i = 0; i < equippedAbilities.size(); ++i) {
                        CompoundNBT nbt = equippedAbilities.func_150305_b(i);
                        int slotId = nbt.func_74762_e("slot");
                        if (nbt.func_74764_b("id")) {
                            String coreId = nbt.func_74779_i("id");
                            AbilityCore core3 = (AbilityCore)ModRegistries.ABILITIES.getValue(new ResourceLocation(coreId));
                            if (core3 == null) continue;
                            Object ability = core3.createAbility();
                            ability.load(nbt);
                            CompoundNBT components = nbt.func_74775_l("components");
                            for (Map.Entry<AbilityComponentKey<?>, AbilityComponent<?>> entry : ability.getComponents().entrySet()) {
                                CompoundNBT compNbt = components.func_74775_l(entry.getKey().getId().toString());
                                if (compNbt == null) continue;
                                entry.getValue().load(compNbt);
                            }
                            instance.setEquippedAbility(slotId, (IAbility)ability);
                            updatedEquipSet.add(ability.getCore());
                            continue;
                        }
                        instance.setEquippedAbility(slotId, null);
                    }
                    instance.clearEquippedAbilities(abl -> abl != null && !updatedEquipSet.contains(abl.getCore()));
                    instance.setCombatBarSet(props.func_74762_e("combat_bar_set"));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }, AbilityDataBase::new);
    }

    @Nullable
    public static IAbilityData get(@Nonnull LivingEntity entity) {
        return (IAbilityData)AbilityDataCapability.getLazy(entity).orElse((Object)new AbilityDataBase());
    }

    public static LazyOptional<IAbilityData> getLazy(@Nonnull LivingEntity entity) {
        LazyOptional lazyGCD = entity.getCapability(INSTANCE, null);
        lazyGCD.ifPresent(data -> data.initDataOwner(entity));
        return lazyGCD;
    }
}

