/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.config.options;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;
import xyz.pixelatedw.mineminenomi.config.options.ListOption;

public class IntegerListOption
extends ListOption<Integer> {
    private static final Predicate<Object> VALIDATOR = new Predicate<Object>(){

        @Override
        public boolean test(Object t) {
            if (!(t instanceof Integer)) {
                return false;
            }
            Integer i = (Integer)t;
            return i >= 0;
        }
    };

    public IntegerListOption(List<Integer> defaultValue, String optionName, @Nullable String optionDescription) {
        super(defaultValue, VALIDATOR, optionName, optionDescription);
    }

    @Override
    protected ForgeConfigSpec.ConfigValue<List<? extends Integer>> buildValue(ForgeConfigSpec.Builder builder) {
        if (this.getDescription() != null) {
            builder.comment(this.getDescription());
        }
        return builder.defineList(this.getTitle(), (List)this.getDefault(), this.getValidator());
    }
}

