/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import xyz.pixelatedw.mineminenomi.api.commands.QuestArgument;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.api.quests.QuestId;
import xyz.pixelatedw.mineminenomi.commands.Requires;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.events.abilities.AbilityProgressionEvents;
import xyz.pixelatedw.mineminenomi.integrations.perms.WyPermissions;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncAbilityDataPacket;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncQuestDataPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class QuestCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher, @Nullable LiteralArgumentBuilder<CommandSource> masterBuilder) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"quest").requires(Requires.hasPermission(2, WyPermissions.QUEST_COMMAND));
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"finish").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"quest", (ArgumentType)QuestArgument.quest()).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> QuestCommand.finishQuest((CommandContext<CommandSource>)context, QuestArgument.getQuest(context, "quest"), EntityArgument.func_197089_d((CommandContext)context, (String)"target"))))).executes(context -> QuestCommand.finishQuest((CommandContext<CommandSource>)context, QuestArgument.getQuest(context, "quest"), ((CommandSource)context.getSource()).func_197035_h()))))).then(Commands.func_197057_a((String)"give").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"quest", (ArgumentType)QuestArgument.quest()).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> QuestCommand.giveQuest((CommandContext<CommandSource>)context, QuestArgument.getQuest(context, "quest"), EntityArgument.func_197089_d((CommandContext)context, (String)"target"))))).executes(context -> QuestCommand.giveQuest((CommandContext<CommandSource>)context, QuestArgument.getQuest(context, "quest"), ((CommandSource)context.getSource()).func_197035_h()))))).then(Commands.func_197057_a((String)"unfinish").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"quest", (ArgumentType)QuestArgument.quest()).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> QuestCommand.unfinishQuest((CommandContext<CommandSource>)context, QuestArgument.getQuest(context, "quest"), EntityArgument.func_197089_d((CommandContext)context, (String)"target"))))).executes(context -> QuestCommand.unfinishQuest((CommandContext<CommandSource>)context, QuestArgument.getQuest(context, "quest"), ((CommandSource)context.getSource()).func_197035_h()))))).then(Commands.func_197057_a((String)"remove").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"quest", (ArgumentType)QuestArgument.quest()).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> QuestCommand.removeQuest((CommandContext<CommandSource>)context, QuestArgument.getQuest(context, "quest"), EntityArgument.func_197089_d((CommandContext)context, (String)"target"))))).executes(context -> QuestCommand.removeQuest((CommandContext<CommandSource>)context, QuestArgument.getQuest(context, "quest"), ((CommandSource)context.getSource()).func_197035_h()))));
        if (masterBuilder != null) {
            masterBuilder.then((ArgumentBuilder)builder);
        } else {
            dispatcher.register(builder);
        }
    }

    private static int unfinishQuest(CommandContext<CommandSource> context, QuestId quest, ServerPlayerEntity player) {
        IQuestData props = QuestDataCapability.get((PlayerEntity)player);
        IAbilityData abilityData = AbilityDataCapability.get((LivingEntity)player);
        if (props.hasFinishedQuest(quest)) {
            props.removeFinishedQuest(quest);
            AbilityProgressionEvents.checkForStyleUnlocks((PlayerEntity)player);
            WyNetwork.sendTo(new SSyncQuestDataPacket(player.func_145782_y(), props), (PlayerEntity)player);
            WyNetwork.sendTo(new SSyncAbilityDataPacket(player.func_145782_y(), abilityData), (PlayerEntity)player);
        } else {
            player.func_145747_a((ITextComponent)new StringTextComponent("You haven't finished this quest!"), Util.field_240973_b_);
        }
        return 1;
    }

    private static int finishQuest(CommandContext<CommandSource> context, QuestId questId, ServerPlayerEntity player) {
        IQuestData props = QuestDataCapability.get((PlayerEntity)player);
        if (props.hasInProgressQuest(questId)) {
            QuestId quest = props.getInProgressQuest(questId);
            if (((Quest)((Object)quest)).triggerCompleteEvent((PlayerEntity)player)) {
                props.addFinishedQuest(((Quest)((Object)quest)).getCore());
                props.removeInProgressQuest((Quest)((Object)quest));
                WyNetwork.sendTo(new SSyncQuestDataPacket(player.func_145782_y(), props), (PlayerEntity)player);
            }
        } else if (!props.hasInProgressQuest(questId)) {
            player.func_145747_a((ITextComponent)new StringTextComponent("You don't have this quest!"), Util.field_240973_b_);
        }
        return 1;
    }

    private static int giveQuest(CommandContext<CommandSource> context, QuestId quest, ServerPlayerEntity player) {
        IQuestData props = QuestDataCapability.get((PlayerEntity)player);
        if (!props.hasInProgressQuest(quest)) {
            props.addInProgressQuest((Quest)quest.createQuest());
            WyNetwork.sendTo(new SSyncQuestDataPacket(player.func_145782_y(), props), (PlayerEntity)player);
        } else {
            player.func_145747_a((ITextComponent)new StringTextComponent("You aleady have this quest!"), Util.field_240973_b_);
        }
        return 1;
    }

    private static int removeQuest(CommandContext<CommandSource> context, QuestId quest, ServerPlayerEntity player) {
        IQuestData props = QuestDataCapability.get((PlayerEntity)player);
        if (props.hasInProgressQuest(quest)) {
            props.removeInProgressQuest(quest);
            props.removeFinishedQuest(quest);
            WyNetwork.sendTo(new SSyncQuestDataPacket(player.func_145782_y(), props), (PlayerEntity)player);
        } else {
            player.func_145747_a((ITextComponent)new StringTextComponent("You don't have this quest!"), Util.field_240973_b_);
        }
        return 1;
    }
}

