/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.IntegrityProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.ModMain;
import xyz.pixelatedw.mineminenomi.api.DFEncyclopediaEntry;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.charactercreator.FactionId;
import xyz.pixelatedw.mineminenomi.api.commands.FactionArgument;
import xyz.pixelatedw.mineminenomi.api.enums.StatChangeSource;
import xyz.pixelatedw.mineminenomi.api.helpers.BountyHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.api.poi.NTEventTarget;
import xyz.pixelatedw.mineminenomi.api.poi.POIEventTarget;
import xyz.pixelatedw.mineminenomi.api.poi.TrackedNPC;
import xyz.pixelatedw.mineminenomi.api.quests.QuestId;
import xyz.pixelatedw.mineminenomi.blocks.tileentities.CustomSpawnerTileEntity;
import xyz.pixelatedw.mineminenomi.commands.TestCommand;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.data.world.EventsWorldData;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.data.world.NPCWorldData;
import xyz.pixelatedw.mineminenomi.entities.WantedPosterPackageEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.NotoriousEntity;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;
import xyz.pixelatedw.mineminenomi.packets.server.SGrabScreenshotPacket;
import xyz.pixelatedw.mineminenomi.world.RandomizeSkyBlocksProcessor;
import xyz.pixelatedw.mineminenomi.world.ReplaceWaterloggedStructureProcessor;
import xyz.pixelatedw.mineminenomi.world.spawners.AmbushSpawner;
import xyz.pixelatedw.mineminenomi.wypi.WyDebug;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class FGCommand {
    public static boolean NO_COOLDOWN = false;
    public static boolean SHOW_TPS = false;
    public static int ANIM_SPEED = 8;
    public static int SKYBOX_ID = 0;

    public static void register(CommandDispatcher<CommandSource> dispatcher, @Nullable LiteralArgumentBuilder<CommandSource> masterBuilder) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"fg").requires(source -> source.func_197034_c(0));
        builder.then(Commands.func_197057_a((String)"info").executes(context -> FGCommand.showInfo((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h())));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"check_haki").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> FGCommand.checkHakiStats((CommandContext<CommandSource>)context, EntityArgument.func_197089_d((CommandContext)context, (String)"target"))))).executes(context -> FGCommand.checkHakiStats((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h())));
        builder.then(Commands.func_197057_a((String)"check_bounties").executes(context -> FGCommand.checkBounties((CommandContext<CommandSource>)context)));
        builder.then(Commands.func_197057_a((String)"check_structures").executes(context -> FGCommand.checkStructures((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h())));
        builder.then(Commands.func_197057_a((String)"turn_sword_clone").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> FGCommand.turnSwordInClone((CommandContext<CommandSource>)context, EntityArgument.func_197089_d((CommandContext)context, (String)"target")))));
        builder.then(Commands.func_197057_a((String)"drop_package").executes(context -> FGCommand.dropPackage((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h())));
        builder.then(Commands.func_197057_a((String)"save_structure").then(Commands.func_197056_a((String)"from", (ArgumentType)BlockPosArgument.func_197276_a()).then(Commands.func_197056_a((String)"to", (ArgumentType)BlockPosArgument.func_197276_a()).then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.word()).executes(context -> FGCommand.saveStructure((CommandContext<CommandSource>)context, BlockPosArgument.func_197274_b((CommandContext)context, (String)"from"), BlockPosArgument.func_197274_b((CommandContext)context, (String)"to"), StringArgumentType.getString((CommandContext)context, (String)"name"), ((CommandSource)context.getSource()).func_197035_h()))))));
        builder.then(Commands.func_197057_a((String)"load_structure").executes(context -> FGCommand.loadStructure((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h())));
        builder.then(Commands.func_197057_a((String)"hardcore").executes(context -> FGCommand.harcoreLoadout((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h())));
        builder.then(Commands.func_197057_a((String)"no_cooldowns").executes(context -> {
            NO_COOLDOWN = !NO_COOLDOWN;
            ((CommandSource)context.getSource()).func_197035_h().func_145747_a((ITextComponent)new StringTextComponent((NO_COOLDOWN ? "Enabled" : "Disabled") + " No Cooldown Mode"), ((CommandSource)context.getSource()).func_197035_h().func_110124_au());
            return 1;
        }));
        builder.then(Commands.func_197057_a((String)"anim-speed").then(Commands.func_197056_a((String)"speed", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ANIM_SPEED = IntegerArgumentType.getInteger((CommandContext)context, (String)"speed");
            ((CommandSource)context.getSource()).func_197035_h().func_145747_a((ITextComponent)new StringTextComponent("Animation Speed set to: " + ANIM_SPEED), ((CommandSource)context.getSource()).func_197035_h().func_110124_au());
            return 1;
        })));
        builder.then(Commands.func_197057_a((String)"show_tps").executes(context -> {
            SHOW_TPS = !SHOW_TPS;
            ((CommandSource)context.getSource()).func_197035_h().func_145747_a((ITextComponent)new StringTextComponent((SHOW_TPS ? "Enabled" : "Disabled") + " Show TPS Mode"), ((CommandSource)context.getSource()).func_197035_h().func_110124_au());
            return 1;
        }));
        builder.then(Commands.func_197057_a((String)"clue").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"rolls", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> FGCommand.giveRandomClue((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h(), IntegerArgumentType.getInteger((CommandContext)context, (String)"rolls"), null))).then(Commands.func_197056_a((String)"fruit", (ArgumentType)StringArgumentType.string()).executes(context -> FGCommand.giveRandomClue((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h(), IntegerArgumentType.getInteger((CommandContext)context, (String)"rolls"), StringArgumentType.getString((CommandContext)context, (String)"fruit"))))));
        builder.then(Commands.func_197057_a((String)"ambush").executes(context -> {
            ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
            if (EntityStatsCapability.get((LivingEntity)player).getBounty() < 1000L) {
                EntityStatsCapability.get((LivingEntity)player).alterBounty(2000L, StatChangeSource.COMMAND);
            }
            AmbushSpawner spawner = new AmbushSpawner();
            spawner.spawn(((CommandSource)context.getSource()).func_197023_e());
            return 1;
        }));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"clean").then(Commands.func_197057_a((String)"abilities").executes(ctx -> {
            ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
            IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
            props.getUnlockedAbilities().stream().map(w -> w.getAbilityCore()).forEach(a -> props.removeUnlockedAbility((AbilityCore)a));
            return 1;
        }))).then(Commands.func_197057_a((String)"quests").executes(ctx -> {
            ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
            IQuestData questData = QuestDataCapability.get((PlayerEntity)player);
            Iterator<QuestId> quests = questData.getFinishedQuests().iterator();
            while (quests.hasNext()) {
                questData.removeFinishedQuest(quests.next());
            }
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"stress_test").then(Commands.func_197057_a((String)"spawners").executes(context -> FGCommand.stressTestSpawners((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h())))).then(Commands.func_197057_a((String)"blocks").executes(context -> FGCommand.stressTestBlocks((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h()))));
        ((LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"caravans").executes(ctx -> {
            ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
            EventsWorldData worldData = EventsWorldData.get();
            Set<NTEventTarget> targets = worldData.getNotoriousTargets();
            Set<POIEventTarget> caravans = worldData.getCaravanPOIs();
            Set<POIEventTarget> visits = worldData.getCelestialVisitsPOIs();
            StringBuilder sb = new StringBuilder();
            sb.append("\u00a76Targets:\u00a7r " + targets.size() + "\n");
            for (NTEventTarget nTEventTarget : targets) {
                sb.append("- " + (int)nTEventTarget.getPosition().field_72450_a + " " + (int)nTEventTarget.getPosition().field_72448_b + " " + (int)nTEventTarget.getPosition().field_72449_c + "\n");
            }
            sb.append("\n\n");
            sb.append("\u00a76Caravans:\u00a7r " + caravans.size() + "\n");
            for (POIEventTarget pOIEventTarget : caravans) {
                sb.append("\n- " + (int)pOIEventTarget.getPosition().field_72450_a + " " + (int)pOIEventTarget.getPosition().field_72448_b + " " + (int)pOIEventTarget.getPosition().field_72449_c);
            }
            sb.append("\n\n");
            sb.append("\u00a76Visits:\u00a7r " + visits.size() + "\n");
            for (POIEventTarget pOIEventTarget : visits) {
                sb.append("\n- " + (int)pOIEventTarget.getPosition().field_72450_a + " " + (int)pOIEventTarget.getPosition().field_72448_b + " " + (int)pOIEventTarget.getPosition().field_72449_c);
            }
            sb.append("\n\n");
            player.func_145747_a((ITextComponent)new StringTextComponent(sb.toString()), Util.field_240973_b_);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"notorious_boss").then(Commands.func_197057_a((String)"list").then(Commands.func_197056_a((String)"faction", (ArgumentType)FactionArgument.faction()).executes(ctx -> {
            FactionId factionFilter = FactionArgument.getFaction(ctx, "faction");
            ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
            NPCWorldData worldData = NPCWorldData.get();
            Set<TrackedNPC> set = worldData.getTrackedMobs();
            set.removeIf(npc -> !npc.getFaction().equals((Object)factionFilter.getRegistryName()));
            StringBuilder sb = new StringBuilder();
            sb.append("\u00a76Alive NPCs:\u00a7r " + set.size() + "\n\n");
            for (TrackedNPC npc2 : set) {
                NotoriousEntity entity = npc2.createTrackedMob((World)player.func_71121_q());
                sb.append(entity.func_145748_c_().getString() + " ( " + npc2.getId() + " )");
                sb.append("\n  UUID: " + npc2.getUUID());
                sb.append("\n  Faction: " + npc2.getFaction());
                sb.append("\n  Race: " + npc2.getRace());
                sb.append("\n  Style: " + npc2.getStyle());
                sb.append("\n  Doriki: " + npc2.getDoriki());
                sb.append("\n  Bounty: " + npc2.getBounty());
                sb.append("\n  Kenbunshoku: " + npc2.getObservationHaki());
                sb.append("\n  Busoshoku: " + npc2.getBusoshokuHaki());
                sb.append("\n\n");
            }
            player.func_145747_a((ITextComponent)new StringTextComponent(sb.toString()), Util.field_240973_b_);
            return 1;
        })))).then(Commands.func_197057_a((String)"update").executes(ctx -> {
            ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
            NPCWorldData worldData = NPCWorldData.get();
            Set<TrackedNPC> set = worldData.getTrackedMobs();
            for (TrackedNPC npc : set) {
                npc.recalculateDifficulty(player.func_71121_q());
            }
            return 1;
        }))).then(Commands.func_197056_a((String)"id", (ArgumentType)LongArgumentType.longArg()).executes(context -> {
            ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
            EventsWorldData eventsWorldData = EventsWorldData.get();
            long id = LongArgumentType.getLong((CommandContext)context, (String)"id");
            Optional<TrackedNPC> tracked = NPCWorldData.get().getTrackedMob(id);
            if (!tracked.isPresent()) {
                return 1;
            }
            Vector3d pos = player.func_213303_ch().func_72441_c(10.0, 0.0, 0.0);
            eventsWorldData.addNotoriousTarget(player.func_71121_q(), pos, 1200L, tracked.get());
            return 1;
        })));
        builder.then(Commands.func_197057_a((String)"hurt").then(Commands.func_197056_a((String)"amount", (ArgumentType)FloatArgumentType.floatArg()).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> {
            ServerPlayerEntity target = EntityArgument.func_197089_d((CommandContext)ctx, (String)"target");
            float amount = FloatArgumentType.getFloat((CommandContext)ctx, (String)"amount");
            ModDamageSource source = (ModDamageSource)new ModDamageSource("fgsource").setUnavoidable().bypassLogia().func_151518_m().func_76348_h();
            target.func_70097_a((DamageSource)source, amount);
            return 1;
        }))));
        builder.then(Commands.func_197057_a((String)"create_skybox").then(Commands.func_197056_a((String)"pos", (ArgumentType)BlockPosArgument.func_197276_a()).executes(ctx -> FGCommand.createSkybox((CommandContext<CommandSource>)ctx, ((CommandSource)ctx.getSource()).func_197035_h(), BlockPosArgument.func_197274_b((CommandContext)ctx, (String)"pos")))));
        TestCommand.register((LiteralArgumentBuilder<CommandSource>)builder);
        if (masterBuilder != null) {
            masterBuilder.then((ArgumentBuilder)builder);
        } else {
            dispatcher.register(builder);
        }
    }

    private static int createSkybox(CommandContext<CommandSource> context, ServerPlayerEntity player, BlockPos blockPos) {
        player.func_223102_j((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p());
        int[][] angles = new int[][]{{90, 0}, {180, 0}, {270, 0}, {360, 0}, {360, -180}, {360, 180}};
        player.field_70177_z = angles[SKYBOX_ID %= 6][0];
        player.field_70125_A = angles[SKYBOX_ID][1];
        player.func_200619_a((ServerWorld)player.field_70170_p, (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), player.field_70177_z, player.field_70125_A);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        WyNetwork.sendTo(new SGrabScreenshotPacket(), (PlayerEntity)player);
        ++SKYBOX_ID;
        return 1;
    }

    private static int giveRandomClue(CommandContext<CommandSource> context, ServerPlayerEntity player, int rolls, @Nullable String fruitTemplate) {
        AkumaNoMiItem fruit = null;
        fruit = Strings.isNullOrEmpty((String)fruitTemplate) ? (AkumaNoMiItem)WyHelper.shuffle(new ArrayList<AkumaNoMiItem>(ModValues.DEVIL_FRUITS)).stream().findFirst().orElse(null) : (AkumaNoMiItem)ModValues.DEVIL_FRUITS.stream().filter(df -> df.getFruitKey().equals(fruitTemplate)).findFirst().orElse(null);
        if (fruit == null) {
            return 1;
        }
        if (fruit != null) {
            DFEncyclopediaEntry template = fruit.getRandomElements((IWorld)player.func_71121_q());
            Optional<Object> shape = Optional.empty();
            Optional<Object> baseColor = Optional.empty();
            Optional<Object> stemColor = Optional.empty();
            int maxRolls = 2;
            if (player.func_70681_au().nextInt(100) < 10) {
                maxRolls = 3;
            }
            for (int i = 0; i < rolls; ++i) {
                int rand = player.func_70681_au().nextInt(3);
                if (rand == 0) {
                    shape = template.getShape();
                    continue;
                }
                if (rand == 1) {
                    baseColor = template.getBaseColor();
                    continue;
                }
                stemColor = template.getStemColor();
            }
            ItemStack stack = new ItemStack((IItemProvider)Items.field_151121_aF);
            String key = fruit.getFruitKey();
            CompoundNBT nbt = stack.func_190925_c("fruitClues");
            nbt.func_74778_a("key", key);
            if (shape.isPresent()) {
                nbt.func_74768_a("shape", ((Integer)shape.get()).intValue());
            }
            if (baseColor.isPresent()) {
                nbt.func_74768_a("baseColor", ((Color)baseColor.get()).getRGB());
            }
            if (stemColor.isPresent()) {
                nbt.func_74768_a("stemColor", ((Color)stemColor.get()).getRGB());
            }
            stack.func_200302_a((ITextComponent)new TranslationTextComponent(ModI18n.ITEM_FRUIT_CLUE));
            stack.func_190920_e(1);
            player.func_191521_c(stack);
        }
        return -1;
    }

    private static int stressTestBlocks(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        long startTime = System.currentTimeMillis();
        int i = 0;
        try {
            for (int x = -50; x < 50; ++x) {
                for (int y = -50; y < 50; ++y) {
                    for (int z = -50; z < 50; ++z) {
                        WyHelper.setBlockStateInChunk(player.field_70170_p, player.func_233580_cy_().func_177982_a(x, y, z), Blocks.field_150346_d.func_176223_P(), 2);
                        ++i;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long stopTime = System.currentTimeMillis();
        System.out.println("Finished generating " + i + " blocks after " + (stopTime - startTime) + " millis");
        return 1;
    }

    private static int stressTestSpawners(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        ServerWorld world = player.func_71121_q();
        for (int i = -3; i < 3; ++i) {
            for (int j = -3; j < 3; ++j) {
                BlockPos pos = player.func_233580_cy_().func_177982_a(i, 0, j);
                world.func_175656_a(pos, ((Block)ModBlocks.CUSTOM_SPAWNER.get()).func_176223_P());
                CustomSpawnerTileEntity spawner = (CustomSpawnerTileEntity)world.func_175625_s(pos);
                spawner.setSpawnerLimit(2);
                spawner.setSpawnerMob((EntityType)ModEntities.MARINE_GRUNT.get());
            }
        }
        return 1;
    }

    private static int checkStructures(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        int[] arr = StructuresHelper.STRUCTURES_COUNT;
        int sum = 0;
        for (int i : arr) {
            sum += i;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("========SHIPS==================================\n\n");
        builder.append("Small Pirate Ships: " + arr[0] + "\n");
        builder.append("Medium Pirate Ships: " + arr[1] + "\n");
        builder.append("Large Pirate Ships: " + arr[2] + "\n");
        builder.append("Marine Battleships: " + arr[3] + "\n");
        builder.append("Ghost Ships: " + arr[4] + "\n\n");
        builder.append("========LAND STRUCTURES========================\n\n");
        builder.append("Marine Small Base: " + arr[5] + "\n");
        builder.append("Marine Large Base: " + arr[6] + "\n");
        builder.append("Bandit Small Base: " + arr[7] + "\n");
        builder.append("Bandit Large Base: " + arr[8] + "\n");
        builder.append("Dojos: " + arr[9] + "\n");
        builder.append("Marine Camp: " + arr[12] + "\n");
        builder.append("Bandit Camp: " + arr[13] + "\n");
        builder.append("Marine Watch Tower: " + arr[10] + "\n");
        builder.append("========SKY STRUCTURES========================\n\n");
        builder.append("Sky Islands: " + arr[11] + "\n");
        builder.append("Total: " + sum + "\n");
        builder.append("===============================================");
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(builder.toString()), true);
        return 1;
    }

    private static int dropPackage(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        BountyHelper.issueBountyForAllPlayers(player.field_70170_p);
        WantedPosterPackageEntity posterPackage = new WantedPosterPackageEntity(player.field_70170_p);
        posterPackage.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_() + 5.0, player.func_226281_cx_());
        player.field_70170_p.func_217376_c((Entity)posterPackage);
        return 1;
    }

    private static int harcoreLoadout(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)ModAbilities.YOMI_YOMI_NO_MI));
        player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Blocks.field_150346_d, 64));
        player.func_71024_bL().func_75114_a(0);
        player.func_71024_bL().func_75119_b(0.0f);
        return 1;
    }

    private static String escapeSpecialCharacters(String data) {
        String escapedData = data.replaceAll("\\R", " ");
        if (data.contains(",") || data.contains("\"") || data.contains("'")) {
            data = data.replace("\"", "\"\"");
            escapedData = "\"" + data + "\"";
        }
        return escapedData;
    }

    private static int showInfo(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        Collection clones = ModRegistries.ABILITIES.getValues();
        List noTextures = clones.stream().filter(abl -> {
            if (!abl.isHidden()) {
                String texture = WyHelper.getResourceName(abl.getIcon().func_110623_a());
                try {
                    boolean hasFile = new File(ModMain.getResourceFolderPath() + "/assets/" + "mineminenomi" + "/textures/abilities/" + texture + ".png").exists();
                    if (!hasFile) {
                        return true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return false;
        }).collect(Collectors.toList());
        StringBuilder builder = new StringBuilder();
        builder.append("Abilities Registered: " + clones.size());
        player.func_145747_a((ITextComponent)new StringTextComponent(builder.toString()), Util.field_240973_b_);
        return 1;
    }

    private static int loadStructure(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        PlacementSettings placement = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a((ChunkPos)null);
        placement.func_215219_b().func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215205_b).func_215222_a((StructureProcessor)new RandomizeSkyBlocksProcessor()).func_215222_a((StructureProcessor)new ReplaceWaterloggedStructureProcessor()).func_215222_a((StructureProcessor)new IntegrityProcessor(1.0f)).func_189950_a(new Random(Util.func_211177_b()));
        WyHelper.loadNBTStructure((ServerWorld)player.field_70170_p, "unaligned/medic_tent", player.func_233580_cy_(), placement);
        player.field_70170_p.func_180501_a(player.func_233580_cy_(), Blocks.field_150357_h.func_176223_P(), 3);
        player.func_145747_a((ITextComponent)new StringTextComponent("Done"), Util.field_240973_b_);
        return 1;
    }

    private static int saveStructure(CommandContext<CommandSource> context, BlockPos from, BlockPos to, String name, ServerPlayerEntity player) {
        for (int i = from.func_177958_n(); i < to.func_177958_n(); ++i) {
            for (int j = from.func_177956_o(); j < to.func_177956_o(); ++j) {
                for (int k = from.func_177952_p(); k < to.func_177952_p(); ++k) {
                    BlockPos pos = new BlockPos(i, j, k);
                    BlockState state = player.field_70170_p.func_180495_p(pos);
                    if (state.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
                        state = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false));
                        player.field_70170_p.func_175656_a(pos, state);
                    }
                    if (state.func_177230_c() == Blocks.field_189881_dj) {
                        player.field_70170_p.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 18);
                    }
                    if (state.func_177230_c() != Blocks.field_222422_lK) continue;
                    Direction dir = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
                    BlockState newState = ((Block)ModBlocks.DESIGN_BARREL.get()).func_176223_P();
                    newState = (BlockState)newState.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)dir);
                    player.field_70170_p.func_175656_a(pos, newState);
                }
            }
        }
        if (player.field_70170_p instanceof ServerWorld) {
            BlockPos size = to.func_177973_b((Vector3i)from);
            System.out.println("From: /tp " + from.func_177958_n() + " " + from.func_177956_o() + " " + from.func_177952_p());
            System.out.println("To: /tp " + to.func_177958_n() + " " + to.func_177956_o() + " " + to.func_177952_p());
            System.out.println("size: " + size);
            ArrayList<Block> bannedBlocks = new ArrayList<Block>();
            bannedBlocks.add(Blocks.field_150355_j);
            WyHelper.saveNBTStructure((ServerWorld)player.field_70170_p, name, from, size, bannedBlocks);
            player.func_145747_a((ITextComponent)new StringTextComponent("Done"), Util.field_240973_b_);
        }
        return 1;
    }

    private static int checkBounties(CommandContext<CommandSource> source) {
        ServerWorld world = ((CommandSource)source.getSource()).func_197023_e();
        ExtendedWorldData worldData = ExtendedWorldData.get((IWorld)world);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<UUID, Long> entry : worldData.getAllBounties().entrySet()) {
            UUID uuid = entry.getKey();
            PlayerEntity target = world.func_217371_b(uuid);
            sb.append(target.func_145748_c_().getString() + " " + entry.getValue());
        }
        ((CommandSource)source.getSource()).func_197030_a((ITextComponent)new StringTextComponent(sb.toString()), true);
        return 1;
    }

    private static int turnSwordInClone(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        ItemStack heldStack = player.func_184586_b(Hand.MAIN_HAND);
        if (!heldStack.func_190926_b()) {
            heldStack.func_196082_o().func_74757_a("isClone", true);
        }
        return 1;
    }

    private static int checkHakiStats(CommandContext<CommandSource> context, ServerPlayerEntity target) {
        IHakiData props = HakiDataCapability.get((LivingEntity)target);
        target.func_145747_a((ITextComponent)new StringTextComponent("Busoshoku: " + props.getBusoshokuHakiExp()), Util.field_240973_b_);
        target.func_145747_a((ITextComponent)new StringTextComponent("Observation: " + props.getKenbunshokuHakiExp()), Util.field_240973_b_);
        target.func_145747_a((ITextComponent)new StringTextComponent("Haoshoku (Total): " + props.getTotalHakiExp()), Util.field_240973_b_);
        target.func_145747_a((ITextComponent)new StringTextComponent("========================="), Util.field_240973_b_);
        if (WyDebug.isDebug()) {
            props.setHakiOveruse(0);
        }
        return 1;
    }
}

