/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.commands;

import com.google.common.base.Strings;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.pixelatedw.mineminenomi.api.OneFruitEntry;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.config.GeneralConfig;
import xyz.pixelatedw.mineminenomi.data.world.OFPWWorldData;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;

public class CheckFruitsCommand {
    private static final Comparator<OneFruitEntry> COMPARE_ENTRIES_ALPHABETICALLY = (o1, o2) -> {
        String fruitName1 = o1.getItemFromKey().map(item -> new TranslationTextComponent(item.func_77658_a()).getString()).orElse(o1.getKey().toString());
        String fruitName2 = o2.getItemFromKey().map(item -> new TranslationTextComponent(item.func_77658_a()).getString()).orElse(o2.getKey().toString());
        return fruitName1.compareToIgnoreCase(fruitName2);
    };
    private static final Comparator<Item> COMPARE_FRUITS_ALPHABETICALLY = (i1, i2) -> {
        String fruitName1 = new TranslationTextComponent(i1.func_77658_a()).getString();
        String fruitName2 = new TranslationTextComponent(i2.func_77658_a()).getString();
        return fruitName1.compareToIgnoreCase(fruitName2);
    };

    public static void register(CommandDispatcher<CommandSource> dispatcher, @Nullable LiteralArgumentBuilder<CommandSource> masterBuilder) {
        LiteralArgumentBuilder builder = Commands.func_197057_a((String)"check_fruits");
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.requires(source -> source.func_197034_c((Boolean)GeneralConfig.PUBLIC_CHECK_FRUITS.get() != false ? 0 : 2))).executes(context -> CheckFruitsCommand.checkFruitsInWorld((CommandContext<CommandSource>)context))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"fruit").requires(source -> source.func_197034_c((Boolean)GeneralConfig.PUBLIC_CHECK_FRUITS.get() != false ? 0 : 2))).then(Commands.func_197056_a((String)"fruit", (ArgumentType)ResourceLocationArgument.func_197197_a()).executes(context -> CheckFruitsCommand.checkFruitInWorld((CommandContext<CommandSource>)context, ResourceLocationArgument.func_197195_e((CommandContext)context, (String)"fruit")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"list").requires(source -> source.func_197034_c((Boolean)GeneralConfig.PUBLIC_CHECK_FRUITS.get() != false ? 0 : 2))).executes(context -> CheckFruitsCommand.checkFruitsInWorld((CommandContext<CommandSource>)context)))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"history").requires(source -> source.func_197034_c(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"fruit", (ArgumentType)ResourceLocationArgument.func_197197_a()).then(Commands.func_197057_a((String)"export").executes(context -> CheckFruitsCommand.exportFruitHistory((CommandContext<CommandSource>)context, ResourceLocationArgument.func_197195_e((CommandContext)context, (String)"fruit"))))).then(Commands.func_197056_a((String)"page", (ArgumentType)IntegerArgumentType.integer()).executes(context -> CheckFruitsCommand.fruitHistory((CommandContext<CommandSource>)context, ResourceLocationArgument.func_197195_e((CommandContext)context, (String)"fruit"), IntegerArgumentType.getInteger((CommandContext)context, (String)"page"))))).executes(context -> CheckFruitsCommand.fruitHistory((CommandContext<CommandSource>)context, ResourceLocationArgument.func_197195_e((CommandContext)context, (String)"fruit"), -1))));
        if (masterBuilder != null) {
            masterBuilder.then((ArgumentBuilder)builder);
        } else {
            dispatcher.register(builder);
        }
    }

    private static int checkFruitInWorld(CommandContext<CommandSource> context, ResourceLocation fruit) {
        if (!CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic()) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)ModI18n.COMMAND_CHECK_FRUIT_OFPW_ONLY);
            return 0;
        }
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        OFPWWorldData worldData = OFPWWorldData.get();
        OneFruitEntry entry = worldData.getOneFruitEntry(fruit);
        if (entry == null) {
            return 0;
        }
        Item fruitItem = (Item)ForgeRegistries.ITEMS.getValue(entry.getKey());
        if (fruitItem == null) {
            return 0;
        }
        StringBuilder builder = new StringBuilder();
        String fruitName = new TranslationTextComponent(fruitItem.func_77658_a()).getString();
        String status = CheckFruitsCommand.getStatusColor(entry);
        boolean hasPermission = ((CommandSource)context.getSource()).func_197034_c(2);
        builder.append("===============================================\n");
        if (hasPermission) {
            builder.append("\u00a7l\u00a76Fruit Name | Player Name | Status \u00a7r\n");
            String playerName = CheckFruitsCommand.getOwnerName(entry, (IWorld)world);
            builder.append(fruitName + " | " + playerName + " | " + status + "\n");
        } else {
            builder.append("\u00a7l\u00a76Fruit Name | Status \u00a7r\n");
            builder.append(fruitName + " | " + status + "\n");
        }
        builder.append("===============================================");
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(builder.toString()), false);
        return 0;
    }

    private static int exportFruitHistory(CommandContext<CommandSource> context, ResourceLocation fruit) {
        if (!CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic()) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)ModI18n.COMMAND_CHECK_FRUIT_OFPW_ONLY);
            return 0;
        }
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        OFPWWorldData worldData = OFPWWorldData.get();
        Optional<OneFruitEntry> oneFruit = worldData.getOneFruitEntries().stream().filter(entry -> entry.getKey().equals((Object)fruit)).findFirst();
        if (oneFruit.isPresent()) {
            StringBuilder builder = new StringBuilder();
            List<OneFruitEntry.HistoryEntry> history = oneFruit.get().getHistory();
            for (int i = 0; i < history.size(); ++i) {
                OneFruitEntry.HistoryEntry current = history.get(i);
                OneFruitEntry.HistoryEntry previous = history.get(MathHelper.func_76125_a((int)(i - 1), (int)0, (int)history.size()));
                String status = "";
                String owner = CheckFruitsCommand.getOwnerName(current, (IWorld)world);
                status = current == previous ? current.getStatus().name() : previous.getStatus().name() + " \u2192 " + current.getStatus().name();
                builder.append(current.getDate().toString() + ":\n");
                builder.append(status + " by " + owner + (!Strings.isNullOrEmpty((String)current.getStatusMessage()) ? " due to: " + current.getStatusMessage() : "") + "\n\n");
            }
            try {
                File exportFile;
                String path = System.getProperty("user.dir");
                File exportFolder = new File(path, "onefruit-exports");
                if (!exportFolder.exists()) {
                    exportFolder.mkdir();
                }
                if ((exportFile = new File(exportFolder, fruit + ".txt")).exists()) {
                    exportFile.delete();
                }
                exportFile.createNewFile();
                PrintWriter out = new PrintWriter(new FileWriter(exportFile, true));
                out.append(builder.toString());
                out.close();
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Exported file as " + fruit + ".txt"), false);
            }
            catch (Exception e) {
                e.printStackTrace();
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)ModI18n.COMMAND_CHECK_FRUIT_ERROR_EXPORTING, false);
            }
        }
        return 1;
    }

    private static int fruitHistory(CommandContext<CommandSource> context, ResourceLocation fruit, int page) {
        if (!CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic()) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)ModI18n.COMMAND_CHECK_FRUIT_OFPW_ONLY);
            return 0;
        }
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        OFPWWorldData worldData = OFPWWorldData.get();
        Optional<OneFruitEntry> oneFruit = worldData.getOneFruitEntries().stream().filter(entry -> entry.getKey().equals((Object)fruit)).findFirst();
        if (oneFruit.isPresent()) {
            StringBuilder builder = new StringBuilder();
            int elements = 100;
            List<OneFruitEntry.HistoryEntry> history = oneFruit.get().getHistory();
            if (page >= 0) {
                history = history.stream().skip(elements * page).limit(elements).collect(Collectors.toList());
            }
            builder.append("===============================================\n");
            builder.append("\u00a7l\u00a76" + oneFruit.get().getKey() + "'s History - Page " + (page + 1) + ":\u00a7r \n");
            for (int i = 0; i < history.size(); ++i) {
                OneFruitEntry.HistoryEntry current = history.get(i);
                OneFruitEntry.HistoryEntry previous = history.get(MathHelper.func_76125_a((int)(i - 1), (int)0, (int)history.size()));
                String status = "";
                String owner = CheckFruitsCommand.getOwnerName(current, (IWorld)world);
                status = current == previous ? CheckFruitsCommand.getStatusColor(current) : CheckFruitsCommand.getStatusColor(previous) + " \u2192 " + CheckFruitsCommand.getStatusColor(current);
                builder.append(current.getDate().toString() + ":\n");
                builder.append(status + " by " + owner + (!Strings.isNullOrEmpty((String)current.getStatusMessage()) ? " due to: " + current.getStatusMessage() : "") + "\n");
            }
            builder.append("===============================================");
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(builder.toString()), false);
        }
        return 1;
    }

    private static int checkFruitsInWorld(CommandContext<CommandSource> context) {
        if (!CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic()) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)ModI18n.COMMAND_CHECK_FRUIT_OFPW_ONLY);
            return 0;
        }
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        OFPWWorldData worldData = OFPWWorldData.get();
        StringBuilder builder = new StringBuilder();
        List foundKeys = worldData.getOneFruitEntries().stream().map(e -> e.getKey()).collect(Collectors.toList());
        List existingFruits = worldData.getOneFruitEntries().stream().sorted(COMPARE_ENTRIES_ALPHABETICALLY).collect(Collectors.toList());
        builder.append("===============================================\n");
        boolean hasPermission = ((CommandSource)context.getSource()).func_197034_c(2);
        if (hasPermission) {
            builder.append("\u00a7l\u00a76Fruit Name | Player Name | Status \u00a7r\n");
        } else {
            builder.append("\u00a7l\u00a76Fruit Name | Status \u00a7r\n");
        }
        for (OneFruitEntry entry : existingFruits) {
            String fruitName = entry.getItemFromKey().map(item -> new TranslationTextComponent(item.func_77658_a()).getString()).orElse(entry.getKey().toString());
            String status = CheckFruitsCommand.getStatusColor(entry);
            if (hasPermission) {
                String playerName = CheckFruitsCommand.getOwnerName(entry, (IWorld)world);
                builder.append(fruitName + " | " + playerName + " | " + status + "\n");
                continue;
            }
            builder.append(fruitName + " | " + status + "\n");
        }
        builder.append("\n");
        List registeredFruits = ModValues.DEVIL_FRUITS.stream().sorted(COMPARE_FRUITS_ALPHABETICALLY).collect(Collectors.toList());
        for (AkumaNoMiItem fruit : registeredFruits) {
            ResourceLocation key = fruit.getRegistryName();
            if (foundKeys.contains(key)) continue;
            builder.append(new TranslationTextComponent(fruit.func_77658_a()).getString() + " | \u00a75NEVER_FOUND\u00a7r\n");
        }
        builder.append("===============================================");
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(builder.toString()), false);
        return 1;
    }

    private static String getOwnerName(OneFruitEntry entry, IWorld world) {
        String playerName = "System";
        if (entry.getOwner().isPresent()) {
            playerName = world.func_217371_b(entry.getOwner().get()) != null ? world.func_217371_b(entry.getOwner().get()).func_145748_c_().getString() : (UsernameCache.getLastKnownUsername((UUID)entry.getOwner().get()) != null ? UsernameCache.getLastKnownUsername((UUID)entry.getOwner().get()) : "Unknown Player Name");
        }
        return playerName;
    }

    private static String getOwnerName(OneFruitEntry.HistoryEntry entry, IWorld world) {
        String playerName = "System";
        if (entry.getOwner().isPresent()) {
            playerName = world.func_217371_b(entry.getOwner().get()) != null ? world.func_217371_b(entry.getOwner().get()).func_145748_c_().getString() : (UsernameCache.getLastKnownUsername((UUID)entry.getOwner().get()) != null ? UsernameCache.getLastKnownUsername((UUID)entry.getOwner().get()) : "Unknown Player Name");
        }
        return playerName;
    }

    private static String getStatusColor(OneFruitEntry entry) {
        String status = entry.getStatus().name();
        if (entry.getStatus() == OneFruitEntry.Status.LOST) {
            status = "\u00a7c" + entry.getStatus().name() + "\u00a7r";
        } else if (entry.getStatus() == OneFruitEntry.Status.DROPPED) {
            status = "\u00a7d" + entry.getStatus().name() + "\u00a7r";
        } else if (entry.getStatus() == OneFruitEntry.Status.IN_USE || entry.getStatus() == OneFruitEntry.Status.INVENTORY) {
            status = "\u00a7a" + entry.getStatus().name() + "\u00a7r";
        }
        return status;
    }

    private static String getStatusColor(OneFruitEntry.HistoryEntry entry) {
        String status = entry.getStatus().name();
        if (entry.getStatus() == OneFruitEntry.Status.LOST) {
            status = "\u00a7c" + entry.getStatus().name() + "\u00a7r";
        } else if (entry.getStatus() == OneFruitEntry.Status.DROPPED) {
            status = "\u00a7d" + entry.getStatus().name() + "\u00a7r";
        } else if (entry.getStatus() == OneFruitEntry.Status.IN_USE || entry.getStatus() == OneFruitEntry.Status.INVENTORY) {
            status = "\u00a7a" + entry.getStatus().name() + "\u00a7r";
        }
        return status;
    }
}

