/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import xyz.pixelatedw.mineminenomi.api.charactercreator.FactionId;
import xyz.pixelatedw.mineminenomi.api.charactercreator.RaceId;
import xyz.pixelatedw.mineminenomi.api.charactercreator.StyleId;
import xyz.pixelatedw.mineminenomi.api.commands.FactionArgument;
import xyz.pixelatedw.mineminenomi.api.commands.FightingStyleArgument;
import xyz.pixelatedw.mineminenomi.api.commands.RaceArgument;
import xyz.pixelatedw.mineminenomi.commands.Requires;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.integrations.perms.WyPermissions;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class ChangeCharacterCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher, @Nullable LiteralArgumentBuilder<CommandSource> masterBuilder) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"change_character").requires(Requires.hasPermission(3, WyPermissions.CHANGE_CHARACTER_COMMAND));
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"faction").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"value", (ArgumentType)FactionArgument.faction()).executes(context -> ChangeCharacterCommand.changeFaction((CommandContext<CommandSource>)context, EntityArgument.func_197089_d((CommandContext)context, (String)"target"), FactionArgument.getFaction(context, "value"))))))).then(Commands.func_197057_a((String)"race").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"value", (ArgumentType)RaceArgument.race()).executes(context -> ChangeCharacterCommand.changeRace((CommandContext<CommandSource>)context, EntityArgument.func_197089_d((CommandContext)context, (String)"target"), RaceArgument.getRace(context, "value"))))))).then(Commands.func_197057_a((String)"style").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"value", (ArgumentType)FightingStyleArgument.fightingStyle()).executes(context -> ChangeCharacterCommand.changeStyle((CommandContext<CommandSource>)context, EntityArgument.func_197089_d((CommandContext)context, (String)"target"), FightingStyleArgument.getFightingStyle(context, "value"))))));
        if (masterBuilder != null) {
            masterBuilder.then((ArgumentBuilder)builder);
        } else {
            dispatcher.register(builder);
        }
    }

    private static int changeFaction(CommandContext<CommandSource> context, ServerPlayerEntity target, FactionId faction) throws CommandSyntaxException {
        IEntityStats entityStatsProps = EntityStatsCapability.get((LivingEntity)target);
        entityStatsProps.setFaction(faction.getRegistryName());
        WyNetwork.sendTo(new SSyncEntityStatsPacket(target.func_145782_y(), entityStatsProps), (PlayerEntity)target);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Changed " + target.func_145748_c_().getString() + "'s faction to " + faction.getRegistryName()), true);
        return 1;
    }

    private static int changeRace(CommandContext<CommandSource> context, ServerPlayerEntity target, RaceId race) throws CommandSyntaxException {
        IEntityStats entityStatsProps = EntityStatsCapability.get((LivingEntity)target);
        entityStatsProps.setRace(race.getRegistryName());
        WyNetwork.sendTo(new SSyncEntityStatsPacket(target.func_145782_y(), entityStatsProps), (PlayerEntity)target);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Changed " + target.func_145748_c_().getString() + "'s race to " + race.getRegistryName()), true);
        return 1;
    }

    private static int changeStyle(CommandContext<CommandSource> context, ServerPlayerEntity target, StyleId style) throws CommandSyntaxException {
        IEntityStats entityStatsProps = EntityStatsCapability.get((LivingEntity)target);
        entityStatsProps.setFightingStyle(style.getRegistryName());
        WyNetwork.sendTo(new SSyncEntityStatsPacket(target.func_145782_y(), entityStatsProps), (PlayerEntity)target);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Changed " + target.func_145748_c_().getString() + "'s fighting style to " + style.getRegistryName()), true);
        return 1;
    }
}

