/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import xyz.pixelatedw.mineminenomi.api.challenges.Challenge;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeCore;
import xyz.pixelatedw.mineminenomi.api.commands.ChallengeArgument;
import xyz.pixelatedw.mineminenomi.commands.Requires;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.ChallengesDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.IChallengesData;
import xyz.pixelatedw.mineminenomi.integrations.perms.WyPermissions;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncChallengeDataPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class ChallengeCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher, @Nullable LiteralArgumentBuilder<CommandSource> masterBuilder) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"challenge").requires(Requires.hasPermission(3, WyPermissions.CHALLENGE_COMMAND));
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"finish").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"challenge", (ArgumentType)ChallengeArgument.challenge()).executes(context -> ChallengeCommand.finishChallenge((CommandContext<CommandSource>)context, ChallengeArgument.getChallenge(context, "challenge"), ((CommandSource)context.getSource()).func_197035_h()))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> ChallengeCommand.finishChallenge((CommandContext<CommandSource>)context, ChallengeArgument.getChallenge(context, "challenge"), EntityArgument.func_197089_d((CommandContext)context, (String)"target"))))))).then(Commands.func_197057_a((String)"give").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"challenge", (ArgumentType)ChallengeArgument.challenge()).executes(context -> ChallengeCommand.giveChallenge((CommandContext<CommandSource>)context, ChallengeArgument.getChallenge(context, "challenge"), ((CommandSource)context.getSource()).func_197035_h()))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> ChallengeCommand.giveChallenge((CommandContext<CommandSource>)context, ChallengeArgument.getChallenge(context, "challenge"), EntityArgument.func_197089_d((CommandContext)context, (String)"target"))))))).then(Commands.func_197057_a((String)"unfinish").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"challenge", (ArgumentType)ChallengeArgument.challenge()).executes(context -> ChallengeCommand.unfinishChallenge((CommandContext<CommandSource>)context, ChallengeArgument.getChallenge(context, "challenge"), ((CommandSource)context.getSource()).func_197035_h()))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> ChallengeCommand.unfinishChallenge((CommandContext<CommandSource>)context, ChallengeArgument.getChallenge(context, "challenge"), EntityArgument.func_197089_d((CommandContext)context, (String)"target"))))))).then(Commands.func_197057_a((String)"remove").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"challenge", (ArgumentType)ChallengeArgument.challenge()).executes(context -> ChallengeCommand.removeChallenge((CommandContext<CommandSource>)context, ChallengeArgument.getChallenge(context, "challenge"), ((CommandSource)context.getSource()).func_197035_h()))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> ChallengeCommand.removeChallenge((CommandContext<CommandSource>)context, ChallengeArgument.getChallenge(context, "challenge"), EntityArgument.func_197089_d((CommandContext)context, (String)"target"))))));
        if (masterBuilder != null) {
            masterBuilder.then((ArgumentBuilder)builder);
        } else {
            dispatcher.register(builder);
        }
    }

    private static int unfinishChallenge(CommandContext<CommandSource> context, ChallengeCore core, ServerPlayerEntity player) {
        IChallengesData props = ChallengesDataCapability.get((PlayerEntity)player);
        Object challenge = props.getChallenge(core);
        if (challenge != null) {
            ((Challenge)challenge).setComplete((PlayerEntity)player, false);
            ((Challenge)challenge).resetBestTime();
            WyNetwork.sendTo(new SSyncChallengeDataPacket(player.func_145782_y(), props), (PlayerEntity)player);
        } else {
            player.func_145747_a((ITextComponent)new StringTextComponent("You haven't finished this challenge!"), Util.field_240973_b_);
        }
        return 1;
    }

    private static int finishChallenge(CommandContext<CommandSource> context, ChallengeCore core, ServerPlayerEntity player) {
        IChallengesData props = ChallengesDataCapability.get((PlayerEntity)player);
        Object challenge = props.getChallenge(core);
        if (challenge != null) {
            ((Challenge)challenge).setComplete((PlayerEntity)player, true);
            WyNetwork.sendTo(new SSyncChallengeDataPacket(player.func_145782_y(), props), (PlayerEntity)player);
        } else {
            player.func_145747_a((ITextComponent)new StringTextComponent("You don't have this challenge!"), Util.field_240973_b_);
        }
        return 1;
    }

    private static int giveChallenge(CommandContext<CommandSource> context, ChallengeCore core, ServerPlayerEntity player) {
        IChallengesData props = ChallengesDataCapability.get((PlayerEntity)player);
        if (!props.hasChallenge(core)) {
            props.addChallenge(core);
            WyNetwork.sendTo(new SSyncChallengeDataPacket(player.func_145782_y(), props), (PlayerEntity)player);
        } else {
            player.func_145747_a((ITextComponent)new StringTextComponent("You aleady have this challenge!"), Util.field_240973_b_);
        }
        return 1;
    }

    private static int removeChallenge(CommandContext<CommandSource> context, ChallengeCore core, ServerPlayerEntity player) {
        IChallengesData props = ChallengesDataCapability.get((PlayerEntity)player);
        if (props.hasChallenge(core)) {
            props.removeChallenge(core);
            WyNetwork.sendTo(new SSyncChallengeDataPacket(player.func_145782_y(), props), (PlayerEntity)player);
        } else {
            player.func_145747_a((ITextComponent)new StringTextComponent("You don't have this challenge!"), Util.field_240973_b_);
        }
        return 1;
    }
}

