/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.commands;

import com.google.common.base.Strings;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.protection.ProtectedArea;
import xyz.pixelatedw.mineminenomi.commands.Requires;
import xyz.pixelatedw.mineminenomi.data.world.ProtectedAreasData;
import xyz.pixelatedw.mineminenomi.integrations.perms.WyPermissions;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SViewProtectionPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyDebug;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;
import xyz.pixelatedw.mineminenomi.wypi.WyPatreon;

public class AbilityProtectionCommand {
    private static final String RESET = "\u00a7r";

    public static void register(CommandDispatcher<CommandSource> dispatcher, @Nullable LiteralArgumentBuilder<CommandSource> masterBuilder) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"abilityprotection").requires(Requires.hasPermission(3, WyPermissions.ABILITY_PROTECTION_COMMAND));
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"new").then(Commands.func_197056_a((String)"label", (ArgumentType)StringArgumentType.string()).then(Commands.func_197056_a((String)"size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)2048)).executes(context -> AbilityProtectionCommand.createProtection((CommandContext<CommandSource>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"size"), StringArgumentType.getString((CommandContext)context, (String)"label"))))))).then(Commands.func_197057_a((String)"resize").then(Commands.func_197056_a((String)"label", (ArgumentType)StringArgumentType.string()).then(Commands.func_197056_a((String)"size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)2048)).executes(context -> AbilityProtectionCommand.resizeProtection((CommandContext<CommandSource>)context, StringArgumentType.getString((CommandContext)context, (String)"label"), IntegerArgumentType.getInteger((CommandContext)context, (String)"size"))))))).then(Commands.func_197057_a((String)"rename").then(Commands.func_197056_a((String)"label", (ArgumentType)StringArgumentType.string()).then(Commands.func_197056_a((String)"new_label", (ArgumentType)StringArgumentType.string()).executes(context -> AbilityProtectionCommand.renameProtection((CommandContext<CommandSource>)context, StringArgumentType.getString((CommandContext)context, (String)"label"), StringArgumentType.getString((CommandContext)context, (String)"new_label"))))))).then(Commands.func_197057_a((String)"info").then(Commands.func_197056_a((String)"label", (ArgumentType)StringArgumentType.string()).executes(context -> AbilityProtectionCommand.printAreaInfo((CommandContext<CommandSource>)context, StringArgumentType.getString((CommandContext)context, (String)"label")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"props").then(Commands.func_197057_a((String)"block_destruction").then(Commands.func_197056_a((String)"label", (ArgumentType)StringArgumentType.string()).then(Commands.func_197056_a((String)"state", (ArgumentType)BoolArgumentType.bool()).executes(context -> AbilityProtectionCommand.changeBlockDestructionProp((CommandContext<CommandSource>)context, StringArgumentType.getString((CommandContext)context, (String)"label"), BoolArgumentType.getBool((CommandContext)context, (String)"state"))))))).then(Commands.func_197057_a((String)"entity_damage").then(Commands.func_197056_a((String)"label", (ArgumentType)StringArgumentType.string()).then(Commands.func_197056_a((String)"state", (ArgumentType)BoolArgumentType.bool()).executes(context -> AbilityProtectionCommand.changeEntityDamageProp((CommandContext<CommandSource>)context, StringArgumentType.getString((CommandContext)context, (String)"label"), BoolArgumentType.getBool((CommandContext)context, (String)"state"))))))).then(Commands.func_197057_a((String)"block_restoration").then(Commands.func_197056_a((String)"label", (ArgumentType)StringArgumentType.string()).then(Commands.func_197056_a((String)"state", (ArgumentType)BoolArgumentType.bool()).executes(context -> AbilityProtectionCommand.changeBlockRestorationProp((CommandContext<CommandSource>)context, StringArgumentType.getString((CommandContext)context, (String)"label"), BoolArgumentType.getBool((CommandContext)context, (String)"state"))))))).then(Commands.func_197057_a((String)"abilities_use").then(Commands.func_197056_a((String)"label", (ArgumentType)StringArgumentType.string()).then(Commands.func_197056_a((String)"state", (ArgumentType)BoolArgumentType.bool()).executes(context -> AbilityProtectionCommand.changeAbilitiesUsageProp((CommandContext<CommandSource>)context, StringArgumentType.getString((CommandContext)context, (String)"label"), BoolArgumentType.getBool((CommandContext)context, (String)"state"))))))).then(Commands.func_197057_a((String)"stat_loss").then(Commands.func_197056_a((String)"label", (ArgumentType)StringArgumentType.string()).then(Commands.func_197056_a((String)"state", (ArgumentType)BoolArgumentType.bool()).executes(context -> AbilityProtectionCommand.changeStatLossProp((CommandContext<CommandSource>)context, StringArgumentType.getString((CommandContext)context, (String)"label"), BoolArgumentType.getBool((CommandContext)context, (String)"state"))))))).then(Commands.func_197057_a((String)"death").then(Commands.func_197056_a((String)"label", (ArgumentType)StringArgumentType.string()).then(Commands.func_197056_a((String)"state", (ArgumentType)BoolArgumentType.bool()).executes(context -> AbilityProtectionCommand.changeDeathProp((CommandContext<CommandSource>)context, StringArgumentType.getString((CommandContext)context, (String)"label"), BoolArgumentType.getBool((CommandContext)context, (String)"state"))))))).then(Commands.func_197057_a((String)"unconscious_time").then(Commands.func_197056_a((String)"label", (ArgumentType)StringArgumentType.string()).then(Commands.func_197056_a((String)"time", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1200)).executes(context -> AbilityProtectionCommand.changeUnconsciousTimeProp((CommandContext<CommandSource>)context, StringArgumentType.getString((CommandContext)context, (String)"label"), IntegerArgumentType.getInteger((CommandContext)context, (String)"time"))))))).then(Commands.func_197057_a((String)"restoration_interval").then(Commands.func_197056_a((String)"label", (ArgumentType)StringArgumentType.string()).then(Commands.func_197056_a((String)"interval", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1200)).executes(context -> AbilityProtectionCommand.changeRestorationIntervalProp((CommandContext<CommandSource>)context, StringArgumentType.getString((CommandContext)context, (String)"label"), IntegerArgumentType.getInteger((CommandContext)context, (String)"interval"))))))).then(Commands.func_197057_a((String)"restoration_amount").then(Commands.func_197056_a((String)"label", (ArgumentType)StringArgumentType.string()).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)500)).executes(context -> AbilityProtectionCommand.changeRestorationAmountProp((CommandContext<CommandSource>)context, StringArgumentType.getString((CommandContext)context, (String)"label"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"))))))).then(Commands.func_197057_a((String)"restoration_distance").then(Commands.func_197056_a((String)"label", (ArgumentType)StringArgumentType.string()).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000)).executes(context -> AbilityProtectionCommand.changeRestorationDistanceProp((CommandContext<CommandSource>)context, StringArgumentType.getString((CommandContext)context, (String)"label"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))))).then(Commands.func_197057_a((String)"view").then(Commands.func_197056_a((String)"state", (ArgumentType)BoolArgumentType.bool()).executes(context -> AbilityProtectionCommand.viewProtection((CommandContext<CommandSource>)context, BoolArgumentType.getBool((CommandContext)context, (String)"state")))))).then(Commands.func_197057_a((String)"list").executes(context -> AbilityProtectionCommand.listProtections((CommandContext<CommandSource>)context)))).then(Commands.func_197057_a((String)"remove").then(Commands.func_197056_a((String)"label", (ArgumentType)StringArgumentType.string()).executes(context -> AbilityProtectionCommand.deleteProtection((CommandContext<CommandSource>)context, StringArgumentType.getString((CommandContext)context, (String)"label")))));
        if (masterBuilder != null) {
            masterBuilder.then((ArgumentBuilder)builder);
        } else {
            dispatcher.register(builder);
        }
    }

    private static int printAreaInfo(CommandContext<CommandSource> ctx, String label) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
        ServerWorld world = ((CommandSource)ctx.getSource()).func_197023_e();
        ProtectedAreasData worldData = ProtectedAreasData.get((World)world);
        ProtectedArea area = worldData.getProtectedArea(label);
        StringTextComponent comp = new StringTextComponent("");
        comp.func_240702_b_("Label: " + area.getLabel() + "\n");
        comp.func_240702_b_("Size: " + area.getSize() + "\n");
        comp.func_240702_b_("Can Destroy Blocks: ");
        AbilityProtectionCommand.addInfoOption((IFormattableTextComponent)comp, area.canDestroyBlocks());
        comp.func_240702_b_("Can Restore Blocks: ");
        AbilityProtectionCommand.addInfoOption((IFormattableTextComponent)comp, area.canRestoreBlocks());
        comp.func_240702_b_("Restoration Amount: " + area.getRestoreAmount() + "\n");
        comp.func_240702_b_("Restoration Interval (ticks): " + area.getRestoreInterval() + "\n");
        comp.func_240702_b_("Restoration Distance: " + area.getRestoreDistance() + "\n");
        comp.func_240702_b_("Can Hurt Entities: ");
        AbilityProtectionCommand.addInfoOption((IFormattableTextComponent)comp, area.canHurtEntities());
        comp.func_240702_b_("Can Use Abilities: ");
        AbilityProtectionCommand.addInfoOption((IFormattableTextComponent)comp, area.canAbilitiesBeUsed());
        comp.func_240702_b_("Can Lose Stats: ");
        AbilityProtectionCommand.addInfoOption((IFormattableTextComponent)comp, area.canLoseStats());
        comp.func_240702_b_("Can Die: ");
        AbilityProtectionCommand.addInfoOption((IFormattableTextComponent)comp, area.canDie());
        comp.func_240702_b_("Unconscious Time (ticks): " + area.getUnconsciousTime() + "\n");
        if (WyDebug.isDebug() || !WyPatreon.isReleaseBuild()) {
            comp.func_240702_b_("Restoration Queue: " + area.getRestorationMap().size());
        }
        player.func_145747_a((ITextComponent)comp, Util.field_240973_b_);
        return 1;
    }

    private static IFormattableTextComponent addInfoOption(IFormattableTextComponent comp, boolean option) {
        Style button1Style = Style.field_240709_b_.func_240712_a_(option ? TextFormatting.GREEN : TextFormatting.RED);
        Style button2Style = Style.field_240709_b_.func_240712_a_(!option ? TextFormatting.GREEN : TextFormatting.RED);
        comp.func_230529_a_((ITextComponent)new StringTextComponent("[true]").func_240703_c_(button1Style));
        comp.func_240702_b_(String.format("%s/", RESET));
        comp.func_230529_a_((ITextComponent)new StringTextComponent("[false]").func_240703_c_(button2Style));
        comp.func_240702_b_(String.format("%s\n", RESET));
        return comp;
    }

    private static int changeRestorationAmountProp(CommandContext<CommandSource> ctx, String label, int amount) {
        ServerWorld world = ((CommandSource)ctx.getSource()).func_197023_e();
        ProtectedAreasData worldData = ProtectedAreasData.get((World)world);
        ProtectedArea area = worldData.getProtectedArea(label);
        area.setRestoreAmount(amount);
        worldData.func_76185_a();
        return 1;
    }

    private static int changeRestorationDistanceProp(CommandContext<CommandSource> ctx, String label, int amount) {
        ServerWorld world = ((CommandSource)ctx.getSource()).func_197023_e();
        ProtectedAreasData worldData = ProtectedAreasData.get((World)world);
        ProtectedArea area = worldData.getProtectedArea(label);
        area.setRestoreDistance(amount);
        worldData.func_76185_a();
        return 1;
    }

    private static int changeRestorationIntervalProp(CommandContext<CommandSource> ctx, String label, int interval) {
        ServerWorld world = ((CommandSource)ctx.getSource()).func_197023_e();
        ProtectedAreasData worldData = ProtectedAreasData.get((World)world);
        ProtectedArea area = worldData.getProtectedArea(label);
        area.setRestoreInterval(interval);
        worldData.func_76185_a();
        return 1;
    }

    private static int changeAbilitiesUsageProp(CommandContext<CommandSource> ctx, String label, boolean state) {
        ServerWorld world = ((CommandSource)ctx.getSource()).func_197023_e();
        ProtectedAreasData worldData = ProtectedAreasData.get((World)world);
        ProtectedArea area = worldData.getProtectedArea(label);
        area.setAbilitiesUsage(state);
        worldData.func_76185_a();
        return 1;
    }

    private static int changeBlockDestructionProp(CommandContext<CommandSource> ctx, String label, boolean state) {
        ServerWorld world = ((CommandSource)ctx.getSource()).func_197023_e();
        ProtectedAreasData worldData = ProtectedAreasData.get((World)world);
        ProtectedArea area = worldData.getProtectedArea(label);
        area.setBlockDestruction(state);
        worldData.func_76185_a();
        return 1;
    }

    private static int changeEntityDamageProp(CommandContext<CommandSource> ctx, String label, boolean state) {
        ServerWorld world = ((CommandSource)ctx.getSource()).func_197023_e();
        ProtectedAreasData worldData = ProtectedAreasData.get((World)world);
        ProtectedArea area = worldData.getProtectedArea(label);
        area.setEntityDamage(state);
        worldData.func_76185_a();
        return 1;
    }

    private static int changeBlockRestorationProp(CommandContext<CommandSource> ctx, String label, boolean state) {
        ServerWorld world = ((CommandSource)ctx.getSource()).func_197023_e();
        ProtectedAreasData worldData = ProtectedAreasData.get((World)world);
        ProtectedArea area = worldData.getProtectedArea(label);
        area.setBlockRestoration(state);
        worldData.func_76185_a();
        return 1;
    }

    private static int changeStatLossProp(CommandContext<CommandSource> ctx, String label, boolean state) {
        ServerWorld world = ((CommandSource)ctx.getSource()).func_197023_e();
        ProtectedAreasData worldData = ProtectedAreasData.get((World)world);
        ProtectedArea area = worldData.getProtectedArea(label);
        area.setStatLoss(state);
        worldData.func_76185_a();
        return 1;
    }

    private static int changeDeathProp(CommandContext<CommandSource> ctx, String label, boolean state) {
        ServerWorld world = ((CommandSource)ctx.getSource()).func_197023_e();
        ProtectedAreasData worldData = ProtectedAreasData.get((World)world);
        ProtectedArea area = worldData.getProtectedArea(label);
        area.setDeath(state);
        worldData.func_76185_a();
        return 1;
    }

    private static int changeUnconsciousTimeProp(CommandContext<CommandSource> ctx, String label, int time) {
        ServerWorld world = ((CommandSource)ctx.getSource()).func_197023_e();
        ProtectedAreasData worldData = ProtectedAreasData.get((World)world);
        ProtectedArea area = worldData.getProtectedArea(label);
        area.setUnconsciousTime(time);
        worldData.func_76185_a();
        return 1;
    }

    private static int resizeProtection(CommandContext<CommandSource> context, String label, int size) throws CommandSyntaxException {
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        ProtectedAreasData worldData = ProtectedAreasData.get((World)world);
        worldData.resizeRestrictedArea(label, size);
        return 1;
    }

    private static int renameProtection(CommandContext<CommandSource> context, String label, String newLabel) throws CommandSyntaxException {
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        ProtectedAreasData worldData = ProtectedAreasData.get((World)world);
        ProtectedArea area = worldData.getProtectedArea(label);
        worldData.removeRestrictedArea(label);
        area.setLabel(newLabel);
        worldData.addRestrictedArea(area);
        return 1;
    }

    private static int deleteProtection(CommandContext<CommandSource> context, String label) throws CommandSyntaxException {
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        ProtectedAreasData worldData = ProtectedAreasData.get((World)world);
        worldData.removeRestrictedArea(label);
        return 1;
    }

    private static int listProtections(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        ProtectedAreasData worldData = ProtectedAreasData.get((World)world);
        IFormattableTextComponent list = new StringTextComponent("Protection Sites: \n\n").func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN));
        int i = 1;
        for (ProtectedArea area : worldData.getAllRestrictions().values()) {
            int midX = area.getCenter().func_177958_n();
            int midY = area.getCenter().func_177956_o();
            int midZ = area.getCenter().func_177952_p();
            String label = "";
            if (!Strings.isNullOrEmpty((String)area.getLabel())) {
                label = "(" + area.getLabel() + ")";
            }
            Style style = Style.field_240709_b_.func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tp @p " + midX + " " + midY + " " + midZ));
            list.func_230529_a_((ITextComponent)new StringTextComponent(i + ". " + label + " " + midX + ", " + midY + ", " + midZ + "\n").func_230530_a_(style.func_240712_a_(i % 2 == 0 ? TextFormatting.GREEN : TextFormatting.DARK_GREEN)));
            ++i;
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)list, true);
        return 1;
    }

    private static int viewProtection(CommandContext<CommandSource> context, boolean state) throws CommandSyntaxException {
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        ProtectedAreasData worldData = ProtectedAreasData.get((World)world);
        WyNetwork.sendTo(new SViewProtectionPacket(state, worldData.getAllRestrictions()), (PlayerEntity)player);
        return 1;
    }

    private static int createProtection(CommandContext<CommandSource> context, int size, String label) throws CommandSyntaxException {
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        ProtectedAreasData worldData = ProtectedAreasData.get((World)world);
        if (worldData.getProtectedArea(label) != null) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Protection with this name already exists!"));
            return -1;
        }
        Vector3d vec = ((CommandSource)context.getSource()).func_197036_d();
        BlockPos pos = new BlockPos(vec);
        worldData.addRestrictedArea(pos, size, label);
        StringBuilder builder = new StringBuilder();
        builder.append("Created an ability protection zone named " + label + " at " + pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p() + " of size " + size);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(builder.toString()), true);
        return 1;
    }
}

