/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.challenges.kriegpirates;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.challenges.ArenaStyle;
import xyz.pixelatedw.mineminenomi.api.challenges.Challenge;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeArena;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeCore;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeDifficulty;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.challenges.arenas.BaratieSimpleArena;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.kriegpirates.PearlEntity;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModChallenges;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModNPCGroups;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class PearlChallenge
extends Challenge {
    private static final String TITLE = WyRegistry.registerName("challenge.mineminenomi.krieg_pirates.pearl", "Pearl");
    public static final String OBJECTIVE = WyRegistry.registerName("challenge.mineminenomi.krieg_pirates.pearl.objective", "Defeat Pearl");
    public static final ResourceLocation REWARD = new ResourceLocation("mineminenomi", "rewards/pearl");
    public static final ChallengeCore<PearlChallenge> INSTANCE = new ChallengeCore.Builder<Challenge>("pearl", TITLE, OBJECTIVE, ModNPCGroups.KRIEG_PIRATES.getName(), PearlChallenge::new).setDifficulty(ChallengeDifficulty.STANDARD).setDifficultyStars(1).addArena(ArenaStyle.SIMPLE, BaratieSimpleArena.INSTANCE, BaratieSimpleArena::getChallengerSpawnPos, BaratieSimpleArena::getEnemySpawnPos).setEnemySpawns(PearlChallenge::setEnemeySpawns).setTargetShowcase(PearlChallenge::createPearlShowcase).setTimeLimit(10).setOrder(ModChallenges.Order.PEARL).setRewards(REWARD).build();

    public PearlChallenge(ChallengeCore<PearlChallenge> core) {
        super(core);
    }

    public static Set<ChallengeArena.EnemySpawn> setEnemeySpawns(InProgressChallenge challenge, ChallengeArena.SpawnPosition[] spawns) {
        HashSet<ChallengeArena.EnemySpawn> set = new HashSet<ChallengeArena.EnemySpawn>();
        PearlEntity boss = new PearlEntity(challenge);
        set.add(new ChallengeArena.EnemySpawn((LivingEntity)boss, spawns[0]));
        return set;
    }

    public static LivingEntity createPearlShowcase(World world) {
        LivingEntity entity = (LivingEntity)((EntityType)ModEntities.PEARL.get()).func_200721_a(world);
        entity.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)ModArmors.PEARL_HAT.get()));
        entity.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)ModArmors.PEARL_ARMOR.get()));
        entity.func_184201_a(EquipmentSlotType.LEGS, new ItemStack((IItemProvider)ModArmors.PEARL_LEGS.get()));
        return entity;
    }
}

