/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.challenges.arenas.parts;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.challenges.ArenaPart;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;

public class TreePart
extends ArenaPart {
    private final ConfiguredFeature<?, ?> feature;
    private final int maxHeight;

    public TreePart(InProgressChallenge challenge, ConfiguredFeature<?, ?> feature, int maxHeight) {
        super(challenge);
        this.feature = feature;
        this.maxHeight = maxHeight;
    }

    @Override
    public Set<BlockPos> buildPart(ServerWorld world, BlockPos spawnPos) {
        if (!(this.feature.field_222738_b instanceof BaseTreeFeatureConfig)) {
            return new HashSet<BlockPos>();
        }
        HashSet trunkBlocks = new HashSet();
        HashSet foliageBlocks = new HashSet();
        HashSet decoratorBlocks = new HashSet();
        MutableBoundingBox bb = this.getChallenge().getArena().getArenaLimits();
        BaseTreeFeatureConfig config = (BaseTreeFeatureConfig)this.feature.field_222738_b;
        int trunkHeight = config.field_236678_g_.func_236917_a_(world.field_73012_v);
        int foliageHeight = config.field_236677_f_.func_230374_a_(world.field_73012_v, trunkHeight, config);
        int k = trunkHeight - foliageHeight;
        int foliageRadius = config.field_236677_f_.func_230376_a_(world.field_73012_v, k);
        int minHeight = 5;
        if (this.maxHeight >= trunkHeight || this.maxHeight >= minHeight) {
            List list = config.field_236678_g_.func_230382_a_((IWorldGenerationReader)world, world.field_73012_v, this.maxHeight, spawnPos, trunkBlocks, bb, config);
            list.forEach(foliage -> config.field_236677_f_.func_236752_a_((IWorldGenerationReader)world, world.field_73012_v, config, this.maxHeight, foliage, foliageHeight, foliageRadius, foliageBlocks, bb));
        }
        if (!(trunkBlocks.isEmpty() || foliageBlocks.isEmpty() || config.field_227370_o_.isEmpty())) {
            ArrayList trunkList = Lists.newArrayList(trunkBlocks);
            ArrayList foliageList = Lists.newArrayList(foliageBlocks);
            trunkList.sort(Comparator.comparingInt(Vector3i::func_177956_o));
            foliageList.sort(Comparator.comparingInt(Vector3i::func_177956_o));
            config.field_227370_o_.forEach(decorator -> decorator.func_225576_a_((ISeedReader)world, world.field_73012_v, trunkList, foliageList, decoratorBlocks, bb));
        }
        HashSet<BlockPos> treeBlocks = new HashSet<BlockPos>();
        treeBlocks.addAll(trunkBlocks);
        treeBlocks.addAll(foliageBlocks);
        treeBlocks.addAll(decoratorBlocks);
        return treeBlocks;
    }
}

