/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.challenges.arenas;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.challenges.ArenaStyle;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeArena;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.helpers.ChallengesHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.challenges.arenas.parts.JungleBorderPart;
import xyz.pixelatedw.mineminenomi.challenges.arenas.parts.SimpleBasePart;

public class JungleClearingSimpleArena
extends ChallengeArena {
    public static final JungleClearingSimpleArena INSTANCE = new JungleClearingSimpleArena();
    private static final int ARENA_SIZE_RADIUS = 50;
    private static final int ARENA_SIZE = 100;
    private int groundLevel = 32;

    private JungleClearingSimpleArena() {
        super(ArenaStyle.SIMPLE);
    }

    @Override
    public Set<BlockPos> buildArena(InProgressChallenge challenge) {
        HashSet blocks = Sets.newHashSet();
        int bottomLayerOffset = 49;
        BlockPos bottomLayer = challenge.getArenaPos().func_185334_h().func_177979_c(49);
        BlockPos groundLayer = bottomLayer.func_177981_b(18);
        this.groundLevel = groundLayer.func_177956_o();
        blocks.addAll(StructuresHelper.createCenteredFilledCube((World)challenge.getShard(), bottomLayer.func_177984_a(), 100, 17, 100, Blocks.field_150348_b.func_176223_P(), 0, null));
        blocks.addAll(StructuresHelper.createCenteredFilledCube((World)challenge.getShard(), bottomLayer.func_177981_b(17), 100, 1, 100, Blocks.field_196658_i.func_176223_P(), 0, null));
        blocks.addAll(new JungleBorderPart(challenge, 50).buildPart(challenge.getShard(), groundLayer));
        blocks.addAll(new SimpleBasePart(challenge).buildPart(challenge.getShard(), challenge.getArenaPos()));
        return blocks;
    }

    @Override
    public int getGroundLevel() {
        return this.groundLevel;
    }

    @Override
    public MutableBoundingBox getArenaLimits() {
        return new MutableBoundingBox(-50, -50, -50, 50, 50, 50);
    }

    public static ChallengeArena.SpawnPosition getChallengerSpawnPos(int posId, InProgressChallenge challenge) {
        BlockPos pos = new BlockPos(challenge.getArenaPos().func_177958_n() + 15 - (posId + 1), challenge.getArenaPos().func_177956_o() - 30, challenge.getArenaPos().func_177952_p() + 15);
        return new ChallengeArena.SpawnPosition(pos, 135.0f, 0.0f);
    }

    public static ChallengeArena.SpawnPosition[] getEnemySpawnPos(InProgressChallenge challenge) {
        BlockPos pos1 = new BlockPos(challenge.getArenaPos().func_177958_n() - 15, challenge.getArenaPos().func_177956_o() - 30, challenge.getArenaPos().func_177952_p() - 15);
        return ChallengesHelper.get4DefaultSpawnPoints(pos1, 140.0f);
    }
}

