/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.blocks.traps;

import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;

public abstract class TrapAbilityBlock
extends Block {
    private int damageDealt = 0;
    private double horizontalFallSpeed = 0.05;
    private double verticalFallSpeed = 0.25;
    private DamageSource damageSource = new ModDamageSource(DamageSource.field_76368_d).setUnavoidable();
    private Supplier<EffectInstance> potionEffect = null;

    public TrapAbilityBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity) {
            if (!this.check((LivingEntity)entity)) {
                entity.func_213295_a(state, new Vector3d(this.getHorizontalFallSpeed(), this.getVerticalFallSpeed(), this.getHorizontalFallSpeed()));
            }
        } else if (entity instanceof BoatEntity) {
            entity.func_70106_y();
        } else {
            entity.func_213295_a(state, new Vector3d(this.getVerticalFallSpeed(), this.getHorizontalFallSpeed(), this.getVerticalFallSpeed()));
        }
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        LivingEntity living;
        Entity entity = context.getEntity();
        if (entity instanceof LivingEntity && this.check(living = (LivingEntity)entity)) {
            return state.func_196954_c(worldIn, pos);
        }
        return VoxelShapes.func_197880_a();
    }

    public int getDamageDealt() {
        return this.damageDealt;
    }

    public void setDamageDealt(int damageDealt) {
        this.damageDealt = damageDealt;
    }

    public double getVerticalFallSpeed() {
        return this.verticalFallSpeed;
    }

    public void setVerticalFallSpeed(double verticalFallSpeed) {
        this.verticalFallSpeed = verticalFallSpeed;
    }

    public DamageSource getDamageSource() {
        return this.damageSource;
    }

    public void setDamageSource(DamageSource damageSource) {
        this.damageSource = damageSource;
    }

    public EffectInstance getPotionEffect() {
        return this.potionEffect.get();
    }

    public void setPotionEffect(Supplier<EffectInstance> potionEffect) {
        this.potionEffect = potionEffect;
    }

    public abstract boolean check(LivingEntity var1);

    public boolean func_181623_g() {
        return false;
    }

    public double getHorizontalFallSpeed() {
        return this.horizontalFallSpeed;
    }

    public void setHorizontalFallSpeed(double horizontalFallSpeed) {
        this.horizontalFallSpeed = horizontalFallSpeed;
    }

    public static boolean isEntityInsideOpaqueBlock(LivingEntity e, int offSet) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int i = 0; i < 8; ++i) {
            int j = MathHelper.func_76128_c((double)(e.func_226278_cu_() - (double)offSet + (double)(((float)((i >> 0) % 2) - 0.5f) * 0.1f) + (double)e.func_70047_e()));
            int k = MathHelper.func_76128_c((double)(e.func_226277_ct_() + (double)(((float)((i >> 1) % 2) - 0.5f) * e.func_213302_cg() * 0.8f)));
            int l = MathHelper.func_76128_c((double)(e.func_226281_cx_() + (double)(((float)((i >> 2) % 2) - 0.5f) * e.func_213311_cf() * 0.8f)));
            if (blockpos$mutable.func_177958_n() == k && blockpos$mutable.func_177956_o() == j && blockpos$mutable.func_177952_p() == l) continue;
            blockpos$mutable.func_181079_c(k, j, l);
            if (!(e.field_70170_p.func_180495_p((BlockPos)blockpos$mutable).func_177230_c() instanceof TrapAbilityBlock)) continue;
            return true;
        }
        return false;
    }
}

