/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.enums.CanvasSize;
import xyz.pixelatedw.mineminenomi.api.events.FlagDestroyedEvent;
import xyz.pixelatedw.mineminenomi.api.events.FlagPlacedEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.BlocksHelper;
import xyz.pixelatedw.mineminenomi.blocks.tileentities.FlagTileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.items.FlagItem;
import xyz.pixelatedw.mineminenomi.packets.server.SSetFlagOnFirePacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class FlagBlock
extends Block {
    private static final int[] SCALE_XZ = new int[]{1, 3, 6, 9};
    private static final int[] SCALE_Y = new int[]{1, 2, 4, 6};
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<CanvasSize> SIZE = BlocksHelper.SIZE;

    public FlagBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151580_n).func_200943_b(0.2f).func_226896_b_().func_235842_b_(BlocksHelper::never));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(SIZE, (Comparable)((Object)CanvasSize.SMALL)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197868_b();
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader level, BlockPos pos, ISelectionContext context) {
        Entity entity = context.getEntity();
        if (entity instanceof ProjectileEntity) {
            return state.func_196954_c(level, pos);
        }
        return VoxelShapes.func_197880_a();
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        BlockState supportBlock = world.func_180495_p(pos.func_177971_a(((Direction)state.func_177229_b((Property)FACING)).func_176734_d().func_176730_m()));
        return supportBlock.func_185904_a().func_76218_k();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = this.func_176223_P();
        BlockPos blockpos = context.func_195995_a();
        Direction[] adirection = context.func_196009_e();
        CanvasSize size = CanvasSize.values()[context.func_195996_i().func_196082_o().func_74762_e("canvasSize")];
        blockstate = (BlockState)blockstate.func_206870_a(SIZE, (Comparable)((Object)size));
        for (Direction direction : adirection) {
            if (!direction.func_176740_k().func_176722_c()) continue;
            Direction direction1 = direction.func_176734_d();
            blockstate = (BlockState)blockstate.func_206870_a((Property)FACING, (Comparable)direction1);
            BlockState supportBlock = context.func_195991_k().func_180495_p(blockpos.func_177971_a(((Direction)blockstate.func_177229_b((Property)FACING)).func_176734_d().func_176730_m()));
            if (supportBlock.func_177230_c() == ModBlocks.FLAG.get()) {
                return null;
            }
            if (!blockstate.func_196955_c((IWorldReader)context.func_195991_k(), blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    public void func_176208_a(World level, BlockPos pos, BlockState state, PlayerEntity player) {
        this.breakFlag((IWorld)level, pos, (LivingEntity)player);
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FlagTileEntity();
    }

    @Deprecated
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return new ArrayList<ItemStack>();
    }

    public void func_220066_a(World level, BlockState state, BlockRayTraceResult hit, ProjectileEntity projectile) {
        TileEntity tileEntity;
        if (level.field_72995_K) {
            return;
        }
        boolean fireFlag = projectile.func_70027_ad();
        boolean waterFlag = false;
        if (projectile instanceof AbilityProjectileEntity && ((AbilityProjectileEntity)projectile).getParent() != null) {
            fireFlag = projectile.func_70027_ad() || ((AbilityProjectileEntity)projectile).getParent().getSourceElement().equals((Object)SourceElement.FIRE);
            waterFlag = ((AbilityProjectileEntity)projectile).getParent().getSourceElement().equals((Object)SourceElement.WATER);
        }
        if ((fireFlag || waterFlag) && (tileEntity = level.func_175625_s(hit.func_216350_a())) != null && tileEntity instanceof FlagTileEntity) {
            FlagTileEntity flagTile = (FlagTileEntity)tileEntity;
            if (flagTile.isSub()) {
                flagTile = flagTile.getMaster();
            }
            BlockPos masterTilePos = flagTile.func_174877_v();
            if (fireFlag) {
                flagTile.setOnFire(true);
                flagTile.setLastAttacker((Entity)projectile);
                WyNetwork.sendToAllAroundDistance(new SSetFlagOnFirePacket(masterTilePos, true), level, hit.func_216347_e(), 256);
            } else if (waterFlag) {
                flagTile.setOnFire(false);
                WyNetwork.sendToAllAroundDistance(new SSetFlagOnFirePacket(masterTilePos, false), level, hit.func_216347_e(), 256);
            }
        }
    }

    public void func_180633_a(World level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tileEntity = level.func_175625_s(pos);
        if (tileEntity != null && tileEntity instanceof FlagTileEntity) {
            FlagPlacedEvent event;
            FlagTileEntity flagTile = (FlagTileEntity)tileEntity;
            flagTile.setOwner(placer);
            if (stack.func_77942_o()) {
                Crew crew = Crew.from(stack.func_77978_p().func_74775_l("crew"));
                flagTile.setCrew(crew);
            }
            boolean drop = false;
            if (placer != null && placer instanceof PlayerEntity) {
                drop = ((PlayerEntity)placer).field_71075_bZ.field_75098_d;
            }
            FlagBlock.placeSubs((IWorld)level, pos, state, drop);
            if (placer != null && placer instanceof PlayerEntity && MinecraftForge.EVENT_BUS.post((Event)(event = new FlagPlacedEvent((PlayerEntity)placer, state, pos, flagTile)))) {
                level.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
            }
        }
    }

    public static void placeSubs(IWorld world, BlockPos pos, BlockState state, boolean drop) {
        FlagTileEntity flagTile = (FlagTileEntity)world.func_175625_s(pos);
        Direction dir = (Direction)state.func_177229_b((Property)FACING);
        CanvasSize size = (CanvasSize)((Object)state.func_177229_b(SIZE));
        if (size.ordinal() > CanvasSize.SMALL.ordinal()) {
            int xzSize = SCALE_XZ[size.ordinal()];
            int ySize = SCALE_Y[size.ordinal()];
            for (int y = 0; y < ySize; ++y) {
                for (int xz = 0; xz < xzSize; ++xz) {
                    if (y == 0 && xz == 0) continue;
                    BlockPos pos2 = pos.func_177967_a(dir, xz).func_177982_a(0, -y, 0);
                    boolean isAir = world.func_180495_p(pos2).func_196958_f();
                    if (isAir && world.func_180501_a(pos2, ((Block)ModBlocks.FLAG.get()).func_176223_P(), 3)) {
                        FlagTileEntity subFlagTile = (FlagTileEntity)world.func_175625_s(pos2);
                        if (subFlagTile == null) continue;
                        subFlagTile.setMaster(flagTile);
                        flagTile.addSub(pos2);
                        continue;
                    }
                    flagTile.breakAllBlocks(drop);
                    return;
                }
            }
        }
    }

    private void breakFlag(IWorld level, BlockPos pos, @Nullable LivingEntity entity) {
        TileEntity tileEntity = level.func_175625_s(pos);
        if (tileEntity != null && tileEntity instanceof FlagTileEntity) {
            FlagTileEntity flagEntity = (FlagTileEntity)tileEntity;
            if (flagEntity.isSub()) {
                flagEntity = flagEntity.getMaster();
            }
            if (flagEntity == null) {
                return;
            }
            BlockState masterState = level.func_180495_p((flagEntity = flagEntity.getMaster()).func_174877_v());
            if (masterState.func_196958_f()) {
                return;
            }
            ItemStack flagStack = new ItemStack((IItemProvider)ModBlocks.FLAG.get());
            if (masterState.func_235901_b_(SIZE)) {
                FlagItem.setCanvasSize(flagStack, (CanvasSize)((Object)masterState.func_177229_b(SIZE)));
            }
            boolean drop = false;
            if (entity != null && entity instanceof PlayerEntity) {
                drop = ((PlayerEntity)entity).field_71075_bZ.field_75098_d;
            }
            if (level instanceof World && !drop) {
                ItemEntity itemDrop = new ItemEntity((World)level, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), flagStack);
                level.func_217376_c((Entity)itemDrop);
            }
            flagEntity.breakAllBlocks(drop);
            FlagDestroyedEvent event = new FlagDestroyedEvent(masterState, pos, flagEntity.getLastAttacker(), flagEntity);
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return true;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (facing.func_176734_d() == state.func_177229_b((Property)FACING) && !state.func_196955_c((IWorldReader)world, currentPos)) {
            this.breakFlag(world, currentPos, null);
            return Blocks.field_150350_a.func_176223_P();
        }
        return state;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
        builder.func_206894_a(new Property[]{SIZE});
    }

    public boolean func_196266_a(BlockState pState, IBlockReader pLevel, BlockPos pPos, PathType pType) {
        return false;
    }
}

