/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.poi;

import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.LogManager;
import xyz.pixelatedw.mineminenomi.api.charactercreator.RaceId;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.poi.NewsEntry;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.entities.mobs.NotoriousEntity;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModRaces;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class TrackedNPC {
    private static final double MIN_DORIKI = 1000.0;
    private static final float MIN_OBS_HAKI = 10.0f;
    private static final float MIN_BUSO_HAKI = 10.0f;
    private static final long MIN_BOUNTY = 100000L;
    private static final ResourceLocation[] STYLES = new ResourceLocation[]{ModValues.SWORDSMAN, ModValues.BRAWLER, ModValues.BLACK_LEG, ModValues.SNIPER};
    private static final ResourceLocation[] RACES = new ResourceLocation[]{ModValues.HUMAN, ModValues.FISHMAN, ModValues.MINK};
    private UUID uuid;
    private Random random;
    private long seed;
    private long id;
    private Vector3d pos = Vector3d.field_186680_a;
    private long lastGameUpdate;
    private long lastNewsUpdate;
    private ResourceLocation faction = ModValues.EMPTY;
    private ResourceLocation race = ModValues.EMPTY;
    private ResourceLocation style = ModValues.EMPTY;
    private double doriki;
    private long bounty;
    private float kenbunshokuExp;
    private float busoshokuExp;
    private NewsEntry newsEntry;

    private TrackedNPC() {
    }

    public TrackedNPC(ServerWorld world, long id, ResourceLocation faction, long seed) {
        this.setSeed(seed);
        this.id = id;
        this.faction = faction;
        this.style = STYLES[this.random.nextInt(STYLES.length)];
        this.race = RACES[this.random.nextInt(RACES.length)];
        this.lastGameUpdate = world.func_82737_E();
        this.doriki = 1000.0;
        this.kenbunshokuExp = 10.0f;
        this.busoshokuExp = 10.0f;
        if (this.faction.equals((Object)ModValues.PIRATE)) {
            this.bounty = 100000L;
        }
    }

    public static TrackedNPC from(CompoundNBT tag) {
        TrackedNPC npc = new TrackedNPC();
        npc.setSeed(tag.func_74763_f("seed"));
        npc.id = tag.func_74763_f("id");
        npc.uuid = tag.func_186857_a("uuid");
        npc.lastGameUpdate = tag.func_74763_f("lastGameUpdate");
        npc.lastNewsUpdate = tag.func_74763_f("lastNewsUpdate");
        npc.faction = WyHelper.getResourceLocation(tag, "faction");
        if (npc.faction.equals((Object)ModValues.PIRATE)) {
            npc.bounty = tag.func_74763_f("bounty");
        }
        npc.race = WyHelper.getResourceLocation(tag, "race");
        npc.style = WyHelper.getResourceLocation(tag, "style");
        npc.doriki = tag.func_74769_h("doriki");
        npc.kenbunshokuExp = tag.func_74760_g("kenbunshokuExp");
        npc.busoshokuExp = tag.func_74760_g("busoshokuExp");
        return npc;
    }

    public long getId() {
        return this.id;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
        if (this.random == null) {
            this.random = new Random(seed);
        } else {
            this.random.setSeed(seed);
        }
        this.uuid = new UUID(this.random.nextLong(), this.random.nextLong());
    }

    public double getDoriki() {
        return this.doriki;
    }

    public long getBounty() {
        return this.bounty;
    }

    public float getObservationHaki() {
        return this.kenbunshokuExp;
    }

    public float getBusoshokuHaki() {
        return this.busoshokuExp;
    }

    public Random getRandom() {
        return this.random;
    }

    public ResourceLocation getFaction() {
        return this.faction;
    }

    public ResourceLocation getRace() {
        return this.race;
    }

    public ResourceLocation getStyle() {
        return this.style;
    }

    @Deprecated
    public boolean isPirate() {
        return this.faction.equals((Object)ModValues.PIRATE);
    }

    @Deprecated
    public boolean isMarine() {
        return this.faction.equals((Object)ModValues.MARINE);
    }

    public NewsEntry getNewsEntry(World world) {
        if (this.newsEntry == null) {
            this.updateNewsEntry(world);
        }
        return this.newsEntry;
    }

    public void updateNewsEntry(World world) {
        this.newsEntry = NewsEntry.createNewsFor(this, world);
        this.lastNewsUpdate = world.func_82737_E();
    }

    public void recalculateDifficulty(ServerWorld world) {
        float newBusoHaki;
        float newObsHaki;
        double newDoriki;
        float timePassed = (float)world.func_82737_E() / 9.223372E18f;
        int amount = 0;
        double totalDoriki = 0.0;
        float totalHaki = 0.0f;
        for (ServerPlayerEntity player : world.func_217369_A()) {
            ++amount;
            totalDoriki += EntityStatsCapability.get((LivingEntity)player).getDoriki();
            IHakiData hakiData = HakiDataCapability.get((LivingEntity)player);
            totalHaki += hakiData.getBusoshokuHakiExp();
            totalHaki += hakiData.getKenbunshokuHakiExp();
        }
        double totalPossibleDoriki = CommonConfig.INSTANCE.getDorikiLimit() * amount;
        float totalPossibleHaki = CommonConfig.INSTANCE.getHakiExpLimit() * 2 * amount;
        double dorikiBonus = MathHelper.func_151237_a((double)(totalDoriki / totalPossibleDoriki), (double)0.0, (double)0.5);
        double hakiBonus = MathHelper.func_151237_a((double)(totalHaki / totalPossibleHaki), (double)0.0, (double)0.5);
        double currentDifficulty = dorikiBonus * 0.3 + hakiBonus * 0.3 + (double)timePassed * 0.4;
        if (Double.isNaN(this.doriki)) {
            this.doriki = 1000.0;
        }
        if ((newDoriki = (double)((float)(this.doriki * (1.0 + dorikiBonus)))) < this.doriki) {
            newDoriki = this.doriki;
        }
        this.doriki = MathHelper.func_151237_a((double)newDoriki, (double)1000.0, (double)CommonConfig.INSTANCE.getDorikiLimit());
        if (Float.isNaN(this.kenbunshokuExp)) {
            this.kenbunshokuExp = 10.0f;
        }
        if ((newObsHaki = (float)((double)this.kenbunshokuExp * (1.0 + hakiBonus))) < this.kenbunshokuExp) {
            newObsHaki = this.kenbunshokuExp;
        }
        this.kenbunshokuExp = MathHelper.func_76131_a((float)newObsHaki, (float)10.0f, (float)CommonConfig.INSTANCE.getHakiExpLimit());
        if (Float.isNaN(this.busoshokuExp)) {
            this.busoshokuExp = 10.0f;
        }
        if ((newBusoHaki = (float)((double)this.busoshokuExp * (1.0 + hakiBonus))) < this.busoshokuExp) {
            newBusoHaki = this.busoshokuExp;
        }
        this.busoshokuExp = MathHelper.func_76131_a((float)newBusoHaki, (float)10.0f, (float)CommonConfig.INSTANCE.getHakiExpLimit());
        long newBounty = 100000L;
        if (this.faction.equals((Object)ModValues.PIRATE)) {
            newBounty = (long)((double)newBounty * (1.0 + currentDifficulty));
            newBounty += (long)this.random.nextInt(10000);
        }
        this.bounty += newBounty;
        this.bounty = WyHelper.clamp(this.bounty, 10000L, 100000000000L);
        this.lastGameUpdate = world.func_82737_E();
    }

    @Nullable
    public NotoriousEntity createTrackedMob(World world) {
        NotoriousEntity entity = null;
        if (this.isPirate()) {
            entity = new NotoriousEntity((EntityType)ModEntities.PIRATE_NOTORIOUS_CAPTAIN.get(), world, ModValues.PIRATE, this);
        } else if (this.isMarine()) {
            entity = new NotoriousEntity((EntityType)ModEntities.MARINE_VICE_ADMIRAL.get(), world, ModValues.MARINE, this);
        }
        if (entity == null) {
            LogManager.getLogger((Object)this).warn("Null entity found when creating a Notorious entity, this will most likely break things!");
        }
        return entity;
    }

    @Nullable
    public NotoriousEntity spawnTrackedMob(ServerWorld world, Vector3d pos) {
        NotoriousEntity entity = this.createTrackedMob((World)world);
        if (entity == null) {
            return null;
        }
        int y = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, (int)pos.func_82615_a(), (int)pos.func_82616_c());
        entity.func_70107_b(pos.func_82615_a(), y + 1, pos.func_82616_c());
        IEntityStats statsData = EntityStatsCapability.get((LivingEntity)entity);
        IHakiData hakiData = HakiDataCapability.get((LivingEntity)entity);
        statsData.setDoriki(this.doriki);
        statsData.setFaction(this.faction);
        if (this.faction.equals((Object)ModValues.PIRATE)) {
            statsData.setBounty(this.bounty);
        }
        statsData.setRace(this.race);
        if (this.race.equals((Object)ModValues.MINK)) {
            int size = ((RaceId)ModRaces.MINK.get()).getSubRaces().size();
            String subRace = ((RaceId)ModRaces.MINK.get()).getSubRaces().get(this.random.nextInt(size));
            statsData.setSubRace(subRace);
        }
        statsData.setFightingStyle(this.style);
        hakiData.setKenbunshokuHakiExp(this.kenbunshokuExp);
        hakiData.setBusoshokuHakiExp(this.busoshokuExp);
        double health = 200.0 + this.doriki / 20.0;
        entity.func_110148_a(Attributes.field_233818_a_).func_111128_a(health);
        AttributeHelper.updateToughnessAttribute((LivingEntity)entity);
        entity.func_70691_i(entity.func_110138_aP());
        world.func_217376_c((Entity)entity);
        return entity;
    }

    public CompoundNBT save() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74772_a("seed", this.seed);
        tag.func_186854_a("uuid", this.uuid);
        tag.func_74772_a("id", this.id);
        tag.func_74772_a("lastGameUpdate", this.lastGameUpdate);
        tag.func_74772_a("lastNewsUpdate", this.lastNewsUpdate);
        tag.func_74778_a("faction", this.faction.toString());
        tag.func_74778_a("race", this.race.toString());
        tag.func_74778_a("style", this.style.toString());
        tag.func_74780_a("doriki", this.doriki);
        tag.func_74772_a("bounty", this.bounty);
        tag.func_74776_a("kenbunshokuExp", this.kenbunshokuExp);
        tag.func_74776_a("busoshokuExp", this.busoshokuExp);
        return tag;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TrackedNPC)) {
            return false;
        }
        TrackedNPC otherNPC = (TrackedNPC)other;
        if (this.id == otherNPC.id) {
            return true;
        }
        return super.equals(other);
    }
}

