/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.poi;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.poi.POIEventTarget;

public class CountdownEventTarget
extends POIEventTarget {
    private int countdown;
    private UUID targetId;

    public CountdownEventTarget() {
    }

    public CountdownEventTarget(ServerWorld world, LivingEntity target, long openTime, int ticks) {
        super(world, target.func_213303_ch(), openTime);
        this.countdown = ticks;
        this.targetId = target.func_110124_au();
    }

    @Override
    public boolean shouldTrigger(ServerPlayerEntity player) {
        return this.countdown <= 0;
    }

    @Override
    public void tick() {
        if (this.countdown > 0) {
            --this.countdown;
        }
    }

    @Override
    public CompoundNBT save() {
        CompoundNBT tag = super.save();
        tag.func_74768_a("countdown", this.countdown);
        tag.func_186854_a("targetId", this.targetId);
        return tag;
    }

    @Override
    public void load(CompoundNBT tag) {
        super.load(tag);
        this.countdown = tag.func_74762_e("countdown");
        this.targetId = tag.func_186857_a("targetId");
    }

    public UUID getTargetId() {
        return this.targetId;
    }

    @Nullable
    public Optional<LivingEntity> getTarget(ServerWorld world) {
        PlayerEntity playerTarget = world.func_217371_b(this.targetId);
        if (playerTarget != null) {
            return Optional.ofNullable(playerTarget);
        }
        return world.getEntities().filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).filter(entity -> entity.func_110124_au().equals(this.targetId)).findFirst();
    }
}

