/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.math;

public class EasingFunctionHelper {
    public static float easeInOutQuad(Float x) {
        return EasingFunctionHelper.easeInQuad(x) * (1.0f - x.floatValue()) + EasingFunctionHelper.easeOutQuad(x) * x.floatValue();
    }

    public static float easeOutQuad(Float x) {
        return (float)(1.0 - Math.pow(1.0f - x.floatValue(), 2.0));
    }

    public static float easeInQuad(Float x) {
        return x.floatValue() * x.floatValue();
    }

    public static float easeOutCubic(Float x) {
        return (float)(1.0 - Math.pow(1.0f - x.floatValue(), 3.0));
    }

    public static float easeInCubic(Float x) {
        return x.floatValue() * x.floatValue() * x.floatValue();
    }

    public static float easeInOutCubic(Float x) {
        return (float)((double)x.floatValue() < 0.5 ? (double)(4.0f * x.floatValue() * x.floatValue() * x.floatValue()) : 1.0 - Math.pow(-2.0f * x.floatValue() + 2.0f, 3.0) / 2.0);
    }

    public static float easeOutSine(Float x) {
        return (float)Math.sin((double)x.floatValue() * Math.PI / 2.0);
    }

    public static float easeInSine(Float x) {
        return (float)(1.0 - Math.cos((double)x.floatValue() * Math.PI / 2.0));
    }

    public static float easeInOutSine(Float x) {
        return (float)(-(Math.cos(Math.PI * (double)x.floatValue()) - 1.0) / 2.0);
    }

    public static float easeInBack(Float x) {
        float y1 = 1.70158f;
        float y2 = y1 + 1.0f;
        return y2 * x.floatValue() * x.floatValue() * x.floatValue() - y1 * x.floatValue() * x.floatValue();
    }

    public static float easeOutBack(Float x) {
        float y1 = 1.70158f;
        float y2 = y1 + 1.0f;
        return (float)(1.0 + (double)y2 * Math.pow(x.floatValue() - 1.0f, 3.0) + (double)y1 * Math.pow(x.floatValue() - 1.0f, 2.0));
    }

    public static float easeInOutBack(Float x) {
        float y1 = 1.70158f;
        float y2 = y1 + 1.525f;
        return (float)((double)x.floatValue() < 0.5 ? Math.pow(2.0f * x.floatValue(), 2.0) * (double)((y2 + 1.0f) * 2.0f * x.floatValue() - y2) / 2.0 : (Math.pow(2.0f * x.floatValue() - 2.0f, 2.0) * (double)((y2 + 1.0f) * (x.floatValue() * 2.0f - 2.0f) + y2) + 2.0) / 2.0);
    }

    public static float easeInElastic(Float x) {
        float y = 2.0943952f;
        return (float)(x.floatValue() == 0.0f ? 0.0 : (x.floatValue() == 1.0f ? 1.0 : -Math.pow(2.0, 10.0f * x.floatValue() - 10.0f) * Math.sin(((double)(x.floatValue() * 10.0f) - 10.75) * (double)y)));
    }

    public static float easeOutElastic(Float x) {
        float y = 2.0943952f;
        return (float)(x.floatValue() == 0.0f ? 0.0 : (x.floatValue() == 1.0f ? 1.0 : Math.pow(2.0, -10.0f * x.floatValue()) * Math.sin(((double)(x.floatValue() * 10.0f) - 0.75) * (double)y) + 1.0));
    }

    public static float easeInOutElastic(Float x) {
        float y = 1.3962634f;
        return (float)(x.floatValue() == 0.0f ? 0.0 : (x.floatValue() == 1.0f ? 1.0 : ((double)x.floatValue() < 0.5 ? -(Math.pow(2.0, 20.0f * x.floatValue() - 10.0f) * Math.sin(((double)(20.0f * x.floatValue()) - 11.125) * (double)y)) / 2.0 : Math.pow(2.0, -20.0f * x.floatValue() + 10.0f) * Math.sin(((double)(20.0f * x.floatValue()) - 11.125) * (double)y) / 2.0 + 1.0)));
    }

    public static float easeInBounce(Float x) {
        return EasingFunctionHelper.easeOutBounce(Float.valueOf(1.0f - x.floatValue()));
    }

    public static float easeOutBounce(Float x) {
        float n = 7.5625f;
        float d = 2.75f;
        if (x.floatValue() < 1.0f / d) {
            return n * x.floatValue() * x.floatValue();
        }
        if (x.floatValue() < 2.0f / d) {
            x = Float.valueOf(x.floatValue() - 1.5f / d);
            return (float)((double)(n * x.floatValue() * x.floatValue()) + 0.75);
        }
        if ((double)x.floatValue() < 2.5 / (double)d) {
            x = Float.valueOf(x.floatValue() - 2.25f / d);
            return (float)((double)(n * x.floatValue() * x.floatValue()) + 0.9375);
        }
        x = Float.valueOf(x.floatValue() - 2.625f / d);
        return (float)((double)(n * x.floatValue() * x.floatValue()) + 0.984375);
    }

    public static float easeInOutBounce(Float x) {
        return (double)x.floatValue() < 0.5 ? (1.0f - EasingFunctionHelper.easeOutBounce(Float.valueOf(1.0f - 2.0f * x.floatValue()))) / 2.0f : (1.0f + EasingFunctionHelper.easeOutBounce(Float.valueOf(2.0f * x.floatValue() - 1.0f))) / 2.0f;
    }

    public static float easeAbsoluteSine(Float x) {
        return (float)Math.abs(Math.sin(x.floatValue()));
    }
}

