/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.helpers;

import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.stats.Stats;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.commons.lang3.tuple.ImmutablePair;
import xyz.pixelatedw.mineminenomi.abilities.ZoomAbility;
import xyz.pixelatedw.mineminenomi.api.DFEncyclopediaEntry;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.WantedPosterData;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeCore;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeDifficulty;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.BountyHelper;
import xyz.pixelatedw.mineminenomi.api.poi.TrackedNPC;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.projectilesextra.ProjectileExtrasCapability;
import xyz.pixelatedw.mineminenomi.data.world.EventsWorldData;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.data.world.NPCWorldData;
import xyz.pixelatedw.mineminenomi.entities.mobs.NotoriousEntity;
import xyz.pixelatedw.mineminenomi.init.ModAdvancements;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEnchantments;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.init.ModTags;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.items.DFEncyclopediaItem;
import xyz.pixelatedw.mineminenomi.items.weapons.ClimaTactItem;
import xyz.pixelatedw.mineminenomi.items.weapons.ModSwordItem;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ItemsHelper {
    private static final String[] WANTED_POSTER_BACKGROUNDS = new String[]{"forest1", "forest2", "jungle1", "jungle2", "hills1", "hills2", "hills3", "plains1", "plains2", "plains3", "taiga1", "taiga2"};

    public static void hurtCurrentlyUsedShield(LivingEntity entity, float damage) {
        if (entity.func_184607_cu().isShield(entity)) {
            if (!entity.field_70170_p.field_72995_K && entity instanceof PlayerEntity) {
                ((PlayerEntity)entity).func_71029_a(Stats.field_75929_E.func_199076_b((Object)entity.func_184607_cu().func_77973_b()));
            }
            int i = 1 + MathHelper.func_76141_d((float)damage);
            Hand hand = entity.func_184600_cs();
            entity.func_184607_cu().func_222118_a(i, entity, user -> {
                user.func_213334_d(hand);
                if (entity instanceof PlayerEntity) {
                    ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)((PlayerEntity)entity), (ItemStack)entity.func_184607_cu(), (Hand)hand);
                }
            });
            if (entity.func_184607_cu().func_190926_b()) {
                if (hand == Hand.MAIN_HAND) {
                    entity.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                } else {
                    entity.func_184201_a(EquipmentSlotType.OFFHAND, ItemStack.field_190927_a);
                }
                entity.func_184602_cy();
                entity.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + entity.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }

    public static void stopShieldAndStartCooldown(LivingEntity entity, int cooldown) {
        if (AbilityHelper.isShieldBlocking(entity)) {
            entity.func_184602_cy();
            if (entity instanceof PlayerEntity) {
                ((PlayerEntity)entity).func_184811_cZ().func_185145_a(Items.field_185159_cQ, cooldown);
            }
        }
    }

    public static boolean giveItemStackToEntity(LivingEntity entity, ItemStack itemStack, EquipmentSlotType slotType) {
        if (entity instanceof PlayerEntity) {
            ((PlayerEntity)entity).field_71071_by.func_70441_a(itemStack);
            return true;
        }
        if (!entity.func_190630_a(slotType)) {
            entity.func_184201_a(slotType, itemStack);
            return true;
        }
        return false;
    }

    public static void removeItemStackFromInventory(LivingEntity entity, ItemStack searchStack) {
        if (entity instanceof PlayerEntity) {
            ((PlayerEntity)entity).field_71071_by.func_184437_d(searchStack);
        } else {
            for (ItemStack stack : entity.func_184209_aF()) {
                if (!stack.equals(searchStack)) continue;
                stack.func_190918_g(stack.func_190916_E());
            }
        }
    }

    public static boolean hasItemStackInInventory(LivingEntity entity, ItemStack stack) {
        return ItemsHelper.getAllInventoryItems(entity).contains(stack);
    }

    public static int countItemInInventory(LivingEntity entity, Item item) {
        return ItemsHelper.getAllInventoryItems(entity).stream().filter(stack -> stack.func_77973_b().equals(item)).map(ItemStack::func_190916_E).reduce(0, Integer::sum);
    }

    public static int getFreeOrSameSlot(PlayerEntity player, ItemStack other) {
        ItemStack stack;
        int i;
        for (i = player.field_71071_by.field_70462_a.size() - 1; i > 0; --i) {
            stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (i == player.field_71071_by.field_70461_c || !stack.func_77985_e() || stack.func_190916_E() + other.func_190916_E() > stack.func_77976_d() || !ItemsHelper.matchItemStacks(stack, other)) continue;
            return i;
        }
        for (i = player.field_71071_by.field_70462_a.size() - 1; i > 0; --i) {
            stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (i == player.field_71071_by.field_70461_c || !stack.func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    private static boolean matchItemStacks(ItemStack stack, ItemStack other) {
        if (stack.func_190926_b() && other.func_190926_b()) {
            return true;
        }
        if (!stack.func_190926_b() && !other.func_190926_b()) {
            if (stack.func_77973_b() != other.func_77973_b()) {
                return false;
            }
            if (stack.func_77978_p() == null && other.func_77978_p() != null) {
                return false;
            }
            return (stack.func_77978_p() == null || stack.func_77978_p().equals((Object)other.func_77978_p())) && stack.areCapsCompatible((CapabilityProvider)other);
        }
        return false;
    }

    public static int getFreeSlotReversed(PlayerEntity player) {
        for (int i = player.field_71071_by.field_70462_a.size() - 1; i > 0; --i) {
            if (!((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    public static boolean hasInventoryFull(LivingEntity entity) {
        return !ItemsHelper.getInventoryItems(entity).stream().anyMatch(stack -> stack.func_190926_b());
    }

    public static long getFreeSlotsCount(LivingEntity entity) {
        return ItemsHelper.getInventoryItems(entity).stream().filter(stack -> stack.func_190926_b()).count();
    }

    public static List<ItemStack> getInventoryItems(LivingEntity entity) {
        ArrayList<ItemStack> inventory = new ArrayList<ItemStack>();
        if (entity instanceof PlayerEntity) {
            inventory.addAll((Collection<ItemStack>)((PlayerEntity)entity).field_71071_by.field_70462_a);
        } else {
            entity.func_184214_aD().forEach(inventory::add);
        }
        return inventory;
    }

    public static List<ItemStack> getAllInventoryItems(LivingEntity entity) {
        ArrayList<ItemStack> inventory = new ArrayList<ItemStack>();
        if (entity instanceof PlayerEntity) {
            inventory.addAll((Collection<ItemStack>)((PlayerEntity)entity).field_71071_by.field_70462_a);
            inventory.addAll((Collection<ItemStack>)((PlayerEntity)entity).field_71071_by.field_184439_c);
            inventory.addAll((Collection<ItemStack>)((PlayerEntity)entity).field_71071_by.field_70460_b);
        } else {
            entity.func_184209_aF().forEach(inventory::add);
        }
        inventory.removeIf(stack -> stack == null || stack.func_190926_b());
        return inventory;
    }

    public static void itemBreakParticles(World level, Vector3d pos, int count, ItemStack stack) {
        for (int i = 0; i < count; ++i) {
            Vector3d vec3d = new Vector3d(((double)level.func_201674_k().nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            double d0 = (double)(-level.func_201674_k().nextFloat()) * 0.6 - 0.3;
            Vector3d vec3d1 = new Vector3d(((double)level.func_201674_k().nextFloat() - 0.5) * 0.3, d0, 0.6);
            if (level instanceof ServerWorld) {
                ((ServerWorld)level).func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, 1, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c, 0.2);
                continue;
            }
            level.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c);
        }
    }

    public static void itemBreakParticles(LivingEntity entity, int count, ItemStack stack) {
        for (int i = 0; i < count; ++i) {
            Vector3d vec3d = new Vector3d(((double)entity.func_70681_au().nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3d = vec3d.func_178789_a(-entity.field_70125_A * ((float)Math.PI / 180));
            vec3d = vec3d.func_178785_b(-entity.field_70177_z * ((float)Math.PI / 180));
            double d0 = (double)(-entity.func_70681_au().nextFloat()) * 0.6 - 0.3;
            Vector3d vec3d1 = new Vector3d(((double)entity.func_70681_au().nextFloat() - 0.5) * 0.3, d0, 0.6);
            vec3d1 = vec3d1.func_178789_a(-entity.field_70125_A * ((float)Math.PI / 180));
            vec3d1 = vec3d1.func_178785_b(-entity.field_70177_z * ((float)Math.PI / 180));
            vec3d1 = vec3d1.func_72441_c(entity.func_226277_ct_(), entity.func_226280_cw_(), entity.func_226281_cx_());
            if (entity.field_70170_p instanceof ServerWorld) {
                ((ServerWorld)entity.field_70170_p).func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, 1, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c, 0.2);
                continue;
            }
            entity.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c);
        }
    }

    public static boolean updateEncyclopediae(PlayerEntity player, ResourceLocation fruit, DFEncyclopediaEntry entry) {
        List<Object> slots = new ArrayList();
        slots.addAll((Collection<Object>)player.field_71071_by.field_70462_a);
        slots.addAll((Collection<Object>)player.field_71071_by.field_184439_c);
        slots = slots.stream().filter(stack -> stack.func_77973_b() == ModItems.DEVIL_FRUIT_ENCYCLOPEDIA.get()).collect(Collectors.toList());
        if (slots.size() <= 0) {
            return false;
        }
        slots.forEach(stack -> {
            DFEncyclopediaItem.addFruitClues(stack, fruit, entry);
            ModAdvancements.ENCYCLOPEDIA_COMPLETION.trigger((ServerPlayerEntity)player, (ItemStack)stack);
        });
        return true;
    }

    public static void dropWantedPosters(World world, Vector3d pos) {
        if (world.field_72995_K) {
            return;
        }
        ExtendedWorldData worldData = ExtendedWorldData.get();
        HashSet playerBountiesInPackage = new HashSet();
        if (worldData.getAllBounties().size() > 0) {
            Predicate<PlayerEntity> hasBounty = player -> player != null && player.func_70089_S() && BountyHelper.canGainBounty((LivingEntity)player) && worldData.getBounty(player.func_110124_au()) != 0L;
            WyHelper.getNearbyPlayers(pos, (IWorld)world, 10.0, null).stream().filter(hasBounty).limit(5L).forEach(player -> {
                ImmutablePair pair = ImmutablePair.of((Object)player.func_110124_au(), (Object)worldData.getBounty(player.func_110124_au()));
                playerBountiesInPackage.add(pair);
            });
            if (playerBountiesInPackage.size() < 5) {
                List playerBounties = worldData.getAllBounties().entrySet().stream().filter(entry -> !playerBountiesInPackage.contains(entry)).map(entry -> ImmutablePair.of(entry.getKey(), entry.getValue())).collect(Collectors.toList());
                Collections.shuffle(playerBounties);
                int size = Math.min(3, playerBounties.size());
                playerBountiesInPackage.addAll(playerBounties.subList(0, size));
            }
        }
        if (!playerBountiesInPackage.isEmpty()) {
            playerBountiesInPackage.stream().forEach(entry -> {
                WantedPosterData wantedData;
                CompoundNBT data;
                ItemStack stack = new ItemStack((IItemProvider)ModBlocks.WANTED_POSTER.get());
                PlayerEntity player = world.func_217371_b((UUID)entry.getKey());
                if (player != null && !(data = (wantedData = new WantedPosterData((LivingEntity)player, (Long)entry.getValue())).write()).isEmpty()) {
                    stack.func_196082_o().func_218657_a("WPData", (INBT)data);
                    world.func_217376_c((Entity)new ItemEntity(world, pos.field_72450_a, pos.field_72448_b + 1.0, pos.field_72449_c, stack));
                }
            });
        }
        int challengePosters = world.func_201674_k().nextInt(3);
        List list = ModRegistries.CHALLENGES.getValues().stream().filter(core -> core.getDifficulty() == ChallengeDifficulty.STANDARD).collect(Collectors.toList());
        Collections.shuffle(list);
        for (int i = 0; i < challengePosters; ++i) {
            int pick = world.func_201674_k().nextInt(list.size());
            ChallengeCore challenge = (ChallengeCore)((Object)list.get(pick));
            ItemStack stack = new ItemStack((IItemProvider)ModItems.CHALLENGE_POSTER.get());
            stack.func_200302_a((ITextComponent)challenge.getLocalizedTitle());
            stack.func_196082_o().func_74778_a("challengeId", challenge.getRegistryName().toString());
            world.func_217376_c((Entity)new ItemEntity(world, pos.field_72450_a, pos.field_72448_b + 1.0, pos.field_72449_c, stack));
        }
        int notoriousPosters = 1 + world.func_201674_k().nextInt(3);
        NPCWorldData npcWorldData = NPCWorldData.get();
        EventsWorldData eventsWorldData = EventsWorldData.get();
        for (int i = 0; i < notoriousPosters; ++i) {
            Optional<TrackedNPC> npc = npcWorldData.getRandomTrackedMob(ModValues.PIRATE);
            if (!npc.isPresent() || eventsWorldData.hasNTEventFor(npc.get())) continue;
            ItemStack stack = new ItemStack((IItemProvider)ModBlocks.WANTED_POSTER.get());
            NotoriousEntity entity = npc.get().createTrackedMob(world);
            Vector3d pos2 = null;
            for (int j = 0; j < 5; ++j) {
                int extraX = 1000 + world.func_201674_k().nextInt(5000);
                if (world.func_201674_k().nextBoolean()) {
                    extraX *= -1;
                }
                int extraZ = 1000 + world.func_201674_k().nextInt(5000);
                if (world.func_201674_k().nextBoolean()) {
                    extraZ *= -1;
                }
                Vector3d vecPos = pos.func_72441_c((double)extraX, 1.0, (double)extraZ);
                BlockPos check = new BlockPos(vecPos.field_72450_a, vecPos.field_72448_b, vecPos.field_72449_c);
                Biome.Category category = world.func_226691_t_(check).func_201856_r();
                if (category == Biome.Category.OCEAN) continue;
                pos2 = vecPos;
                break;
            }
            if (pos2 == null) continue;
            eventsWorldData.addNotoriousTarget((ServerWorld)world, pos2, 72000L, npc.get());
            WantedPosterData wantedData = new WantedPosterData((LivingEntity)entity, npc.get().getBounty());
            wantedData.setTrackedPosition(pos2);
            if (BountyHelper.canGainBounty((LivingEntity)entity)) {
                worldData.issueBounty(npc.get().getUUID(), npc.get().getBounty());
            }
            CompoundNBT nbt = wantedData.write();
            stack.func_196082_o().func_218657_a("WPData", (INBT)nbt);
            world.func_217376_c((Entity)new ItemEntity(world, pos.field_72450_a, pos.field_72448_b + 1.0, pos.field_72449_c, stack));
        }
    }

    @Deprecated
    public static CompoundNBT setPlayerWantedData(IWorld world, UUID id, long bounty) {
        CompoundNBT data = new CompoundNBT();
        PlayerEntity player = world.func_217371_b(id);
        if (player == null || world.func_201670_d()) {
            return data;
        }
        ExtendedWorldData worldData = ExtendedWorldData.get();
        data.func_186854_a("UUID", id);
        data.func_74778_a("Name", player.func_200200_C_().getString());
        data.func_74772_a("Bounty", bounty);
        data.func_74778_a("Faction", EntityStatsCapability.get((LivingEntity)player).getFaction().toString());
        long seed = (long)player.func_200200_C_().getString().hashCode() + bounty;
        Random rand = new Random(seed);
        int randomBg = (int)WyHelper.randomWithRange(rand, 0, WANTED_POSTER_BACKGROUNDS.length - 1);
        data.func_74778_a("Background", WANTED_POSTER_BACKGROUNDS[randomBg]);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = format.format(new Date());
        data.func_74778_a("Date", dateString);
        CompoundNBT compoundnbt = new CompoundNBT();
        NBTUtil.func_180708_a((CompoundNBT)compoundnbt, (GameProfile)player.func_146103_bH());
        data.func_218657_a("Owner", (INBT)compoundnbt);
        Crew crew = worldData.getCrewWithMember(id);
        if (crew != null) {
            data.func_218657_a("Crew", (INBT)crew.write());
        }
        return data;
    }

    public static boolean isBow(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        if (itemStack.func_77973_b() instanceof ShootableItem) {
            return true;
        }
        return itemStack.func_77975_n() == UseAction.BOW;
    }

    public static boolean isBlunt(@Nullable ItemStack itemStack) {
        if (itemStack == null || itemStack.func_190926_b()) {
            return false;
        }
        return itemStack.func_77973_b() instanceof ModSwordItem && ((ModSwordItem)itemStack.func_77973_b()).isBlunt();
    }

    public static boolean isSword(@Nullable ItemStack itemStack) {
        if (itemStack == null || itemStack.func_190926_b()) {
            return false;
        }
        if (itemStack.func_77973_b() instanceof ModSwordItem && !((ModSwordItem)itemStack.func_77973_b()).isBlunt()) {
            return true;
        }
        return itemStack.func_77973_b() instanceof SwordItem;
    }

    public static boolean isClimaTact(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_190926_b()) {
            return false;
        }
        return itemStack.func_77973_b() instanceof ClimaTactItem;
    }

    public static boolean hasKairosekiItem(LivingEntity entity) {
        Iterable iter = entity.func_184209_aF();
        if (entity instanceof PlayerEntity) {
            iter = Iterables.concat((Iterable)((PlayerEntity)entity).field_71071_by.field_70462_a, (Iterable)entity.func_184209_aF());
        }
        for (ItemStack stack : iter) {
            if (stack.func_190926_b() || !ModTags.Items.KAIROSEKI.func_230235_a_((Object)stack.func_77973_b())) continue;
            return true;
        }
        return entity.func_70644_a((Effect)ModEffects.CAUGHT_IN_KAIROSEKI_NET.get()) || entity.func_70644_a((Effect)ModEffects.HANDCUFFED_KAIROSEKI.get());
    }

    public static boolean isKairosekiWeapon(ItemStack heldItem) {
        if (heldItem != null) {
            return heldItem.func_77948_v() && EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)ModEnchantments.KAIROSEKI.get()), (ItemStack)heldItem) > 0 || heldItem.func_77973_b() == ModWeapons.JITTE.get();
        }
        return false;
    }

    public static float getSniperInaccuracy(float inaccuracy, LivingEntity entity) {
        if (EntityStatsCapability.get(entity).isSniper()) {
            inaccuracy /= 2.0f;
        }
        if (entity.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == ModArmors.SNIPER_GOGGLES.get()) {
            boolean isActive;
            IAbilityData aprops = AbilityDataCapability.get(entity);
            ZoomAbility ability = aprops.getEquippedAbility(ZoomAbility.INSTANCE);
            boolean bl = isActive = ability != null && ability.isContinuous();
            if (isActive) {
                inaccuracy /= 4.0f;
            }
        }
        return inaccuracy;
    }

    public static float getItemDamage(ItemStack stack) {
        if (stack == null) {
            return -1.0f;
        }
        Multimap multimap = stack.func_111283_C(EquipmentSlotType.MAINHAND);
        double modifier = EnchantmentHelper.func_152377_a((ItemStack)stack, (CreatureAttribute)CreatureAttribute.field_223222_a_);
        for (Map.Entry entry : multimap.entries()) {
            AttributeModifier attr = (AttributeModifier)entry.getValue();
            if (!attr.func_111167_a().equals(AttributeHelper.ATTACK_DAMAGE_MODIFIER)) continue;
            double damage = attr.func_111164_d() + modifier;
            return (float)damage;
        }
        return -1.0f;
    }

    public static ItemStack getProjectileUsedWeapon(ProjectileEntity entity) {
        return ProjectileExtrasCapability.get((Entity)entity).getWeaponUsed();
    }
}

