/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.helpers;

import java.awt.Color;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiEmissionAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiFullBodyHardeningAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiHardeningAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiImbuingAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiInternalDestructionAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.HaoshokuHakiInfusionAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.KenbunshokuHakiAuraAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.enums.HakiType;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.data.entity.projectilesextra.ProjectileExtrasCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class HakiHelper {
    public static final String IMBUING_TAG = "imbuingHakiActive";
    private static final UUID ADVANCED_BUSOSHOKU_HAKI_REACH_BONUS_UUID = UUID.fromString("9e7fec38-e291-49e0-9ba7-10b18c87a6a4");
    public static final UUID ADVANCED_BUSOSHOKU_HAKI_STRENGTH_BONUS_UUID = UUID.fromString("cf88c7dd-fa1d-4b36-a4de-4268efae6378");
    public static final UUID BASIC_BUSOSHOKU_HAKI_STRENGTH_BONUS_UUID = UUID.fromString("0150e464-35c2-4cf0-a510-fd572c55d1d7");

    @OnlyIn(value=Dist.CLIENT)
    public static int getConfigHaoshokuColour(LivingEntity player) {
        if (CommonConfig.INSTANCE.isHaoColoringCustom()) {
            return ClientConfig.INSTANCE.getHakiColor().getRGB();
        }
        if (CommonConfig.INSTANCE.isHaoColoringRandom()) {
            if (player == null) {
                return 0xFF0000;
            }
            Random rand = new Random(player.func_110124_au().getMostSignificantBits());
            int r = (int)WyHelper.randomWithRange(rand, 0, 255);
            int g = (int)WyHelper.randomWithRange(rand, 0, 255);
            int b = (int)WyHelper.randomWithRange(rand, 0, 255);
            Color c = new Color(r, g, b);
            return c.getRGB();
        }
        return 0xFF0000;
    }

    public static int getHaoshokuColour(LivingEntity player) {
        if (player == null) {
            return 0xFF0000;
        }
        return HakiDataCapability.get(player).getHaoshokuHakiColour();
    }

    public static double getBasicBusoshokuHakiDamageBoost(LivingEntity entity, float originalAmount) {
        IEntityStats props = EntityStatsCapability.get(entity);
        IHakiData hakiProps = HakiDataCapability.get(entity);
        double dorikiMultiplier = props.getDoriki() / (double)CommonConfig.INSTANCE.getDorikiLimit();
        float hakiMultiplier = hakiProps.getBusoshokuHakiExp() / (float)CommonConfig.INSTANCE.getHakiExpLimit();
        return 5.0 + (double)originalAmount / 100.0 * 35.0 * (0.2 * dorikiMultiplier + 0.8 * (double)hakiMultiplier);
    }

    public static double getAdvancedBusoshokuHakiDamageBoost(LivingEntity entity) {
        IEntityStats props = EntityStatsCapability.get(entity);
        IHakiData hakiProps = HakiDataCapability.get(entity);
        double dorikiMultiplier = props.getDoriki() / (double)CommonConfig.INSTANCE.getDorikiLimit();
        float hakiMultiplier = hakiProps.getBusoshokuHakiExp() / (float)CommonConfig.INSTANCE.getHakiExpLimit();
        return dorikiMultiplier * 2.0 + (double)hakiMultiplier * 8.0;
    }

    public static AbilityAttributeModifier getAdvancedBusoshokuHakiAttackReachBonus(AbilityCore core, double amount) {
        return new AbilityAttributeModifier(ADVANCED_BUSOSHOKU_HAKI_REACH_BONUS_UUID, core, "Advanced Busoshoku Haki Attack Reach Modifier", amount, AttributeModifier.Operation.ADDITION);
    }

    public static AbilityAttributeModifier getAdvancedBusoshokuHakiAttackDamageBonus(AbilityCore core, double amount) {
        return new AbilityAttributeModifier(ADVANCED_BUSOSHOKU_HAKI_STRENGTH_BONUS_UUID, core, "Advanced Busoshoku Haki Strength Attack Modifier", amount, AttributeModifier.Operation.ADDITION);
    }

    public static AbilityAttributeModifier getBasicBusoshokuHakiAttackDamageBonus(AbilityCore core, double amount) {
        return new AbilityAttributeModifier(BASIC_BUSOSHOKU_HAKI_STRENGTH_BONUS_UUID, core, "Basic Busoshoku Haki Strength Attack Modifier", amount, AttributeModifier.Operation.ADDITION);
    }

    public static boolean isHaoshokuBorn(PlayerEntity player) {
        if (!CommonConfig.INSTANCE.isHaoshokuUnlockLogicChanceBased()) {
            return false;
        }
        boolean isKing = false;
        String[] bits = ("" + player.func_110124_au().getMostSignificantBits()).split("");
        int playerBitsSum = 0;
        for (String bit : bits) {
            if (bit.equalsIgnoreCase("-")) continue;
            playerBitsSum += Integer.parseInt(bit);
        }
        playerBitsSum = MathHelper.func_76125_a((int)(playerBitsSum & 0xA), (int)0, (int)10);
        if (CommonConfig.INSTANCE.getHaoshokuUnlockLogic() == CommonConfig.HaoshokuUnlockLogic.TRUE_RANDOM) {
            String[] seedBits = String.valueOf(((ServerWorld)player.field_70170_p).func_72905_C()).split("");
            int worldBitsSum = 0;
            for (String bit : seedBits) {
                if (bit.equalsIgnoreCase("-")) continue;
                worldBitsSum += Integer.parseInt(bit);
            }
            isKing = playerBitsSum == (worldBitsSum = MathHelper.func_76125_a((int)(worldBitsSum & 0xA), (int)0, (int)10));
        } else if (CommonConfig.INSTANCE.getHaoshokuUnlockLogic() == CommonConfig.HaoshokuUnlockLogic.RANDOM || CommonConfig.INSTANCE.getHaoshokuUnlockLogic() == CommonConfig.HaoshokuUnlockLogic.COMBINED) {
            isKing = playerBitsSum <= 1;
        }
        return isKing;
    }

    public static boolean isItemAffectedByImbuing(@Nullable ItemStack itemStack) {
        if (itemStack == null || itemStack.func_190926_b()) {
            return false;
        }
        if (ItemsHelper.isSword(itemStack)) {
            return true;
        }
        boolean hasDamageAttribute = itemStack.func_77973_b().getAttributeModifiers(EquipmentSlotType.MAINHAND, itemStack).get((Object)Attributes.field_233823_f_).size() > 0;
        return hasDamageAttribute;
    }

    public static double getBusoshokuHardeningExpNeeded(LivingEntity user) {
        Random rand = user.func_70681_au();
        rand.setSeed(user.func_110124_au().getMostSignificantBits());
        return 30.0 + WyHelper.randomWithRange(rand, -2, 25);
    }

    public static double getBusoshokuFullBodyExpNeeded(LivingEntity user) {
        Random rand = user.func_70681_au();
        rand.setSeed(user.func_110124_au().getMostSignificantBits());
        return 50.0 + WyHelper.randomWithRange(rand, 0, 20);
    }

    public static double getBusoshokuEmissionExpNeeded(LivingEntity user) {
        Random rand = user.func_70681_au();
        rand.setSeed(user.func_110124_au().getMostSignificantBits());
        return 70.0 + WyHelper.randomWithRange(rand, 0, 10);
    }

    public static double getBusoshokuInternalDestructionExpNeeded(LivingEntity user) {
        Random rand = user.func_70681_au();
        rand.setSeed(user.func_110124_au().getMostSignificantBits());
        return 80.0 + WyHelper.randomWithRange(rand, 0, 15);
    }

    public static double getKenbunshokuAuraExpNeeded(LivingEntity user) {
        Random rand = user.func_70681_au();
        rand.setSeed(user.func_110124_au().getMostSignificantBits());
        return 30.0 + WyHelper.randomWithRange(rand, -5, 20);
    }

    public static double getKenbunshokuFutureSightExpNeeded(LivingEntity user) {
        Random rand = user.func_70681_au();
        rand.setSeed(user.func_110124_au().getMostSignificantBits());
        return 50.0 + WyHelper.randomWithRange(rand, 0, 30);
    }

    public static HakiRank getHakiRank(HakiType type, LivingEntity entity) {
        IAbilityData abilityData = AbilityDataCapability.get(entity);
        IHakiData hakiData = HakiDataCapability.get(entity);
        HakiRank rank = HakiRank.values()[0];
        float exp = 0.0f;
        boolean check = false;
        if (type == HakiType.BUSOSHOKU) {
            exp = hakiData.getBusoshokuHakiExp();
            check = abilityData.hasUnlockedAbility(BusoshokuHakiHardeningAbility.INSTANCE) || abilityData.hasUnlockedAbility(BusoshokuHakiImbuingAbility.INSTANCE);
        } else if (type == HakiType.KENBUNSHOKU) {
            exp = hakiData.getKenbunshokuHakiExp();
            check = abilityData.hasUnlockedAbility(KenbunshokuHakiAuraAbility.INSTANCE);
        }
        float per = exp / (float)CommonConfig.INSTANCE.getHakiExpLimit() * 100.0f;
        if (per >= 0.0f && per < 15.0f) {
            rank = HakiRank.BEGINNER;
        } else if (per >= 15.0f && check) {
            if (per >= 15.0f && per < 30.0f) {
                rank = HakiRank.INITIATE;
            } else if (per >= 30.0f && per < 50.0f) {
                rank = HakiRank.ADEPT;
            } else if (per >= 50.0f && per < 90.0f) {
                rank = HakiRank.PROFICIENT;
            } else if (per >= 90.0f) {
                rank = HakiRank.MASTER;
            }
        }
        return rank;
    }

    public static boolean hasAnyHakiEnabled(LivingEntity entity) {
        if (entity == null) {
            return false;
        }
        IAbilityData props = AbilityDataCapability.get(entity);
        boolean hasAnyHaki = false;
        for (IAbility abl : props.getEquippedAbilities(AbilityCategory.HAKI.isAbilityPartofCategory())) {
            Optional<ContinuousComponent> comp;
            if (abl == null || !(comp = abl.getComponent(ModAbilityKeys.CONTINUOUS)).isPresent() || !comp.get().isContinuous()) continue;
            hasAnyHaki = true;
        }
        return hasAnyHaki;
    }

    public static boolean hasAdvancedBusoActive(LivingEntity entity) {
        return HakiHelper.hasBusoEmissionActive(entity) || HakiHelper.hasBusoInternalDestructionActive(entity);
    }

    public static boolean hasBusoFullbodyActive(LivingEntity entity) {
        if (entity == null) {
            return false;
        }
        IAbilityData attackerAbilityProps = AbilityDataCapability.get(entity);
        BusoshokuHakiFullBodyHardeningAbility fullbodyHaki = attackerAbilityProps.getEquippedAbility(BusoshokuHakiFullBodyHardeningAbility.INSTANCE);
        boolean isFullbodyActive = fullbodyHaki != null && fullbodyHaki.isContinuous();
        return isFullbodyActive;
    }

    public static boolean hasBusoEmissionActive(LivingEntity entity) {
        if (entity == null) {
            return false;
        }
        IAbilityData attackerAbilityProps = AbilityDataCapability.get(entity);
        BusoshokuHakiEmissionAbility emissionHaki = attackerAbilityProps.getEquippedAbility(BusoshokuHakiEmissionAbility.INSTANCE);
        boolean isEmissionActive = emissionHaki != null && emissionHaki.isContinuous();
        return isEmissionActive;
    }

    public static boolean hasBusoInternalDestructionActive(LivingEntity entity) {
        if (entity == null) {
            return false;
        }
        IAbilityData attackerAbilityProps = AbilityDataCapability.get(entity);
        BusoshokuHakiInternalDestructionAbility internalDestructionHaki = attackerAbilityProps.getEquippedAbility(BusoshokuHakiInternalDestructionAbility.INSTANCE);
        boolean isInternalDestructionHaki = internalDestructionHaki != null && internalDestructionHaki.isContinuous();
        return isInternalDestructionHaki;
    }

    public static boolean hasInfusionActive(LivingEntity entity) {
        if (entity == null) {
            return false;
        }
        IAbilityData props = AbilityDataCapability.get(entity);
        if (props == null) {
            return false;
        }
        Ability abl = props.getEquippedAbility(HaoshokuHakiInfusionAbility.INSTANCE);
        return abl != null && abl.isContinuous();
    }

    public static boolean hasHardeningActive(LivingEntity entity) {
        return HakiHelper.hasHardeningActive(entity, true, true);
    }

    public static boolean hasHardeningActive(LivingEntity entity, boolean includeInfusion, boolean includeAdvancedBuso) {
        boolean hasFullbodyBusoHakiActive;
        boolean hasHardeningBusoHakiActive;
        if (entity == null) {
            return false;
        }
        IAbilityData attackerAbilityProps = AbilityDataCapability.get(entity);
        BusoshokuHakiHardeningAbility hardeningHaki = attackerAbilityProps.getEquippedAbility(BusoshokuHakiHardeningAbility.INSTANCE);
        boolean bl = hasHardeningBusoHakiActive = hardeningHaki != null && hardeningHaki.isContinuous();
        if (hasHardeningBusoHakiActive) {
            return true;
        }
        BusoshokuHakiFullBodyHardeningAbility fullbodyHaki = attackerAbilityProps.getEquippedAbility(BusoshokuHakiFullBodyHardeningAbility.INSTANCE);
        boolean bl2 = hasFullbodyBusoHakiActive = fullbodyHaki != null && fullbodyHaki.isContinuous();
        if (hasFullbodyBusoHakiActive) {
            return true;
        }
        if (includeInfusion) {
            boolean hasInfusionActive;
            HaoshokuHakiInfusionAbility infusionHaki = attackerAbilityProps.getEquippedAbility(HaoshokuHakiInfusionAbility.INSTANCE);
            boolean bl3 = hasInfusionActive = infusionHaki != null && infusionHaki.isContinuous();
            if (hasInfusionActive) {
                return true;
            }
        }
        if (includeAdvancedBuso) {
            boolean hasIDHakiActive;
            boolean hasEmissionHakiActive;
            BusoshokuHakiEmissionAbility emissionHaki = attackerAbilityProps.getEquippedAbility(BusoshokuHakiEmissionAbility.INSTANCE);
            boolean bl4 = hasEmissionHakiActive = emissionHaki != null && emissionHaki.isContinuous();
            if (hasEmissionHakiActive) {
                return true;
            }
            BusoshokuHakiInternalDestructionAbility idHaki = attackerAbilityProps.getEquippedAbility(BusoshokuHakiInternalDestructionAbility.INSTANCE);
            boolean bl5 = hasIDHakiActive = idHaki != null && idHaki.isContinuous();
            if (hasIDHakiActive) {
                return true;
            }
        }
        return !(entity instanceof PlayerEntity) && HakiHelper.hasNativeHaki(entity);
    }

    public static boolean hasImbuingActive(LivingEntity entity) {
        return HakiHelper.hasImbuingActive(entity, true, true);
    }

    public static boolean hasImbuingActive(LivingEntity entity, boolean includeInfusion, boolean includeAdvancedBuso) {
        boolean hasImbuingBusoHakiActive;
        if (entity == null) {
            return false;
        }
        IAbilityData attackerAbilityProps = AbilityDataCapability.get(entity);
        if (attackerAbilityProps == null) {
            return false;
        }
        BusoshokuHakiImbuingAbility imbuingHaki = attackerAbilityProps.getEquippedAbility(BusoshokuHakiImbuingAbility.INSTANCE);
        boolean bl = hasImbuingBusoHakiActive = imbuingHaki != null && imbuingHaki.isContinuous();
        if (hasImbuingBusoHakiActive) {
            return true;
        }
        if (includeInfusion) {
            boolean hasInfusionActive;
            HaoshokuHakiInfusionAbility infusionHaki = attackerAbilityProps.getEquippedAbility(HaoshokuHakiInfusionAbility.INSTANCE);
            boolean bl2 = hasInfusionActive = infusionHaki != null && infusionHaki.isContinuous();
            if (hasInfusionActive) {
                return true;
            }
        }
        if (includeAdvancedBuso) {
            boolean hasIDHakiActive;
            boolean hasEmissionHakiActive;
            BusoshokuHakiEmissionAbility emissionHaki = attackerAbilityProps.getEquippedAbility(BusoshokuHakiEmissionAbility.INSTANCE);
            boolean bl3 = hasEmissionHakiActive = emissionHaki != null && emissionHaki.isContinuous();
            if (hasEmissionHakiActive) {
                return true;
            }
            BusoshokuHakiInternalDestructionAbility idHaki = attackerAbilityProps.getEquippedAbility(BusoshokuHakiInternalDestructionAbility.INSTANCE);
            boolean bl4 = hasIDHakiActive = idHaki != null && idHaki.isContinuous();
            if (hasIDHakiActive) {
                return true;
            }
        }
        if (!(entity instanceof PlayerEntity)) {
            if (entity.func_184614_ca() == null || entity.func_184614_ca().func_190926_b() || !HakiHelper.isItemAffectedByImbuing(entity.func_184614_ca())) {
                return false;
            }
            if (HakiHelper.hasNativeHaki(entity)) {
                return true;
            }
        }
        return false;
    }

    public static boolean hasNativeHaki(LivingEntity entity) {
        ModifiableAttributeInstance attrAtk = entity.func_233645_dx_().func_233779_a_(Attributes.field_233823_f_);
        double atk = attrAtk != null ? attrAtk.func_111125_b() : 0.0;
        boolean hasDoriki = EntityStatsCapability.get(entity).getDoriki() >= 5000.0;
        boolean hasPseudoHaki = atk >= (double)(entity.field_70170_p.func_175659_aa() == Difficulty.HARD ? 5 : 7) && CommonConfig.INSTANCE.isNativeHakiEnabled();
        return hasPseudoHaki || hasDoriki;
    }

    public static boolean checkForHakiOveruse(LivingEntity entity, int overuseBonus) {
        if (entity.field_70170_p.field_72995_K) {
            return false;
        }
        IHakiData hakiProps = HakiDataCapability.get(entity);
        if (overuseBonus != -1) {
            hakiProps.alterHakiOveruse(1 + overuseBonus);
        }
        return !HakiHelper.canEnableHaki(entity);
    }

    public static boolean canEnableHaki(LivingEntity entity) {
        IHakiData props = HakiDataCapability.get(entity);
        return props.getHakiOveruse() < props.getMaxOveruse();
    }

    public static AbilityUseResult canEnableHaki(LivingEntity entity, IAbility ability) {
        IHakiData props = HakiDataCapability.get(entity);
        if (props.getHakiOveruse() < props.getMaxOveruse()) {
            return AbilityUseResult.success();
        }
        return AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NOT_ENOUGH_HAKI));
    }

    public static boolean isProjectileBusoshokuImbued(ProjectileEntity entity) {
        return ProjectileExtrasCapability.get((Entity)entity).isProjectileBusoshokuImbued();
    }

    public static boolean isProjectileBusoshokuShrouded(ProjectileEntity entity) {
        return ProjectileExtrasCapability.get((Entity)entity).isProjectileBusoshokuShrouded();
    }

    public static boolean isProjectileHaoshokuInfused(ProjectileEntity entity) {
        return ProjectileExtrasCapability.get((Entity)entity).isProjectileHaoshokuInfused();
    }

    public static enum HakiRank {
        BEGINNER,
        INITIATE,
        ADEPT,
        PROFICIENT,
        MASTER;


        public static boolean isAbove(HakiRank rank, HakiType type, PlayerEntity player) {
            return HakiHelper.getHakiRank(type, (LivingEntity)player).compareTo(rank) <= 0;
        }

        public static boolean isBelow(HakiRank rank, HakiType type, PlayerEntity player) {
            return HakiHelper.getHakiRank(type, (LivingEntity)player).compareTo(rank) > 0;
        }
    }
}

