/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.helpers;

import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SUpdateHealthPacket;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;

public class AttributeHelper {
    public static final UUID MORPH_HEALTH_UUID = UUID.fromString("47f8957b-e442-4f12-ac91-f7bedf821e89");
    public static final UUID MORPH_MOVEMENT_SPEED_UUID = UUID.fromString("73ec9572-1641-48f5-a464-f1a5f361cd2a");
    public static final UUID MORPH_ARMOR_UUID = UUID.fromString("7963cb37-cf63-4358-a5c6-7793f08e6beb");
    public static final UUID MORPH_ARMOR_TOUGHNESS_UUID = UUID.fromString("4eb40c49-8e26-450c-a42d-6e6e772d5848");
    public static final UUID MORPH_STRENGTH_UUID = UUID.fromString("99309bfc-1622-4ba5-8fa9-b0cad5152f6a");
    public static final UUID MORPH_ATTACK_SPEED_UUID = UUID.fromString("da37e4fa-67e1-4bfd-802a-72997d0b10c9");
    public static final UUID MORPH_ATTACK_REACH_UUID = UUID.fromString("7c3df274-a274-4fee-9cc8-b8cd90741b10");
    public static final UUID MORPH_STEP_HEIGHT_UUID = UUID.fromString("82e093a0-3762-48f9-befa-eed78ff34fa1");
    public static final UUID MORPH_KNOCKBACK_RESISTANCE_UUID = UUID.fromString("5e0a4164-1560-4d10-b627-90e0c24db30f");
    public static final UUID MORPH_FALL_RESISTANCE_UUID = UUID.fromString("1bac6f14-8f9a-4199-b2b7-96d68c1fcd90");
    public static final UUID MORPH_TOUGHNESS_UUID = UUID.fromString("eb3978a7-1056-401b-8d79-1ab76b5c9418");
    public static final UUID MORPH_JUMP_BOOST_UUID = UUID.fromString("f9e7706a-a628-4af9-8d62-e49ac7d59c02");
    public static final UUID MORPH_REGEN_RATE_UUID = UUID.fromString("44e331cd-347a-43dc-93ab-e8a55de54c77");
    public static final UUID MORPH_DAMAGE_REDUCTION_UUID = UUID.fromString("4807404c-713c-4795-b9df-dffbc24915ff");
    public static final UUID MORPH_SWIM_SPEED_UUID = UUID.fromString("f0a12d8e-7398-4e6a-afc1-9ceee88572e6");
    public static final UUID MORPH_GRAVITY_UUID = UUID.fromString("b3a23595-08de-45b8-9629-fdd6dc5f7de1");
    public static final UUID MORPH_MINING_SPEED_UUID = UUID.fromString("0f623bed-fd48-4619-9d4d-60a6e40614bc");
    public static final UUID PASSIVE_TOUGHNESS_UUID = UUID.fromString("18837309-bfc8-483d-8c40-44ab292e6776");
    public static final UUID ATTACK_DAMAGE_MODIFIER = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    public static final UUID SPEED_MODIFIER_SPRINTING_UUID = UUID.fromString("662A6B8D-DA3E-4C1C-8813-96EA6097278D");

    public static void updateHPAttribute(PlayerEntity player) {
        if (player != null && !player.field_70170_p.field_72995_K && CommonConfig.INSTANCE.isExtraHeartsEnabled()) {
            ModifiableAttributeInstance maxHpAttribute = player.func_110148_a(Attributes.field_233818_a_);
            IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
            int freq = CommonConfig.INSTANCE.getHealthGainFrequency();
            if (props.getDoriki() / (double)freq > 20.0) {
                maxHpAttribute.func_111128_a(props.getDoriki() / (double)freq);
            } else {
                maxHpAttribute.func_111128_a(20.0);
            }
            if ((double)player.func_110143_aJ() > maxHpAttribute.func_111126_e()) {
                player.func_70606_j((float)maxHpAttribute.func_111126_e());
            }
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SUpdateHealthPacket(player.func_110143_aJ(), player.func_71024_bL().func_75116_a(), player.func_71024_bL().func_75115_e()));
        }
    }

    public static void updateToughnessAttribute(LivingEntity entity) {
        if (entity != null && !entity.field_70170_p.field_72995_K) {
            ModifiableAttributeInstance toughnessAttribute = entity.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get());
            if (toughnessAttribute == null) {
                return;
            }
            IEntityStats props = EntityStatsCapability.get(entity);
            AttributeModifier mod = new AttributeModifier(PASSIVE_TOUGHNESS_UUID, "Passive Toughness Bonus", 0.08 * (props.getDoriki() / (double)CommonConfig.INSTANCE.getDorikiLimit()) * 100.0, AttributeModifier.Operation.ADDITION);
            entity.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_188479_b(PASSIVE_TOUGHNESS_UUID);
            entity.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_233767_b_(mod);
        }
    }

    public static double getAttackRangeDistance(LivingEntity entity, double baseReachDistance) {
        ModifiableAttributeInstance reachDistance = entity.func_110148_a((Attribute)ModAttributes.ATTACK_RANGE.get());
        return reachDistance != null ? baseReachDistance + reachDistance.func_111126_e() : baseReachDistance;
    }

    public static double getSquaredAttackRangeDistance(LivingEntity entity, double sqBaseReachDistance) {
        double reachDistance = AttributeHelper.getAttackRangeDistance(entity, Math.sqrt(sqBaseReachDistance));
        return reachDistance * reachDistance;
    }
}

