/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.entities.ai;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.entities.IPhasesEntity;

public abstract class NPCPhase<E extends MobEntity> {
    private String name;
    private final E entity;
    private final Set<Pair<Integer, Goal>> availableGoals = Sets.newLinkedHashSet();
    private GoalSelector goals;

    public NPCPhase(String name, E entity) {
        this.name = name;
        this.entity = entity;
        this.goals = new GoalSelector(((MobEntity)entity).field_70170_p.func_234924_Y_());
    }

    public void addGoal(int priority, Goal goal) {
        if (this.availableGoals.stream().anyMatch(pair -> ((Goal)pair.getValue()).equals(goal))) {
            return;
        }
        this.availableGoals.add((Pair<Integer, Goal>)ImmutablePair.of((Object)priority, (Object)goal));
        this.goals.func_75776_a(priority, goal);
    }

    public void addGoals(NPCPhase<E> phase) {
        for (Pair<Integer, Goal> pair : phase.getGoalsSet()) {
            this.addGoal((Integer)pair.getKey(), (Goal)pair.getValue());
        }
    }

    public final void startPhase() {
        this.start(this.entity);
    }

    public abstract void start(E var1);

    public final void stopPhase() {
        this.goals.func_220888_c().forEach(PrioritizedGoal::func_75251_c);
        this.stop(this.entity);
    }

    public abstract void stop(E var1);

    public final void tick() {
        this.goals.func_75774_a();
        this.doTick();
    }

    public abstract void doTick();

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public <T extends IPhasesEntity> boolean isActive(T entity) {
        NPCPhase<?> currentPhase = entity.getPhaseManager().getCurrentPhase();
        if (currentPhase == null) {
            return false;
        }
        return currentPhase.equals(this);
    }

    public Set<Pair<Integer, Goal>> getGoalsSet() {
        return this.availableGoals;
    }
}

