/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.entities.ai;

import java.util.Optional;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.world.Difficulty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DisableComponent;
import xyz.pixelatedw.mineminenomi.api.effects.IBindHandsEffect;
import xyz.pixelatedw.mineminenomi.api.entities.ai.TickedGoal;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.api.protection.ProtectedArea;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.gcd.GCDCapability;
import xyz.pixelatedw.mineminenomi.data.world.ProtectedAreasData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public abstract class AbilityWrapperGoal<E extends MobEntity, A extends IAbility>
extends TickedGoal<E> {
    private static final Logger LOGGER = LogManager.getLogger();
    private AbilityCore<A> abilityCore;
    private A ability;
    private IAbilityData props;
    private boolean trackContinuity = false;

    public AbilityWrapperGoal(E entity, AbilityCore<A> core) {
        super(entity);
        this.abilityCore = core;
        this.ability = core.getType().equals((Object)AbilityType.ACTION) ? MobsHelper.unlockAndEquipAbility(entity, core) : MobsHelper.unlockAbility(entity, core);
        this.props = AbilityDataCapability.get(entity);
        this.ability.getComponent(ModAbilityKeys.CONTINUOUS).ifPresent(comp -> comp.addStartEvent(150, (e, a) -> {
            this.trackContinuity = true;
        }));
    }

    public boolean func_75250_a() {
        if (!this.entity.func_70089_S()) {
            return false;
        }
        if (this.entity.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && !WyHelper.isInChallengeDimension(this.entity.field_70170_p)) {
            return false;
        }
        if (this.entity.func_70638_az() != null && this.entity.func_70638_az() instanceof MonsterEntity) {
            return false;
        }
        for (EffectInstance effectInst : this.entity.func_70651_bq()) {
            if (!(effectInst.func_188419_a() instanceof IBindHandsEffect) || !((IBindHandsEffect)effectInst.func_188419_a()).isBlockingSwings()) continue;
            return false;
        }
        if (this.entity instanceof AgeableEntity && ((AgeableEntity)this.entity).func_70874_b() < 0) {
            return false;
        }
        if (!this.canUseWrapper()) {
            return false;
        }
        return !this.ability.canUse((LivingEntity)this.entity).isFail();
    }

    public abstract boolean canUseWrapper();

    public boolean func_75253_b() {
        ProtectedArea area;
        Optional<ContinuousComponent> comp;
        if (!this.entity.func_70089_S()) {
            return false;
        }
        boolean isDisabled = this.ability.getComponent(ModAbilityKeys.DISABLE).map(DisableComponent::isDisabled).orElse(false);
        if (isDisabled) {
            return false;
        }
        boolean isOnCooldown = this.ability.getComponent(ModAbilityKeys.COOLDOWN).map(CooldownComponent::isOnCooldown).orElse(false);
        if (isOnCooldown) {
            return false;
        }
        if (this.trackContinuity && (comp = this.ability.getComponent(ModAbilityKeys.CONTINUOUS)).isPresent()) {
            boolean shouldBeContinuous;
            boolean bl = shouldBeContinuous = !comp.get().isContinuous();
            if (shouldBeContinuous) {
                this.trackContinuity = false;
                return false;
            }
        }
        if (!this.entity.field_70170_p.field_72995_K && (area = ProtectedAreasData.get(this.entity.field_70170_p).getProtectedArea(this.entity.func_233580_cy_().func_177958_n(), this.entity.func_233580_cy_().func_177956_o(), this.entity.func_233580_cy_().func_177952_p())) != null && !area.canUseAbility(this.getCore())) {
            return false;
        }
        return this.canContinueToUseWrapper();
    }

    public abstract boolean canContinueToUseWrapper();

    @Override
    public final void func_75249_e() {
        super.func_75249_e();
        this.startWrapper();
        this.ability.use((LivingEntity)this.entity);
    }

    public abstract void startWrapper();

    @Override
    public final void func_75246_d() {
        this.tickWrapper();
        super.func_75246_d();
    }

    public abstract void tickWrapper();

    @Override
    public final void func_75251_c() {
        super.func_75251_c();
        this.stopWrapper();
        this.getAbility().getComponent(ModAbilityKeys.CONTINUOUS).ifPresent(comp -> comp.stopContinuity((LivingEntity)this.entity));
        if (!this.ability.isOGCD()) {
            GCDCapability.startGCD((LivingEntity)this.entity);
        }
        LOGGER.debug("{} stopped {} at tick {}", (Object)this.entity.func_200200_C_().getString(), (Object)this.ability.getDisplayName().getString(), (Object)this.entity.field_70173_aa);
    }

    public abstract void stopWrapper();

    public A getAbility() {
        return this.ability;
    }

    public AbilityCore<A> getCore() {
        return this.abilityCore;
    }

    public IAbilityData getProps() {
        return this.props;
    }
}

