/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.crew;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.crew.Claim;
import xyz.pixelatedw.mineminenomi.api.crew.JollyRoger;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;

public class Crew {
    private String name;
    private boolean isTemporary;
    private long creationDate;
    private List<Member> members = new ArrayList<Member>();
    private JollyRoger jollyRoger = new JollyRoger();
    private Set<Claim> claims = new HashSet<Claim>();

    private Crew() {
    }

    public Crew(String name, LivingEntity entity) {
        this(name, entity.func_110124_au(), entity.func_145748_c_().getString(), Instant.now().getEpochSecond());
    }

    public static Crew from(CompoundNBT nbt) {
        Crew crew = new Crew();
        crew.read(nbt);
        return crew;
    }

    public Crew(String name, UUID capId, String username, long creationDate) {
        this.name = name;
        this.isTemporary = true;
        this.addMember(capId, username).setIsCaptain(true);
        this.creationDate = creationDate;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public Member addMember(LivingEntity entity) {
        return this.addMember(entity, true);
    }

    public Member addMember(LivingEntity entity, boolean saveMember) {
        return this.addMember(entity.func_110124_au(), entity.func_145748_c_().getString(), saveMember);
    }

    public Member addMember(UUID uuid, String username) {
        return this.addMember(uuid, username, true);
    }

    public Member addMember(UUID uuid, String username, boolean saveMember) {
        Member member = new Member(uuid, username).setSaved(saveMember);
        this.members.add(member);
        return member;
    }

    public void removeMember(UUID id) {
        Member member = this.getMember(id);
        if (member == null) {
            return;
        }
        if (member.isCaptain()) {
            Optional<Member> nextCaptain = this.getMembers().stream().filter(mem -> !mem.isCaptain()).findFirst();
            if (nextCaptain.isPresent()) {
                member.setIsCaptain(false);
                nextCaptain.get().setIsCaptain(true);
                member.markedForDeletion = true;
            } else {
                for (Member mem2 : this.members) {
                    mem2.markedForDeletion = true;
                }
            }
        } else {
            member.markedForDeletion = true;
        }
    }

    @Nullable
    public Member getMember(UUID id) {
        return this.members.stream().filter(member -> member.getUUID().equals(id)).findFirst().orElse(null);
    }

    public boolean hasMember(UUID id) {
        return this.getMember(id) != null;
    }

    public void create(World world) {
        this.isTemporary = false;
    }

    @Nullable
    public Member getCaptain() {
        return this.members.stream().filter(member -> member.isCaptain()).findFirst().orElse(null);
    }

    public List<Member> getMembers() {
        return this.members;
    }

    public JollyRoger getJollyRoger() {
        return this.jollyRoger;
    }

    public void setJollyRoger(JollyRoger jr) {
        this.jollyRoger = jr;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    public void tick() {
        if (!this.members.isEmpty()) {
            Iterator<Member> iter = this.members.iterator();
            while (iter.hasNext()) {
                Member mem = iter.next();
                if (!mem.markedForDeletion) continue;
                iter.remove();
            }
        } else {
            ExtendedWorldData.get().removeCrew(this);
        }
    }

    public CompoundNBT write() {
        CompoundNBT crewNBT = new CompoundNBT();
        crewNBT.func_74778_a("name", this.getName());
        ListNBT members = new ListNBT();
        for (Member member : this.getMembers()) {
            if (!member.isSaved()) continue;
            CompoundNBT memberNBT = new CompoundNBT();
            memberNBT.func_186854_a("id", member.getUUID());
            memberNBT.func_74778_a("username", member.getUsername());
            memberNBT.func_74757_a("isCaptain", member.isCaptain());
            members.add((Object)memberNBT);
        }
        crewNBT.func_218657_a("members", (INBT)members);
        CompoundNBT jollyRogerData = this.jollyRoger.write();
        crewNBT.func_218657_a("jollyRoger", (INBT)jollyRogerData);
        crewNBT.func_74772_a("creationDate", this.creationDate);
        return crewNBT;
    }

    public void read(CompoundNBT nbt) {
        String name = nbt.func_74779_i("name");
        this.setName(name);
        ListNBT members = nbt.func_150295_c("members", 10);
        for (int j = 0; j < members.size(); ++j) {
            CompoundNBT memberNBT = members.func_150305_b(j);
            Member member = this.addMember(memberNBT.func_186857_a("id"), memberNBT.func_74779_i("username"));
            member.setIsCaptain(memberNBT.func_74767_n("isCaptain"));
        }
        CompoundNBT jollyRogerData = nbt.func_74775_l("jollyRoger");
        this.jollyRoger.read(jollyRogerData);
        Long creationDate = nbt.func_74763_f("creationDate");
        if (creationDate == 0L) {
            this.creationDate = Instant.now().getEpochSecond();
            return;
        }
        this.creationDate = creationDate;
    }

    public static class Member {
        private UUID uuid;
        private String username;
        private boolean isCaptain;
        private boolean isSaved;
        private boolean markedForDeletion;

        public Member(LivingEntity entity) {
            this(entity.func_110124_au(), entity.func_145748_c_().getString());
        }

        public Member(UUID uuid, String username) {
            this.uuid = uuid;
            this.username = username;
        }

        public Member setIsCaptain(boolean flag) {
            this.isCaptain = flag;
            return this;
        }

        public Member setSaved(boolean flag) {
            this.isSaved = flag;
            return this;
        }

        public boolean isCaptain() {
            return this.isCaptain;
        }

        public boolean isSaved() {
            return this.isSaved;
        }

        public UUID getUUID() {
            return this.uuid;
        }

        public String getUsername() {
            return this.username;
        }
    }
}

