/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.commands;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.world.IWorld;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;

public class CrewArgument
implements ArgumentType<Crew> {
    public Crew parse(StringReader reader) throws CommandSyntaxException {
        ExtendedWorldData data = ExtendedWorldData.get();
        if (data == null) {
            data = ExtendedWorldData.get((IWorld)Minecraft.func_71410_x().field_71441_e);
        }
        return data.getCrewByName(reader.readQuotedString());
    }

    public static CrewArgument crew() {
        return new CrewArgument();
    }

    public static <S> Crew getCrew(CommandContext<S> context, String name) {
        return (Crew)context.getArgument(name, Crew.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        StringReader stringreader = new StringReader(builder.getInput());
        stringreader.setCursor(builder.getStart());
        return this.suggestCrew(builder);
    }

    private CompletableFuture<Suggestions> suggestCrew(SuggestionsBuilder builder) {
        List<Crew> crews;
        ExtendedWorldData data;
        boolean quoted;
        String input = builder.getInput();
        int start = builder.getStart();
        StringReader stringReader = new StringReader(input);
        stringReader.setCursor(start);
        boolean bl = quoted = stringReader.canRead() && stringReader.peek() == '\"';
        if (quoted) {
            stringReader.skip();
        }
        if ((data = ExtendedWorldData.get()) == null) {
            data = ExtendedWorldData.get((IWorld)Minecraft.func_71410_x().field_71441_e);
        }
        if ((crews = data.getCrews()) == null) {
            return ISuggestionProvider.func_197008_a((String[])new String[0], (SuggestionsBuilder)builder);
        }
        CompletableFuture suggestions = ISuggestionProvider.func_197008_a((String[])((String[])crews.stream().map(crew -> '\"' + crew.getName() + '\"').toArray(String[]::new)), (SuggestionsBuilder)builder);
        return suggestions;
    }
}

