/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.challenges;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.BlackLegPassiveBonusesAbility;
import xyz.pixelatedw.mineminenomi.abilities.brawler.BrawlerPassiveBonusesAbility;
import xyz.pixelatedw.mineminenomi.api.ServerOPBossInfo;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeInfo;
import xyz.pixelatedw.mineminenomi.api.challenges.IChallengeBoss;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.api.entities.ai.NPCPhaseManager;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.entities.mobs.ai.controllers.HumanoidSwimMoveController;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.AlwaysActiveAbilityWrapperGoal;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public abstract class OPBossEntity<E extends OPBossEntity>
extends CreatureEntity
implements IChallengeBoss,
IEntityAdditionalSpawnData {
    private final ServerOPBossInfo bossInfo = new ServerOPBossInfo(this.func_145748_c_());
    private final ChallengeInfo challengeInfo = new ChallengeInfo();
    private final NPCPhaseManager phaseManager = new NPCPhaseManager((MobEntity)this);
    protected final IEntityStats entityStats = EntityStatsCapability.get((LivingEntity)this);
    protected final IAbilityData abilityData = AbilityDataCapability.get((LivingEntity)this);
    protected final IDevilFruit devilFruitData = DevilFruitCapability.get((LivingEntity)this);
    protected final IHakiData hakiCapability = HakiDataCapability.get((LivingEntity)this);
    private boolean isInitialized;
    private float damageCeiling;
    private boolean hasEmptyTargetsList;
    private int movementType = 0;
    private BlockPos lastSafePosition;
    private MovementController groundMovementController = new MovementController((MobEntity)this);
    private MovementController waterMovementController = new HumanoidSwimMoveController((MobEntity)this);

    public OPBossEntity(EntityType type, World world) {
        this(type, world, null);
    }

    public OPBossEntity(EntityType type, InProgressChallenge inProgressChallenge) {
        this(type, (World)inProgressChallenge.getShard(), inProgressChallenge);
    }

    private OPBossEntity(EntityType type, World world, @Nullable InProgressChallenge inProgressChallenge) {
        super(type, world);
        this.preInit();
        if (world != null && !world.field_72995_K) {
            this.challengeInfo.setInProgressChallenge(inProgressChallenge);
            this.setDamageCeiling(this.isDifficultyStandard() ? 20.0f : 30.0f);
            this.applyDifficultyModifiers((LivingEntity)this);
            if (this.entityStats.isBrawler()) {
                this.field_70714_bg.func_75776_a(0, new AlwaysActiveAbilityWrapperGoal<BrawlerPassiveBonusesAbility>((MobEntity)this, BrawlerPassiveBonusesAbility.INSTANCE));
            } else if (this.entityStats.isBlackLeg()) {
                this.field_70714_bg.func_75776_a(0, new AlwaysActiveAbilityWrapperGoal<BlackLegPassiveBonusesAbility>((MobEntity)this, BlackLegPassiveBonusesAbility.INSTANCE));
            }
            AttributeHelper.updateToughnessAttribute((LivingEntity)this);
        }
    }

    public void preInit() {
    }

    public void initBoss() {
    }

    public void initStats() {
    }

    public void initGoals() {
    }

    public void func_70071_h_() {
        if (!this.isInitialized) {
            if (!this.field_70170_p.field_72995_K) {
                this.initBoss();
                this.initStats();
                this.initGoals();
                this.func_70691_i(this.func_110138_aP());
                this.lastSafePosition = this.func_233580_cy_();
            }
            this.isInitialized = true;
        }
        this.bossInfo.tick((LivingEntity)this);
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            LivingEntity target;
            this.trySwitchingMovementMode();
            if (this.field_70170_p.func_82737_E() % 20L == 0L) {
                boolean isOutsideBounds;
                boolean isSuffocating = this.field_70170_p.func_180495_p(this.func_233580_cy_()).func_229980_m_((IBlockReader)this.field_70170_p, this.func_233580_cy_());
                boolean bl = isOutsideBounds = !AbilityHelper.isWithinChallengeArenaBounds(this.field_70170_p, this.func_233580_cy_());
                if (!isSuffocating) {
                    this.lastSafePosition = this.func_233580_cy_();
                } else if (isSuffocating || isOutsideBounds) {
                    this.func_174828_a(this.lastSafePosition, this.field_70177_z, this.field_70125_A);
                }
            }
            if (this.func_70638_az() == null && !this.hasEmptyTargetsList) {
                List<LivingEntity> challengers = this.challengeInfo.getChallengerGroup();
                if (challengers.isEmpty()) {
                    this.hasEmptyTargetsList = true;
                    return;
                }
                for (LivingEntity target2 : challengers) {
                    if (!this.canTarget(target2)) continue;
                    this.func_70624_b(target2);
                    break;
                }
            } else if (this.func_70638_az() != null && !this.canTarget(target = this.func_70638_az())) {
                this.func_70624_b(null);
            }
        }
    }

    private boolean canTarget(LivingEntity target) {
        return !target.func_70644_a((Effect)ModEffects.CHALLENGE_FAILED.get());
    }

    private void trySwitchingMovementMode() {
        if (this.func_70090_H() && this.movementType == 0) {
            this.switchToWaterMovement();
        } else if (!this.func_70090_H() && this.movementType == 1) {
            this.switchToGroundMovement();
        }
    }

    public void func_70636_d() {
        this.func_82168_bl();
        super.func_70636_d();
    }

    public void func_70619_bc() {
        this.phaseManager.tick();
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        if (this.bossInfo != null) {
            this.bossInfo.func_186760_a(player);
        }
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        if (this.bossInfo != null) {
            this.bossInfo.func_186761_b(player);
        }
    }

    public void remove(boolean keepData) {
        Crew crew;
        ExtendedWorldData worldData;
        if (this.entityStats.isPirate() && (worldData = ExtendedWorldData.get()) != null && (crew = worldData.getCrewWithMember(this.func_110124_au())) != null) {
            crew.removeMember(this.func_110124_au());
        }
        super.remove(keepData);
    }

    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        spawnData = super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
        this.func_184641_n(false);
        return spawnData;
    }

    public boolean func_213397_c(double distance) {
        return false;
    }

    public void writeSpawnData(PacketBuffer buffer) {
    }

    public void readSpawnData(PacketBuffer buffer) {
    }

    @Override
    public ChallengeInfo getChallengeInfo() {
        return this.challengeInfo;
    }

    @Override
    public NPCPhaseManager getPhaseManager() {
        return this.phaseManager;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setDamageCeiling(float damageCeiling) {
        this.damageCeiling = damageCeiling;
    }

    public float getDamageCeiling() {
        return this.damageCeiling;
    }

    public float getDifficultyScaling() {
        return this.challengeInfo.getScaling();
    }

    public void switchToWaterMovement() {
        this.field_70765_h = this.waterMovementController;
        this.movementType = 1;
    }

    public void switchToGroundMovement() {
        this.field_70765_h = this.groundMovementController;
        this.movementType = 0;
    }
}

