/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.challenges;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeDifficulty;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeInfo;
import xyz.pixelatedw.mineminenomi.api.entities.IPhasesEntity;
import xyz.pixelatedw.mineminenomi.api.entities.IRevengeEntity;
import xyz.pixelatedw.mineminenomi.api.entities.ai.NPCPhaseManager;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.RevengeMeter;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;

public interface IChallengeBoss
extends IRevengeEntity,
IPhasesEntity {
    public static final UUID GROUP_SCALE_HP_UUID = UUID.fromString("a66a0da1-286f-4772-9684-1b30810152f5");
    public static final UUID GROUP_SCALE_TOUGHNESS_UUID = UUID.fromString("64c28e45-7adf-41b5-8d64-933ca6b8288b");
    public static final UUID GROUP_SCALE_ATTACK_UUID = UUID.fromString("378cc4c7-d7a2-47f8-8b94-123ef5229196");
    public static final UUID GROUP_SCALE_GCD_UUID = UUID.fromString("94233c8f-9ca6-427b-a2d1-9745df50c4ba");

    public ChallengeInfo getChallengeInfo();

    default public void applyDifficultyModifiers(LivingEntity entity) {
        float scale = this.getChallengeInfo().getScaling();
        if (scale > 0.0f) {
            ModifiableAttributeInstance gcdAttr;
            ModifiableAttributeInstance attackAttr;
            ModifiableAttributeInstance toughnessAttr;
            ModifiableAttributeInstance hpAttr = entity.func_110148_a(Attributes.field_233818_a_);
            if (hpAttr != null) {
                hpAttr.func_233769_c_(new AttributeModifier(GROUP_SCALE_HP_UUID, "Group Scaling Health Modifier", this.getHealthScalingModifier(scale), AttributeModifier.Operation.MULTIPLY_BASE));
            }
            if ((toughnessAttr = entity.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get())) != null) {
                toughnessAttr.func_233769_c_(new AttributeModifier(GROUP_SCALE_TOUGHNESS_UUID, "Group Scaling Toughness Modifier", this.getToughnessScalingModifier(scale), AttributeModifier.Operation.ADDITION));
            }
            if ((attackAttr = entity.func_110148_a(Attributes.field_233823_f_)) != null) {
                attackAttr.func_233769_c_(new AttributeModifier(GROUP_SCALE_ATTACK_UUID, "Group Scaling Health Modifier", this.getAttackScalingModifier(scale), AttributeModifier.Operation.ADDITION));
            }
            if ((gcdAttr = entity.func_110148_a((Attribute)ModAttributes.GCD.get())) != null) {
                gcdAttr.func_233769_c_(new AttributeModifier(GROUP_SCALE_GCD_UUID, "Group Scaling GCD Modifier", this.getGCDScalingModifier(scale), AttributeModifier.Operation.ADDITION));
            }
        }
    }

    @Override
    @Nullable
    default public NPCPhaseManager getPhaseManager() {
        return null;
    }

    @Override
    @Nullable
    default public RevengeMeter getRevengeMeter() {
        return null;
    }

    default public boolean isDifficultyStandard() {
        return this.getChallengeInfo().isDifficultyStandard();
    }

    default public boolean isDifficultyHard() {
        return this.getChallengeInfo().isDifficultyHard();
    }

    default public boolean isDifficultyHardOrAbove() {
        return this.getChallengeInfo().getDifficulty().ordinal() >= ChallengeDifficulty.HARD.ordinal();
    }

    default public boolean isDifficultyUltimate() {
        return this.getChallengeInfo().isDifficultyUltimate();
    }

    default public double getHealthScalingModifier(float scale) {
        return scale;
    }

    default public double getToughnessScalingModifier(float scale) {
        return 4.0f * scale;
    }

    default public double getAttackScalingModifier(float scale) {
        return 3.0f * scale;
    }

    default public double getGCDScalingModifier(float scale) {
        return -(15.0f * scale);
    }
}

