/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.challenges;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EnderChestInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;

public class ChallengeCache {
    private float health;
    private int hunger;
    private float saturation;
    private INBT entityStats;
    private final NonNullList<ItemStack> items = NonNullList.func_191197_a((int)36, (Object)ItemStack.field_190927_a);
    private final NonNullList<ItemStack> armor = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private final NonNullList<ItemStack> offhand = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    private final NonNullList<ItemStack> enderChest = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);

    public static ChallengeCache from(LivingEntity entity) {
        ChallengeCache cache = new ChallengeCache();
        cache.health = entity.func_110143_aJ();
        cache.entityStats = EntityStatsCapability.INSTANCE.writeNBT((Object)EntityStatsCapability.get(entity), null);
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            cache.hunger = player.func_71024_bL().func_75116_a();
            cache.saturation = player.func_71024_bL().func_75115_e();
            ListNBT inventory = new ListNBT();
            player.field_71071_by.func_70442_a(inventory);
            cache.loadInventoryData(inventory);
            EnderChestInventory enderChest = player.func_71005_bN();
            for (int i = 0; i < enderChest.func_70302_i_(); ++i) {
                ItemStack stack = enderChest.func_70301_a(i);
                cache.enderChest.set(i, (Object)stack);
            }
        }
        return cache;
    }

    public static ChallengeCache from(CompoundNBT nbt) {
        ChallengeCache cache = new ChallengeCache();
        cache.load(nbt);
        return cache;
    }

    public void restore(LivingEntity entity) {
        entity.func_70606_j(this.health);
        EntityStatsCapability.INSTANCE.readNBT((Object)EntityStatsCapability.get(entity), null, this.entityStats);
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            player.func_71024_bL().func_75114_a(this.hunger);
            ListNBT inventory = this.saveInventoryData();
            player.field_71071_by.func_70443_b(inventory);
            EnderChestInventory enderInventory = player.func_71005_bN();
            for (int i = 0; i < this.enderChest.size(); ++i) {
                ItemStack stack = (ItemStack)this.enderChest.get(i);
                enderInventory.func_70299_a(i, stack);
            }
        }
    }

    public CompoundNBT save() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74776_a("health", this.health);
        nbt.func_74768_a("hunger", this.hunger);
        nbt.func_74776_a("saturation", this.saturation);
        nbt.func_218657_a("inventory", (INBT)this.saveInventoryData());
        nbt.func_218657_a("entityStats", this.entityStats);
        return nbt;
    }

    private ListNBT saveInventoryData() {
        ListNBT inventory = new ListNBT();
        for (int i = 0; i < this.items.size(); ++i) {
            if (((ItemStack)this.items.get(i)).func_190926_b()) continue;
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.items.get(i)).func_77955_b(compoundnbt);
            inventory.add((Object)compoundnbt);
        }
        for (int j = 0; j < this.armor.size(); ++j) {
            if (((ItemStack)this.armor.get(j)).func_190926_b()) continue;
            CompoundNBT compoundnbt1 = new CompoundNBT();
            compoundnbt1.func_74774_a("Slot", (byte)(j + 100));
            ((ItemStack)this.armor.get(j)).func_77955_b(compoundnbt1);
            inventory.add((Object)compoundnbt1);
        }
        for (int k = 0; k < this.offhand.size(); ++k) {
            if (((ItemStack)this.offhand.get(k)).func_190926_b()) continue;
            CompoundNBT compoundnbt2 = new CompoundNBT();
            compoundnbt2.func_74774_a("Slot", (byte)(k + 150));
            ((ItemStack)this.offhand.get(k)).func_77955_b(compoundnbt2);
            inventory.add((Object)compoundnbt2);
        }
        return inventory;
    }

    public void load(CompoundNBT nbt) {
        this.health = nbt.func_74760_g("health");
        this.hunger = nbt.func_74762_e("hunger");
        this.saturation = nbt.func_74760_g("saturation");
        this.items.clear();
        this.armor.clear();
        this.offhand.clear();
        ListNBT inventory = nbt.func_150295_c("inventory", 10);
        this.loadInventoryData(inventory);
        this.entityStats = nbt.func_74781_a("entityStats");
    }

    private void loadInventoryData(ListNBT inventory) {
        for (int i = 0; i < inventory.size(); ++i) {
            CompoundNBT compoundnbt = inventory.func_150305_b(i);
            int j = compoundnbt.func_74771_c("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.func_199557_a((CompoundNBT)compoundnbt);
            if (itemstack.func_190926_b()) continue;
            if (j >= 0 && j < this.items.size()) {
                this.items.set(j, (Object)itemstack);
                continue;
            }
            if (j >= 100 && j < this.armor.size() + 100) {
                this.armor.set(j - 100, (Object)itemstack);
                continue;
            }
            if (j < 150 || j >= this.offhand.size() + 150) continue;
            this.offhand.set(j - 150, (Object)itemstack);
        }
    }
}

