/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.challenges;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.ModMain;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeCore;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeDifficulty;
import xyz.pixelatedw.mineminenomi.api.enums.StatChangeSource;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.init.ModAdvancements;
import xyz.pixelatedw.mineminenomi.init.ModLootTypes;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public abstract class Challenge {
    private final ChallengeCore<?> core;
    private int completions;
    private int bestTime;

    public Challenge(ChallengeCore<?> core) {
        this.core = core;
    }

    public String getCategory() {
        return this.core.getCategory();
    }

    public void resetBestTime() {
        this.bestTime = 0;
    }

    public void tryUpdateBestTime(int time) {
        if (this.getBestTimeTick() == 0) {
            this.bestTime = time;
            return;
        }
        if (this.isPersonalBest(time)) {
            this.bestTime = time;
        }
    }

    public boolean isPersonalBest(int time) {
        int pb = this.getBestTimeTick();
        return pb > 0 && time < pb;
    }

    public int getBestTimeTick() {
        return this.bestTime;
    }

    public String getFormattedBestTime() {
        return WyHelper.formatTimeMMSS(this.bestTime);
    }

    public void setComplete(PlayerEntity player, boolean isComplete) {
        if (isComplete) {
            this.complete(player);
        } else {
            this.completions = 0;
        }
    }

    public void complete(PlayerEntity player) {
        ++this.completions;
        if (this.isFirstCompletion() && player instanceof ServerPlayerEntity) {
            ModAdvancements.COMPLETE_CHALLENGE.trigger((ServerPlayerEntity)player, this.core);
        }
    }

    public boolean isFirstCompletion() {
        return this.completions == 1;
    }

    public boolean isComplete() {
        return this.completions > 0;
    }

    public int getCompletions() {
        return this.completions;
    }

    public ChallengeCore getCore() {
        return this.core;
    }

    @Nullable
    public String getRewards(PlayerEntity player) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IHakiData hakiData = HakiDataCapability.get((LivingEntity)player);
        ArrayList stacks = Lists.newArrayList();
        if (this.core.getRewards() != null) {
            LootTable lootTable = player.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(this.core.getRewards());
            if (lootTable == LootTable.field_186464_a) {
                ModMain.LOGGER.warn(this.core.getRewards() + " reward could not be found.");
                return null;
            }
            LootContext.Builder builder = new LootContext.Builder((ServerWorld)player.field_70170_p).func_216015_a(LootParameters.field_216281_a, (Object)player).func_216015_a(ModLootTypes.COMPLETED_CHALLENGE, this.core);
            LootContext context = builder.func_216022_a(LootParameterSets.field_216260_a);
            stacks.addAll(lootTable.func_216113_a(context));
        }
        StringBuilder sb = new StringBuilder();
        boolean hasAtLeastOneReward = false;
        if (stacks.size() > 0) {
            sb.append("\n\u00a7aRewards\u00a7r\n");
            hasAtLeastOneReward = true;
        }
        boolean canReceiveStats = false;
        if (this.completions == 0) {
            canReceiveStats = true;
        } else if (this.core.getDifficulty() == ChallengeDifficulty.HARD) {
            canReceiveStats = true;
        }
        if (canReceiveStats) {
            float registeredChallengesTotalScale = ModRegistries.CHALLENGES.getValues().stream().filter(oc -> oc.getDifficulty().equals((Object)this.core.getDifficulty())).map(cc -> Float.valueOf(cc.getRewardsFactor())).reduce(Float.valueOf(0.0f), (acc, val) -> Float.valueOf(acc.floatValue() + val.floatValue())).floatValue();
            float challengeRewardFactor = this.core.getRewardsFactor() / registeredChallengesTotalScale;
            float rawDorikiAmount = challengeRewardFactor * (float)CommonConfig.INSTANCE.getDorikiRewardPoolForDifficulty(this.core.getDifficulty());
            float rawBellyAmount = challengeRewardFactor * (float)CommonConfig.INSTANCE.getBellyRewardPoolForDifficulty(this.core.getDifficulty());
            float rawHakiAmount = challengeRewardFactor * (float)CommonConfig.INSTANCE.getHakiRewardPoolForDifficulty(this.core.getDifficulty());
            int dorikiAmount = this.scaleValueWithRounding(rawDorikiAmount);
            int bellyAmount = this.scaleValueWithRounding(rawBellyAmount);
            float hakiAmount = this.scaleValueFromCompletions(rawHakiAmount);
            hakiAmount = (float)Math.round(hakiAmount * 100.0f) / 100.0f;
            if (dorikiAmount > 0) {
                props.alterDoriki(dorikiAmount, StatChangeSource.CHALLENGE);
                sb.append("  " + dorikiAmount + " Doriki\n");
            }
            if (bellyAmount > 0) {
                props.alterBelly(bellyAmount, StatChangeSource.CHALLENGE);
                sb.append("  " + bellyAmount + " Belly\n");
            }
            if (hakiAmount > 0.0f) {
                if (player.func_70681_au().nextBoolean()) {
                    hakiData.alterBusoshokuHakiExp(hakiAmount, StatChangeSource.CHALLENGE);
                    sb.append("  " + hakiAmount + " Busoshoku Haki Experience\n");
                } else {
                    hakiData.alterKenbunshokuHakiExp(hakiAmount, StatChangeSource.CHALLENGE);
                    sb.append("  " + hakiAmount + " Kenbunshoku Haki Experience\n");
                }
            }
        }
        for (ItemStack stack : stacks) {
            if (stack.func_77978_p() != null && stack.func_200301_q().getString().contains("_rewards")) {
                int newUnlocks;
                int dorikiAmount = stack.func_77978_p().func_74762_e("_rewardsDoriki");
                int bellyAmount = stack.func_77978_p().func_74762_e("_rewardsBelly");
                int extolAmount = stack.func_77978_p().func_74762_e("_rewardsExtol");
                int bountyAmount = stack.func_77978_p().func_74762_e("_rewardsBounty");
                int busoHakiAmount = stack.func_77978_p().func_74762_e("_rewardsBusoHaki");
                int obsHakiAmount = stack.func_77978_p().func_74762_e("_rewardsKenHaki");
                if (dorikiAmount > 0) {
                    sb.append("  " + dorikiAmount + " Doriki\n");
                }
                if (bellyAmount > 0) {
                    sb.append("  " + bellyAmount + " Belly\n");
                }
                if (extolAmount > 0) {
                    sb.append("  " + extolAmount + " Extol\n");
                }
                if (bountyAmount > 0) {
                    sb.append("  " + bountyAmount + " Bounty\n");
                }
                if (bountyAmount > 0) {
                    sb.append("  " + bountyAmount + " Bounty\n");
                }
                if (busoHakiAmount > 0) {
                    sb.append("  " + busoHakiAmount + " Busoshoku Haki Experience\n");
                }
                if (obsHakiAmount > 0) {
                    sb.append("  " + obsHakiAmount + " Kenbunshoku Haki Experience\n");
                }
                if ((newUnlocks = stack.func_77978_p().func_74762_e("_unlocksAmount")) <= 0) continue;
                ListNBT unlocksList = stack.func_77978_p().func_150295_c("_unlocks", 8);
                for (int i = 0; i < unlocksList.size(); ++i) {
                    String title = unlocksList.func_150307_f(i);
                    sb.append("  New Challenge unlocked " + title + "\n");
                }
                continue;
            }
            ItemStack stackCopy = stack.func_77946_l();
            sb.append("  " + (stackCopy.func_190916_E() > 1 ? stackCopy.func_190916_E() + " " : "") + stackCopy.func_200301_q().getString() + "\n");
            player.func_191521_c(stackCopy);
        }
        if (hasAtLeastOneReward) {
            WyNetwork.sendTo(new SSyncEntityStatsPacket(player.func_145782_y(), props), player);
            sb.append("\n");
        }
        return sb.toString();
    }

    public int scaleValueWithRounding(float amount) {
        if ((amount = this.scaleValueFromCompletions(amount)) % 10.0f != 0.0f && amount > 10.0f) {
            amount = WyHelper.roundToNiceNumber(amount);
        }
        return (int)amount;
    }

    public float scaleValueFromCompletions(float amount) {
        int completions = this.getCompletions();
        if ((completions = Math.min(completions, 10)) > 0) {
            float d = (float)completions * 1.5f;
            amount /= d;
        }
        return amount;
    }

    public CompoundNBT save(CompoundNBT nbt) {
        nbt.func_74768_a("completions", this.completions);
        nbt.func_74768_a("bestTime", this.bestTime);
        return nbt;
    }

    public void load(CompoundNBT nbt) {
        this.completions = nbt.func_74764_b("isComplete") ? (nbt.func_74767_n("isComplete") ? 1 : 0) : nbt.func_74762_e("completions");
        this.bestTime = nbt.func_74762_e("bestTime");
    }

    public boolean equals(Object challenge) {
        if (challenge instanceof ChallengeCore && challenge.equals((Object)this.getCore())) {
            return true;
        }
        if (!(challenge instanceof Challenge)) {
            return false;
        }
        if (this.getCore() == null || ((Challenge)challenge).getCore() == null) {
            return false;
        }
        return ((Object)((Object)this.getCore())).equals((Object)((Challenge)challenge).getCore());
    }
}

