/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.util.PriorityEventPool;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.packets.server.ability.components.SSwingTriggerPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class SwingTriggerComponent
extends AbilityComponent<IAbility> {
    private final PriorityEventPool<IOnSwingEvent> swingEvents = new PriorityEventPool();
    private long lastSwingTime;

    public SwingTriggerComponent(IAbility ability) {
        super(ModAbilityKeys.SWING_TRIGGER, ability);
    }

    public SwingTriggerComponent addSwingEvent(IOnSwingEvent event) {
        this.swingEvents.addEvent(event);
        return this;
    }

    public SwingTriggerComponent addSwingEvent(int priority, IOnSwingEvent event) {
        this.swingEvents.addEvent(priority, event);
        return this;
    }

    public void swing(LivingEntity entity) {
        this.ensureIsRegistered();
        if (this.getAbility().hasComponent(ModAbilityKeys.DISABLE) && this.getAbility().getComponent(ModAbilityKeys.DISABLE).get().isDisabled()) {
            return;
        }
        if (this.getAbility().hasComponent(ModAbilityKeys.COOLDOWN) && this.getAbility().getComponent(ModAbilityKeys.COOLDOWN).get().isOnCooldown()) {
            return;
        }
        this.swingEvents.dispatch(event -> event.swing(entity, (IAbility)this.getAbility()));
        this.lastSwingTime = entity.field_70170_p.func_82737_E();
        if (!entity.field_70170_p.field_72995_K) {
            WyNetwork.sendToAllTrackingAndSelf(new SSwingTriggerPacket(entity, (IAbility)this.getAbility()), (Entity)entity);
        }
    }

    public long getLastSwingTime() {
        return this.lastSwingTime;
    }

    @FunctionalInterface
    public static interface IOnSwingEvent {
        public void swing(LivingEntity var1, IAbility var2);
    }
}

