/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityStat;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.util.PriorityEventPool;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.packets.server.ability.components.SSetStacksPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class StackComponent
extends AbilityComponent<IAbility> {
    public static final TranslationTextComponent STACKS_STAT = new TranslationTextComponent(ModI18n.ABILITY_DESCRIPTION_STAT_NAME_STACKS);
    private int defaultStacks = 0;
    private int stacks = -1;
    private final PriorityEventPool<IStacksChangeEvent> changeStackEvents = new PriorityEventPool();

    public static AbilityDescriptionLine.IDescriptionLine getTooltip(int stacks) {
        return StackComponent.getTooltip(stacks, stacks);
    }

    public static AbilityDescriptionLine.IDescriptionLine getTooltip(int min, int max) {
        return (e, a) -> {
            AbilityStat.Builder statBuilder = new AbilityStat.Builder((ITextComponent)STACKS_STAT, min, max);
            return statBuilder.build().getStatDescription();
        };
    }

    public StackComponent(IAbility ability) {
        this(ability, 0);
    }

    public StackComponent(IAbility ability, int defaultStacks) {
        super(ModAbilityKeys.STACK, ability);
        this.defaultStacks = defaultStacks;
    }

    @Override
    public void postInit(IAbility ability) {
        ability.getComponent(ModAbilityKeys.SLOT_DECORATION).ifPresent(component -> component.addPostRenderEvent(500, (entity, minecraft, matrix, x, y, partialTicks) -> {
            if (this.getStacks() > 0) {
                matrix.func_227860_a_();
                matrix.func_227861_a_((double)(x + 16.0f), (double)(y + 14.0f), 5.0);
                matrix.func_227862_a_(0.76f, 0.76f, 0.76f);
                WyHelper.drawStringWithBorder(minecraft.field_71466_p, matrix, this.getStacks() + "", 0, 0, -1);
                matrix.func_227865_b_();
            }
        }));
        if (ability instanceof Ability) {
            ((Ability)ability).addEquipEvent(this::onAbilityEquipped);
        }
    }

    public StackComponent addStackChangeEvent(IStacksChangeEvent event) {
        this.changeStackEvents.addEvent(event);
        return this;
    }

    public StackComponent addStackChangeEvent(int priority, IStacksChangeEvent event) {
        this.changeStackEvents.addEvent(priority, event);
        return this;
    }

    public void revertStacksToDefault(LivingEntity entity, IAbility ability) {
        this.setStacks(entity, ability, this.defaultStacks);
    }

    public void addStacks(LivingEntity entity, IAbility ability, int stacks) {
        this.setStacks(entity, ability, this.stacks + stacks);
    }

    public void setStacks(LivingEntity entity, IAbility ability, int stacks) {
        this.ensureIsRegistered();
        if (this.stacks == stacks) {
            return;
        }
        this.stacks = stacks;
        this.changeStackEvents.dispatch(event -> event.onStacksChange(entity, (IAbility)this.getAbility(), stacks));
        if (!entity.field_70170_p.field_72995_K) {
            boolean sharesStacks;
            Optional<StackComponent> stackComponent;
            Optional<PoolComponent> poolComponent;
            IAbilityData abilityDataProps = AbilityDataCapability.get(entity);
            int usedStacks = 0;
            int maxDefaultStacks = 0;
            for (IAbility abl : abilityDataProps.getEquippedAndPassiveAbilities()) {
                poolComponent = abl.getComponent(ModAbilityKeys.POOL);
                stackComponent = abl.getComponent(ModAbilityKeys.STACK);
                if (!poolComponent.isPresent() || !stackComponent.isPresent() || !(sharesStacks = poolComponent.get().getPools().stream().anyMatch(pool -> pool.getFlagValue("shareStacks", () -> false)))) continue;
                int defaultStacks = stackComponent.get().getDefaultStacks();
                if (stackComponent.get().getDefaultStacks() > maxDefaultStacks) {
                    maxDefaultStacks = defaultStacks;
                }
                usedStacks += defaultStacks - stackComponent.get().getStacks();
            }
            for (IAbility abl : abilityDataProps.getEquippedAndPassiveAbilities()) {
                poolComponent = abl.getComponent(ModAbilityKeys.POOL);
                stackComponent = abl.getComponent(ModAbilityKeys.STACK);
                if (!poolComponent.isPresent() || !stackComponent.isPresent() || !(sharesStacks = poolComponent.get().getPools().stream().anyMatch(pool -> pool.getFlagValue("shareStacks", () -> false))) || usedStacks < maxDefaultStacks || stackComponent.get().getStacks() == stackComponent.get().getDefaultStacks()) continue;
                stackComponent.get().stacks = 0;
                WyNetwork.sendToAllTrackingAndSelf(new SSetStacksPacket(entity, abl, stacks), (Entity)entity);
            }
            WyNetwork.sendToAllTrackingAndSelf(new SSetStacksPacket(entity, ability, stacks), (Entity)entity);
        }
    }

    public void setDefaultStacks(int defaultStacks) {
        this.defaultStacks = defaultStacks;
    }

    public int getDefaultStacks() {
        return this.defaultStacks;
    }

    public int getStacks() {
        return this.stacks;
    }

    private void onAbilityEquipped(LivingEntity entity, IAbility ability) {
        if (this.stacks < 0) {
            this.stacks = this.defaultStacks;
        }
    }

    @Override
    @Nullable
    public CompoundNBT save() {
        CompoundNBT nbt = super.save();
        nbt.func_74768_a("defaultStacks", this.defaultStacks);
        nbt.func_74768_a("stacks", this.stacks);
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt) {
        super.load(nbt);
        this.defaultStacks = nbt.func_74762_e("defaultStacks");
        this.stacks = nbt.func_74762_e("stacks");
    }

    @FunctionalInterface
    public static interface IStacksChangeEvent {
        public void onStacksChange(LivingEntity var1, IAbility var2, int var3);
    }
}

