/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import java.util.List;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityStat;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusManager;
import xyz.pixelatedw.mineminenomi.api.helpers.TargetHelper;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class RangeComponent
extends AbilityComponent<IAbility> {
    private static final UUID RANGE_BONUS_MANAGER_UUID = UUID.fromString("c3bc77bd-2f17-4d99-bcb6-e2305b5c075f");
    public static final TranslationTextComponent RANGE_STAT = new TranslationTextComponent(ModI18n.ABILITY_DESCRIPTION_STAT_NAME_RANGE);
    private float previousRange;
    private float previousDistance;
    private TargetsPredicate areaCheck = TargetsPredicate.DEFAULT_AREA_CHECK;
    private TargetsPredicate lineCheck = TargetsPredicate.DEFAULT_LINE_CHECK;
    private final BonusManager bonusManager = new BonusManager(RANGE_BONUS_MANAGER_UUID);

    public static AbilityDescriptionLine.IDescriptionLine getTooltip(float range, RangeType type) {
        return RangeComponent.getTooltip(range, range, type);
    }

    public static AbilityDescriptionLine.IDescriptionLine getTooltip(float min, float max, RangeType type) {
        return (e, a) -> {
            AbilityStat.Builder statBuilder = new AbilityStat.Builder((ITextComponent)RANGE_STAT, min, max);
            a.getComponent(ModAbilityKeys.RANGE).ifPresent(comp -> {
                float bonus = comp.getBonusManager().applyBonus(comp.getPreviousRange()) - comp.getPreviousRange();
                AbilityStat.AbilityStatType bonusType = bonus > 0.0f ? AbilityStat.AbilityStatType.BUFF : (bonus < 0.0f ? AbilityStat.AbilityStatType.DEBUFF : AbilityStat.AbilityStatType.NEUTRAL);
                statBuilder.withBonus(bonus, bonusType);
            });
            TranslationTextComponent unit = ModI18n.ABILITY_DESCRIPTION_STAT_UNIT_BLOCKS;
            switch (type) {
                case AOE: {
                    unit = ModI18n.ABILITY_DESCRIPTION_STAT_UNIT_AOE_BLOCKS;
                    break;
                }
                case CONE: {
                    unit = ModI18n.ABILITY_DESCRIPTION_STAT_UNIT_CONE_BLOCKS;
                    break;
                }
                case LINE: {
                    unit = ModI18n.ABILITY_DESCRIPTION_STAT_UNIT_LINE_BLOCKS;
                    break;
                }
            }
            return statBuilder.withUnit((ITextComponent)unit).build().getStatDescription();
        };
    }

    public RangeComponent(IAbility ability) {
        super(ModAbilityKeys.RANGE, ability);
        this.addBonusManager(this.bonusManager);
    }

    public List<LivingEntity> getTargetsInArea(LivingEntity entity, float range) {
        return this.getTargetsInArea(entity, range, this.areaCheck);
    }

    public List<LivingEntity> getTargetsInArea(LivingEntity entity, BlockPos centerPos, float range) {
        return this.getTargetsInArea(entity, centerPos, range, this.areaCheck);
    }

    public List<LivingEntity> getTargetsInArea(LivingEntity entity, float range, TargetsPredicate predicate) {
        return this.getTargetsInArea(entity, entity.func_233580_cy_(), range, predicate);
    }

    public List<LivingEntity> getTargetsInArea(LivingEntity entity, BlockPos centerPos, float range, TargetsPredicate predicate) {
        this.ensureIsRegistered();
        this.previousRange = range;
        range = this.bonusManager.applyBonus(range);
        return TargetHelper.getEntitiesInArea(entity, centerPos, (double)range, predicate, new Class[0]);
    }

    public List<LivingEntity> getTargetsInLine(LivingEntity entity, float distance, float width) {
        return this.getTargetsInLine(entity, distance, width, this.lineCheck);
    }

    public List<LivingEntity> getTargetsInLine(LivingEntity entity, BlockPos centerPos, float distance, float width) {
        return this.getTargetsInLine(entity, centerPos, distance, width, this.lineCheck);
    }

    public List<LivingEntity> getTargetsInLine(LivingEntity entity, float distance, float width, TargetsPredicate predicate) {
        return this.getTargetsInLine(entity, entity.func_233580_cy_(), distance, width, predicate);
    }

    public List<LivingEntity> getTargetsInLine(LivingEntity entity, BlockPos centerPos, float distance, float width, TargetsPredicate predicate) {
        this.ensureIsRegistered();
        this.previousRange = width;
        this.previousDistance = distance;
        distance = this.bonusManager.applyBonus(distance);
        width = this.bonusManager.applyBonus(width);
        return TargetHelper.getEntitiesInLine(entity, centerPos, distance, width, predicate, new Class[0]);
    }

    public float getPreviousRange() {
        return this.previousRange;
    }

    public float getRange() {
        return this.bonusManager.applyBonus(this.previousRange);
    }

    public float getPreviousDistance() {
        return this.previousDistance;
    }

    public float getDistance() {
        return this.bonusManager.applyBonus(this.previousDistance);
    }

    public void setAreaCheck(TargetsPredicate check) {
        this.areaCheck = check;
    }

    public void setLineCheck(TargetsPredicate check) {
        this.lineCheck = check;
    }

    public BonusManager getBonusManager() {
        return this.bonusManager;
    }

    public static enum RangeType {
        AOE,
        CONE,
        LINE;

    }
}

