/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetPassengersPacket;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.packets.server.ability.components.SChangeMorphPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class MorphComponent
extends AbilityComponent<IAbility> {
    private MorphInfo morphInfo;
    private boolean isMorphed;

    public MorphComponent(IAbility ability) {
        super(ModAbilityKeys.MORPH, ability);
    }

    public void startMorph(LivingEntity entity, MorphInfo info) {
        this.ensureIsRegistered();
        this.morphInfo = info;
        IDevilFruit props = DevilFruitCapability.get(entity);
        props.addMorph(info);
        this.isMorphed = true;
        this.updateMorphSize(entity);
    }

    public void updateMorphSize(LivingEntity entity) {
        if (this.morphInfo == null) {
            return;
        }
        MinecraftForge.EVENT_BUS.post((Event)new EntityEvent.Size((Entity)entity, entity.func_213283_Z(), entity.func_213305_a(entity.func_213283_Z()), entity.func_213302_cg()));
        entity.func_213323_x_();
        entity.func_184226_ay();
        if (!entity.field_70170_p.field_72995_K) {
            WyNetwork.sendToAllTrackingAndSelf(new SChangeMorphPacket(entity, (IAbility)this.getAbility(), this.morphInfo, this.isMorphed ? this.morphInfo.getForm() : ""), (Entity)entity);
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SSetPassengersPacket((Entity)entity));
        }
    }

    public void stopMorph(LivingEntity entity) {
        IDevilFruit props = DevilFruitCapability.get(entity);
        if (this.getMorphInfo() == null) {
            return;
        }
        props.removeMorph(this.morphInfo);
        this.isMorphed = false;
        this.updateMorphSize(entity);
        this.morphInfo = null;
    }

    @Nullable
    public MorphInfo getMorphInfo() {
        return this.morphInfo;
    }

    public boolean isMorphed() {
        return this.isMorphed;
    }

    @Override
    @Nullable
    public CompoundNBT save() {
        CompoundNBT nbt = super.save();
        nbt.func_74757_a("isMorphed", this.isMorphed);
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt) {
        super.load(nbt);
        this.isMorphed = nbt.func_74767_n("isMorphed");
    }
}

