/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.loading.FMLEnvironment;
import xyz.pixelatedw.mineminenomi.ModMain;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.animations.Animation;
import xyz.pixelatedw.mineminenomi.api.animations.AnimationId;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.packets.server.ability.components.SChangeAnimationStatePacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class AnimationComponent
extends AbilityComponent<IAbility> {
    private Function<LivingEntity, Boolean> stopCondition;
    private AnimationId<?> animationId;
    private Animation animation;
    private long startTime;
    private long animTick;
    private int animDuration;
    private State state = State.STOP;

    public AnimationComponent(IAbility ability) {
        super(ModAbilityKeys.ANIMATION, ability);
    }

    @Nullable
    public <T extends Animation> T getAnimation() {
        return (T)this.animation;
    }

    public <A extends Animation<?, ?>> void start(LivingEntity entity, AnimationId<A> animationId) {
        this.start(entity, animationId, -1, null);
    }

    public <A extends Animation<?, ?>> void start(LivingEntity entity, AnimationId<A> animationId, int animationDuration) {
        this.start(entity, animationId, animationDuration, null);
    }

    public <A extends Animation<?, ?>> void start(LivingEntity entity, AnimationId<A> animationId, int animationDuration, @Nullable Function<LivingEntity, Boolean> stopCondition) {
        this.ensureIsRegistered();
        if (this.isPlaying()) {
            return;
        }
        this.animationId = animationId;
        if (entity.field_70170_p.field_72995_K) {
            this.animation = AnimationId.getRegisteredAnimation(animationId);
            if (this.animation == null) {
                ModMain.LOGGER.warn("No animation with id " + animationId.getId().toString() + " found.");
                return;
            }
        }
        this.stopCondition = stopCondition;
        if (this.stopCondition != null && this.stopCondition.apply(entity).booleanValue()) {
            return;
        }
        this.startTime = entity.field_70170_p.func_82737_E();
        this.animTick = 0L;
        this.animDuration = animationDuration;
        this.state = State.PLAY;
        if (!entity.field_70170_p.field_72995_K) {
            WyNetwork.sendToAllTrackingAndSelf(new SChangeAnimationStatePacket(entity, (IAbility)this.getAbility(), animationId, this.state, this.animDuration), (Entity)entity);
        }
    }

    public void stop(LivingEntity entity) {
        if (this.isStopped()) {
            return;
        }
        this.animTick = 0L;
        this.state = State.STOP;
        if (!entity.field_70170_p.field_72995_K) {
            WyNetwork.sendToAllTrackingAndSelf(new SChangeAnimationStatePacket(entity, (IAbility)this.getAbility(), null, this.state, 0), (Entity)entity);
        }
    }

    @Override
    public void doTick(LivingEntity entity) {
        if (!entity.field_70170_p.field_72995_K && this.isPlaying()) {
            if (this.stopCondition != null && this.stopCondition.apply(entity).booleanValue()) {
                this.stop(entity);
                return;
            }
            if (this.animDuration != -1 && this.animDuration <= 0) {
                this.stop(entity);
                return;
            }
        }
        if (this.isPlaying()) {
            ++this.animTick;
            if (this.animDuration > -1) {
                --this.animDuration;
            }
        }
    }

    @Override
    @Nullable
    public CompoundNBT save() {
        CompoundNBT nbt = super.save();
        if (this.animationId != null) {
            nbt.func_74778_a("animationId", this.animationId.getId().toString());
        }
        nbt.func_74768_a("animDuration", this.animDuration);
        nbt.func_74772_a("animTick", this.animTick);
        nbt.func_74772_a("startTime", this.startTime);
        nbt.func_74768_a("state", this.state.ordinal());
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt) {
        super.load(nbt);
        if (nbt.func_74764_b("animationId")) {
            this.animationId = AnimationId.getRegisteredId(new ResourceLocation(nbt.func_74779_i("animationId")));
            if (FMLEnvironment.dist.isClient()) {
                this.animation = AnimationId.getRegisteredAnimation(this.animationId);
            }
        }
        this.animDuration = nbt.func_74762_e("animDuration");
        this.animTick = nbt.func_74763_f("animTick");
        this.startTime = nbt.func_74763_f("startTime");
        this.state = State.values()[nbt.func_74762_e("state")];
    }

    public long getAnimationTick() {
        return this.animTick;
    }

    public boolean isPlaying() {
        return this.state == State.PLAY;
    }

    public boolean isStopped() {
        return this.state == State.STOP;
    }

    public boolean isPaused() {
        return this.state == State.PAUSE;
    }

    public static enum State {
        PLAY,
        STOP,
        PAUSE;

    }
}

