/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import xyz.pixelatedw.mineminenomi.api.ComponentNotRegisteredException;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponentKey;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusManager;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.util.TPSDelta;

public abstract class AbilityComponent<A extends IAbility> {
    private int tickRate = 0;
    private long timeToTick;
    private final AbilityComponentKey<?> key;
    private final A ability;
    private boolean isDisabled = false;
    private boolean isClientSided = false;
    private List<BonusManager> bonuses = new ArrayList<BonusManager>();

    public AbilityComponent(AbilityComponentKey<? extends AbilityComponent> key, A ability) {
        this.key = key;
        this.ability = ability;
    }

    public AbilityComponentKey<?> getKey() {
        return this.key;
    }

    public A getAbility() {
        return this.ability;
    }

    public Iterator<BonusManager> getBonusManagers() {
        return this.bonuses.iterator();
    }

    public void addBonusManager(BonusManager manager) {
        this.bonuses.add(manager);
    }

    public float getTpsFactor() {
        return TPSDelta.INSTANCE.getDeltaTime();
    }

    public void setTickRate(int tickRate) {
        this.tickRate = tickRate;
    }

    public final void tick(LivingEntity entity) {
        if (this.isDisabled) {
            return;
        }
        if (--this.timeToTick <= 0L) {
            this.timeToTick = this.tickRate;
            this.doTick(entity);
        }
    }

    protected void doTick(LivingEntity entity) {
    }

    public void postInit(IAbility ability) {
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public void setDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public boolean isClientSided() {
        return this.isClientSided;
    }

    public void setClientSide() {
        this.isClientSided = true;
    }

    @Nullable
    public CompoundNBT save() {
        CompoundNBT nbt = new CompoundNBT();
        if (!this.bonuses.isEmpty()) {
            ListNBT bonusNBT = new ListNBT();
            for (BonusManager manager : this.bonuses) {
                if (manager.getBonuses().size() <= 0) continue;
                CompoundNBT managerNBT = new CompoundNBT();
                managerNBT.func_186854_a("id", manager.getId());
                ListNBT managerBonusesNBT = new ListNBT();
                for (Map.Entry<UUID, BonusManager.BonusValue> entry : manager.getBonuses()) {
                    CompoundNBT entryNBT = new CompoundNBT();
                    entryNBT.func_186854_a("id", entry.getKey());
                    entryNBT.func_74778_a("name", entry.getValue().getName());
                    entryNBT.func_74768_a("type", entry.getValue().getType().ordinal());
                    entryNBT.func_74776_a("value", entry.getValue().getValue());
                    managerBonusesNBT.add((Object)entryNBT);
                }
                managerNBT.func_218657_a("list", (INBT)managerBonusesNBT);
                bonusNBT.add((Object)managerNBT);
            }
            if (!bonusNBT.isEmpty()) {
                nbt.func_218657_a("bonuses", (INBT)bonusNBT);
            }
        }
        return nbt;
    }

    public void load(CompoundNBT nbt) {
        ListNBT bonusNBT = nbt.func_150295_c("bonuses", 10);
        for (int i = 0; i < bonusNBT.size(); ++i) {
            CompoundNBT managerNBT = bonusNBT.func_150305_b(i);
            UUID id = managerNBT.func_186857_a("id");
            BonusManager manager = this.bonuses.stream().filter(m -> m.getId().equals(id)).findFirst().orElse(null);
            if (manager == null) continue;
            manager.clearBonuses();
            ListNBT managerBonusesNBT = managerNBT.func_150295_c("list", 10);
            for (int j = 0; j < managerBonusesNBT.size(); ++j) {
                CompoundNBT entryNBT = managerBonusesNBT.func_150305_b(j);
                UUID entryId = entryNBT.func_186857_a("id");
                String name = entryNBT.func_74779_i("name");
                BonusOperation op = BonusOperation.values()[entryNBT.func_74762_e("type")];
                float value = entryNBT.func_74760_g("value");
                manager.addBonus(entryId, name, op, value);
            }
        }
    }

    public void ensureIsRegistered() {
        boolean hasComponent = this.getAbility().hasComponent(this.getKey());
        if (!hasComponent) {
            throw new ComponentNotRegisteredException(this);
        }
    }
}

