/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Direction8;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;

public abstract class WallAbility
extends Ability {
    protected final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(90, this::startContinuityEvent).addEndEvent(90, this::endContinuityEvent);
    private List<BlockPos> posList = new ArrayList<BlockPos>();

    public WallAbility(AbilityCore core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent);
        this.addUseEvent(90, this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, this.getHoldTime());
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        float f = MathHelper.func_76128_c((double)((double)(-entity.field_70177_z) / 45.0 + 0.5)) & 7;
        Direction8 dir = Direction8.values()[(int)MathHelper.func_76135_e((float)(f % (float)Direction8.values().length))];
        if (this.posList.isEmpty()) {
            if (dir == Direction8.SOUTH) {
                this.posList.addAll(AbilityHelper.createFilledCube(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_() - 4.0, this.getLength(), this.getHeight(), this.getThickness(), this.getWallBlock(), this.getGriefingRule()));
            } else if (dir == Direction8.SOUTH_EAST) {
                this.posList.addAll(AbilityHelper.createFilledCube(entity.field_70170_p, entity.func_226277_ct_() + 2.0, entity.func_226278_cu_(), entity.func_226281_cx_() - 4.0, this.getLength(), this.getHeight(), this.getThickness(), this.getWallBlock(), this.getGriefingRule()));
                this.posList.addAll(AbilityHelper.createFilledCube(entity.field_70170_p, entity.func_226277_ct_() + 4.0, entity.func_226278_cu_(), entity.func_226281_cx_() - 2.0, this.getThickness(), this.getHeight(), this.getLength(), this.getWallBlock(), this.getGriefingRule()));
            } else if (dir == Direction8.SOUTH_WEST) {
                this.posList.addAll(AbilityHelper.createFilledCube(entity.field_70170_p, entity.func_226277_ct_() - 2.0, entity.func_226278_cu_(), entity.func_226281_cx_() - 4.0, this.getLength(), this.getHeight(), this.getThickness(), this.getWallBlock(), this.getGriefingRule()));
                this.posList.addAll(AbilityHelper.createFilledCube(entity.field_70170_p, entity.func_226277_ct_() - 4.0, entity.func_226278_cu_(), entity.func_226281_cx_() - 2.0, this.getThickness(), this.getHeight(), this.getLength(), this.getWallBlock(), this.getGriefingRule()));
            } else if (dir == Direction8.NORTH) {
                this.posList.addAll(AbilityHelper.createFilledCube(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_() + 4.0, this.getLength(), this.getHeight(), this.getThickness(), this.getWallBlock(), this.getGriefingRule()));
            } else if (dir == Direction8.NORTH_EAST) {
                this.posList.addAll(AbilityHelper.createFilledCube(entity.field_70170_p, entity.func_226277_ct_() + 2.0, entity.func_226278_cu_(), entity.func_226281_cx_() + 4.0, this.getLength(), this.getHeight(), this.getThickness(), this.getWallBlock(), this.getGriefingRule()));
                this.posList.addAll(AbilityHelper.createFilledCube(entity.field_70170_p, entity.func_226277_ct_() + 4.0, entity.func_226278_cu_(), entity.func_226281_cx_() + 2.0, this.getThickness(), this.getHeight(), this.getLength(), this.getWallBlock(), this.getGriefingRule()));
            } else if (dir == Direction8.NORTH_WEST) {
                this.posList.addAll(AbilityHelper.createFilledCube(entity.field_70170_p, entity.func_226277_ct_() - 2.0, entity.func_226278_cu_(), entity.func_226281_cx_() + 4.0, this.getLength(), this.getHeight(), this.getThickness(), this.getWallBlock(), this.getGriefingRule()));
                this.posList.addAll(AbilityHelper.createFilledCube(entity.field_70170_p, entity.func_226277_ct_() - 4.0, entity.func_226278_cu_(), entity.func_226281_cx_() + 2.0, this.getThickness(), this.getHeight(), this.getLength(), this.getWallBlock(), this.getGriefingRule()));
            } else if (dir == Direction8.EAST) {
                this.posList.addAll(AbilityHelper.createFilledCube(entity.field_70170_p, entity.func_226277_ct_() + 4.0, entity.func_226278_cu_(), entity.func_226281_cx_(), this.getThickness(), this.getHeight(), this.getLength(), this.getWallBlock(), this.getGriefingRule()));
            } else if (dir == Direction8.WEST) {
                this.posList.addAll(AbilityHelper.createFilledCube(entity.field_70170_p, entity.func_226277_ct_() - 4.0, entity.func_226278_cu_(), entity.func_226281_cx_(), this.getThickness(), this.getHeight(), this.getLength(), this.getWallBlock(), this.getGriefingRule()));
            }
        }
        if (this.stopAfterUse()) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!this.stopAfterUse()) {
            for (BlockPos pos : this.posList) {
                Block currentBlock = entity.field_70170_p.func_180495_p(pos).func_177230_c();
                if (currentBlock != this.getWallBlock()) continue;
                entity.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
        }
        this.posList.clear();
    }

    protected int getHoldTime() {
        return -1;
    }

    public abstract int getThickness();

    public abstract int getHeight();

    public abstract int getLength();

    public abstract Block getWallBlock();

    public abstract BlockProtectionRule getGriefingRule();

    public abstract boolean stopAfterUse();
}

