/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;

public abstract class PassiveStatBonusAbility
extends PassiveAbility2 {
    private final ChangeStatsComponent statsComponent = new ChangeStatsComponent(this);
    private HashMap<Attribute, Function<LivingEntity, AttributeModifier>> dynamicAttributes = new HashMap();
    private HashMap<Attribute, Double> cache = new HashMap();

    public PassiveStatBonusAbility(AbilityCore<?> core) {
        super(core);
        this.addComponents(this.statsComponent);
        this.pauseTickComponent.addResumeEvent(100, this::resumeEvent);
        this.pauseTickComponent.addPauseEvent(100, this::pauseEvent);
        this.addDuringPassiveEvent(this::duringPassiveEvent);
        this.setTickRate(40.0f);
    }

    private void duringPassiveEvent(LivingEntity entity) {
        if (!entity.field_70170_p.field_72995_K) {
            this.updateStats(entity);
        }
        if (this.pauseTickComponent.isPaused()) {
            this.statsComponent.removeModifiers(entity);
            return;
        }
        if (!this.getCheck().test(entity)) {
            this.statsComponent.removeModifiers(entity);
            return;
        }
        this.statsComponent.applyModifiers(entity);
    }

    private void resumeEvent(LivingEntity entity, IAbility ability) {
        if (this.getCheck().test(entity)) {
            this.statsComponent.applyModifiers(entity);
        }
    }

    private void pauseEvent(LivingEntity entity, IAbility ability) {
        this.statsComponent.removeModifiers(entity);
    }

    private boolean updateStats(LivingEntity entity) {
        boolean updates = false;
        for (Map.Entry<Attribute, Function<LivingEntity, AttributeModifier>> entry : this.dynamicAttributes.entrySet()) {
            AttributeModifier mod = entry.getValue().apply(entity);
            double bonus = mod.func_111164_d();
            Double lastStat = this.cache.get(entry.getKey());
            if (lastStat != null && lastStat == bonus) continue;
            this.statsComponent.removeModifier(entity, entry.getKey(), mod);
            this.statsComponent.removeAttributeModifier(entry.getKey());
            this.statsComponent.addAttributeModifier(entry.getKey(), mod);
            this.cache.put(entry.getKey(), bonus);
            updates = true;
        }
        return updates;
    }

    public abstract Predicate<LivingEntity> getCheck();

    public void pushStaticAttribute(Attribute attr, AttributeModifier mod) {
        this.statsComponent.addAttributeModifier(attr, mod, this.getCheck());
    }

    public void pushStaticAttribute(Attribute attr, AttributeModifier mod, @Nullable Predicate<LivingEntity> test) {
        this.statsComponent.addAttributeModifier(attr, mod, test);
    }

    public void pushDynamicAttribute(Attribute attr, Function<LivingEntity, AttributeModifier> func) {
        this.dynamicAttributes.put(attr, func);
    }
}

