/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities;

import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;

public abstract class DropHitAbility2
extends Ability {
    protected final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(90, this::startContinuityEvent).addTickEvent(90, this::tickContinuityEvent).addEndEvent(90, this::endContinuityEvent);
    protected final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this).addOnAttackEvent(this::onDamageTaken);
    protected final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent(this);
    private boolean hasLanded = true;
    private boolean hasFallDamage = true;
    private boolean startsInLiquid = false;

    public DropHitAbility2(AbilityCore<? extends DropHitAbility2> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.damageTakenComponent, this.hitTrackerComponent);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::onUseEvent);
    }

    protected void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hasLanded = false;
        this.hasFallDamage = false;
        this.startsInLiquid = entity.func_70090_H();
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && !this.hasFallDamage && entity.func_233570_aj_() && entity.field_70170_p.func_82737_E() > this.getLastUseGametime() + 10L) {
            this.hasFallDamage = true;
        }
        if (!this.startsInLiquid && entity.func_70090_H() && !this.hasLanded) {
            this.hasLanded = true;
        }
        if (this.startsInLiquid && entity.func_70090_H() && entity.func_213322_ci().field_72448_b <= 0.0) {
            this.hasLanded = true;
        }
        if (entity.func_233570_aj_() && this.continuousComponent.getContinueTime() > 10.0f && !this.hasLanded) {
            this.hasLanded = true;
        }
        if (this.hasLanded) {
            this.onLanding(entity);
            this.continuousComponent.stopContinuity(entity);
            return;
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
    }

    public abstract void onLanding(LivingEntity var1);

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.hasFallDamage && damageSource == DamageSource.field_76379_h) {
            this.hasFallDamage = true;
            return 0.0f;
        }
        return damage;
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        nbt = super.save(nbt);
        nbt.func_74757_a("hasFallDamage", this.hasFallDamage);
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt) {
        super.load(nbt);
        this.hasFallDamage = nbt.func_74767_n("hasFallDamage");
    }

    public void setLanded() {
        this.hasLanded = true;
    }

    public boolean hasLanded() {
        return this.hasLanded;
    }
}

