/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.BossInfo;
import net.minecraft.world.server.ServerBossInfo;
import xyz.pixelatedw.mineminenomi.api.challenges.IChallengeBoss;
import xyz.pixelatedw.mineminenomi.packets.server.ui.SUpdateOPBossInfoPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class ServerOPBossInfo
extends ServerBossInfo {
    private int totalBars = -1;
    private int activeBars = -1;
    private final int type;

    public ServerOPBossInfo(ITextComponent name) {
        super(name, BossInfo.Color.RED, BossInfo.Overlay.NOTCHED_10);
        this.type = 2;
    }

    @Deprecated
    public ServerOPBossInfo(ITextComponent name, BossInfo.Color color, BossInfo.Overlay overlay) {
        this(name);
    }

    public void tick(LivingEntity boss) {
        if (boss instanceof IChallengeBoss && ((IChallengeBoss)boss).getChallengeInfo().isDifficultyHard()) {
            Style style = this.func_186744_e().func_150256_b().func_240721_b_(TextFormatting.DARK_RED).func_240713_a_(Boolean.valueOf(true));
            this.func_186739_a((ITextComponent)new StringTextComponent(this.func_186744_e().getString()).func_230530_a_(style));
        }
        if (this.type == 0) {
            this.func_186746_a(BossInfo.Overlay.NOTCHED_10);
            this.func_186745_a(BossInfo.Color.RED);
            float percentage = boss.func_110143_aJ() / boss.func_110138_aP();
            this.func_186735_a(percentage);
        } else if (this.type == 1) {
            BossInfo.Color[] colors = new BossInfo.Color[]{BossInfo.Color.GREEN, BossInfo.Color.YELLOW, BossInfo.Color.PINK, BossInfo.Color.RED, BossInfo.Color.PURPLE};
            int maxBars = (int)(boss.func_110138_aP() / 500.0f * 5.0f);
            maxBars = Math.max(1, maxBars);
            maxBars = Math.min(colors.length, maxBars);
            float hpThreshold = boss.func_110138_aP() / (float)maxBars;
            if (boss.func_110143_aJ() == boss.func_110138_aP()) {
                this.func_186745_a(colors[maxBars - 1]);
                this.func_186735_a(1.0f);
                return;
            }
            float percentage = boss.func_110143_aJ() % hpThreshold / hpThreshold;
            int currentBar = (int)Math.ceil(boss.func_110143_aJ() / boss.func_110138_aP() * (float)maxBars) - 1;
            currentBar = Math.max(0, currentBar);
            BossInfo.Color currentColor = colors[currentBar];
            this.func_186745_a(currentColor);
            this.func_186735_a(percentage);
        } else if (this.type == 2) {
            float hpThreshold = Math.min(boss.func_110138_aP(), 100.0f);
            int maxBars = (int)Math.ceil((boss.func_110138_aP() - hpThreshold) / hpThreshold);
            int activeBars = (int)Math.ceil((boss.func_110143_aJ() - hpThreshold) / hpThreshold);
            this.setBars(maxBars, activeBars);
            if (boss.func_110143_aJ() == boss.func_110138_aP()) {
                this.func_186735_a(1.0f);
                return;
            }
            float finalBarThreshold = Math.min(boss.func_110138_aP() - (float)(activeBars * 100), 100.0f);
            float percentage = boss.func_110143_aJ() % hpThreshold / finalBarThreshold;
            this.func_186735_a(percentage);
        }
    }

    public void setBars(int total, int active) {
        boolean needsUpdate = false;
        if (this.totalBars != total) {
            this.totalBars = total;
            needsUpdate = true;
        }
        if (this.activeBars != active) {
            this.activeBars = active;
            needsUpdate = true;
        }
        if (needsUpdate) {
            this.update();
        }
    }

    public void update() {
        if (this.func_201359_g()) {
            SUpdateOPBossInfoPacket packet = new SUpdateOPBossInfoPacket(this.func_186737_d(), this.totalBars, this.activeBars);
            for (ServerPlayerEntity serverplayerentity : this.func_186757_c()) {
                WyNetwork.sendTo(packet, (PlayerEntity)serverplayerentity);
            }
        }
    }
}

