/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.zushi;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class GraviPullAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "gravi_pull", new Pair[]{ImmutablePair.of((Object)"Pulls all enemies in a radius towards the user.", null)});
    private static final int COOLDOWN = 340;
    private static final int CHARGE_TIME = 60;
    private static final int RANGE = 16;
    public static final AbilityCore<GraviPullAbility> INSTANCE = new AbilityCore.Builder<GraviPullAbility>("Gravi Pull", AbilityCategory.DEVIL_FRUITS, GraviPullAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(340.0f), ChargeComponent.getTooltip(60.0f), RangeComponent.getTooltip(16.0f, RangeComponent.RangeType.AOE)).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(this::startChargeEvent).addEndEvent(this::endChargeEvent);
    private final RangeComponent rangeComponent = new RangeComponent(this);

    public GraviPullAbility(AbilityCore<GraviPullAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.rangeComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 60.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.GRAVI_PULL_1.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.GRAVI_PULL_2.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 16.0f);
        for (LivingEntity target : targets) {
            double offsetX = entity.func_226277_ct_() - target.func_226277_ct_();
            double offsetZ = entity.func_226281_cx_() - target.func_226281_cx_();
            AbilityHelper.setDeltaMovement((Entity)target, offsetX / 2.0, (entity.func_226278_cu_() - target.func_226278_cu_()) / 4.0, offsetZ / 2.0);
        }
        this.cooldownComponent.startCooldown(entity, 340.0f);
    }
}

