/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.zoumammoth;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class AncientSweepAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "ancient_sweep", new Pair[]{ImmutablePair.of((Object)"Hits all enemies in a frontal cone with your trunk.", null)});
    private static final int COOLDOWN = 160;
    private static final int CHARGE_TIME = 40;
    private static final int HEAVY_RANGE = 3;
    private static final int GUARD_RANGE = 6;
    private static final int HEAVY_DAMAGE = 15;
    private static final int GUARD_DAMAGE = 20;
    private static final AbilityDescriptionLine.IDescriptionLine<AncientSweepAbility> RANGE_TOOLTIP = (entity, ability) -> {
        int range = 3;
        if (((MorphInfo)ModMorphs.MAMMOTH_GUARD.get()).isActive(entity)) {
            range = 6;
        }
        return RangeComponent.getTooltip(range, RangeComponent.RangeType.LINE).expand(entity, ability);
    };
    private static final AbilityDescriptionLine.IDescriptionLine<AncientSweepAbility> DAMAGE_TOOLTIP = (entity, ability) -> {
        int damage = 15;
        if (((MorphInfo)ModMorphs.MAMMOTH_GUARD.get()).isActive(entity)) {
            damage = 20;
        }
        return DealDamageComponent.getTooltip(damage).expand(entity, ability);
    };
    public static final AbilityCore<AncientSweepAbility> INSTANCE = new AbilityCore.Builder<AncientSweepAbility>("Ancient Sweep", AbilityCategory.DEVIL_FRUITS, AncientSweepAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(160.0f), ChargeComponent.getTooltip(40.0f), RANGE_TOOLTIP, DAMAGE_TOOLTIP).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addEndEvent(100, this::endChargeEvent);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent(this, (MorphInfo)ModMorphs.MAMMOTH_GUARD.get(), (MorphInfo)ModMorphs.MAMMOTH_HEAVY.get());

    public AncientSweepAbility(AbilityCore<AncientSweepAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.rangeComponent, this.dealDamageComponent, this.requireMorphComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 40.0f);
    }

    public void endChargeEvent(LivingEntity entity, IAbility ability) {
        float damage = 15.0f;
        float radius = 3.0f;
        if (((MorphInfo)ModMorphs.MAMMOTH_GUARD.get()).isActive(entity)) {
            radius *= 2.0f;
            damage += 5.0f;
        }
        List<LivingEntity> targets = this.rangeComponent.getTargetsInLine(entity, radius, 3.0f);
        for (LivingEntity target : targets) {
            if (!this.dealDamageComponent.hurtTarget(entity, target, damage)) continue;
            Vector3d speed = WyHelper.propulsion(entity, 3.0, 3.0);
            AbilityHelper.setDeltaMovement((Entity)target, speed.field_72450_a, entity.func_213322_ci().func_82617_b() + 0.5, speed.field_72449_c);
        }
        if (!entity.field_70170_p.field_72995_K) {
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
        }
        this.cooldownComponent.startCooldown(entity, 160.0f);
    }
}

