/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.zou;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class GreatStompAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "great_stomp", new Pair[]{ImmutablePair.of((Object)"By stomping the ground as a full-form elephant, the user creates a shockwave.", null)});
    private static final int COOLDOWN = 240;
    private static final int RANGE = 10;
    private static final float DAMAGE = 15.0f;
    public static final AbilityCore<GreatStompAbility> INSTANCE = new AbilityCore.Builder<GreatStompAbility>("Great Stomp", AbilityCategory.DEVIL_FRUITS, GreatStompAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(240.0f)).setSourceHakiNature(SourceHakiNature.SPECIAL).build();
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent(this, (MorphInfo)ModMorphs.ZOU_GUARD.get(), new MorphInfo[0]);

    public GreatStompAbility(AbilityCore<GreatStompAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.rangeComponent, this.dealDamageComponent, this.requireMorphComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 10.0f);
        ModDamageSource source = ((ModDamageSource)this.dealDamageComponent.getDamageSource(entity)).markIndirectDamage();
        for (LivingEntity target : targets) {
            if (!this.dealDamageComponent.hurtTarget(entity, target, 15.0f, source)) continue;
            target.func_70107_b(target.func_226277_ct_(), target.func_226278_cu_() + 3.0, target.func_226281_cx_());
        }
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.GREAT_STOMP.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        this.cooldownComponent.startCooldown(entity, 240.0f);
    }
}

