/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.yuki;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.yuki.YukiRabiProjectile;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class YukiRabiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "yuki_rabi", new Pair[]{ImmutablePair.of((Object)"Launches numerous hardened snowballs, shaped like a rabbit's head, that can inflict %s on their enemies.", (Object)new Object[]{ModEffects.FROSTBITE})});
    public static final AbilityCore<YukiRabiAbility> INSTANCE = new AbilityCore.Builder<YukiRabiAbility>("Yuki Rabi", AbilityCategory.DEVIL_FRUITS, YukiRabiAbility::new).addDescriptionLine(DESCRIPTION).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceElement(SourceElement.ICE).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::onContinuityStart);
    private final RepeaterComponent repeaterComponent = new RepeaterComponent(this).addTriggerEvent(this::onRepeaterTrigger).addStopEvent(this::onRepeaterStop);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private static final float COOLDOWN = 120.0f;

    public YukiRabiAbility(AbilityCore<YukiRabiAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.continuousComponent, this.repeaterComponent, this.projectileComponent);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.repeaterComponent.stop(entity);
            return;
        }
        this.continuousComponent.triggerContinuity(entity);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        this.repeaterComponent.start(entity, 6, 3);
    }

    private void onRepeaterTrigger(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 2.0f, 2.0f);
    }

    private void onRepeaterStop(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        this.cooldownComponent.startCooldown(entity, 120.0f);
    }

    private YukiRabiProjectile createProjectile(LivingEntity entity) {
        return new YukiRabiProjectile(entity.field_70170_p, entity, this);
    }
}

