/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ushibison;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class FiddleBanffAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "fiddle_banff", new Pair[]{ImmutablePair.of((Object)"Running into enemies deals damage and knocks them back.", null)});
    private static final int COOLDOWN = 140;
    private static final int CONTINUITY = 20;
    private static final float AREA_SIZE = 1.6f;
    private static final float DAMAGE = 15.0f;
    public static final AbilityCore<FiddleBanffAbility> INSTANCE = new AbilityCore.Builder<FiddleBanffAbility>("Fiddle Banff", AbilityCategory.DEVIL_FRUITS, FiddleBanffAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(140.0f), ContinuousComponent.getTooltip(20.0f), RangeComponent.getTooltip(1.6f, RangeComponent.RangeType.AOE), DealDamageComponent.getTooltip(15.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addEndEvent(100, this::stopContinuityEvent).addTickEvent(100, this::tickContinuityEvent);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent(this, (MorphInfo)ModMorphs.BISON_HEAVY.get(), (MorphInfo)ModMorphs.BISON_WALK.get());

    public FiddleBanffAbility(AbilityCore<FiddleBanffAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.dealDamageComponent, this.hitTrackerComponent, this.rangeComponent, this.requireMorphComponent);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        Vector3d speed = WyHelper.propulsion(entity, 5.0, 5.0);
        AbilityHelper.setDeltaMovement((Entity)entity, speed.field_72450_a, entity.func_213322_ci().func_82617_b(), speed.field_72449_c);
        this.continuousComponent.startContinuity(entity, 20.0f);
    }

    private void stopContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 140.0f);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        List<LivingEntity> list = this.rangeComponent.getTargetsInArea(entity, 1.6f);
        for (LivingEntity target : list) {
            if (!this.hitTrackerComponent.canHit((Entity)target)) continue;
            this.dealDamageComponent.hurtTarget(entity, target, 15.0f);
        }
    }
}

