/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.toriphoenix;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.RepeaterAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.entities.projectiles.toriphoenix.PhoenixGoenProjectile;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;

public class PhoenixGoenAbility
extends RepeaterAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "phoenix_goen", new Pair[]{ImmutablePair.of((Object)"Launches high speed blue flames while midair.", null)});
    private static final int COOLDOWN = 160;
    private static final int TRIGGERS = 5;
    private static final int INTERVAL = 4;
    public static final AbilityCore<PhoenixGoenAbility> INSTANCE = new AbilityCore.Builder<PhoenixGoenAbility>("Phoenix Goen", AbilityCategory.DEVIL_FRUITS, PhoenixGoenAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(160.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).build();
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent(this, (MorphInfo)ModMorphs.PHOENIX_ASSAULT.get(), (MorphInfo)ModMorphs.PHOENIX_FLY.get());

    public PhoenixGoenAbility(AbilityCore<PhoenixGoenAbility> core) {
        super((AbilityCore<? extends RepeaterAbility2>)core);
        this.addComponents(this.requireMorphComponent);
        this.addCanUseCheck(AbilityHelper::requiresInAir);
    }

    @Override
    public int getMaxTriggers() {
        return 5;
    }

    @Override
    public int getTriggerInterval() {
        return 4;
    }

    @Override
    public float getRepeaterCooldown() {
        return 160.0f;
    }

    @Override
    public float getProjectileSpeed() {
        return 2.5f;
    }

    @Override
    public float getProjectileSpread() {
        return 5.0f;
    }

    public PhoenixGoenProjectile getProjectileFactory(LivingEntity entity) {
        PhoenixGoenProjectile proj = new PhoenixGoenProjectile(entity.field_70170_p, entity, this, entity.func_70040_Z());
        return proj;
    }
}

