/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.toriphoenix;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.PropelledFlightAbility;
import xyz.pixelatedw.mineminenomi.abilities.toriphoenix.PhoenixFlightAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.MorphAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;

public class PhoenixFlyPointAbility
extends MorphAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "phoenix_fly_point", new Pair[]{ImmutablePair.of((Object)"Transforms the user into a phoenix, which focuses on speed and healing.", null)});
    public static final AbilityCore<PhoenixFlyPointAbility> INSTANCE = new AbilityCore.Builder<PhoenixFlyPointAbility>("Phoenix Fly Point", AbilityCategory.DEVIL_FRUITS, PhoenixFlyPointAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(10.0f), ContinuousComponent.getTooltip(), ChangeStatsComponent.getTooltip()).build();
    private static final AbilityAttributeModifier REGEN_RATE_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_REGEN_RATE_UUID, INSTANCE, "Phoenix Fly Point Health Regeneration Speed Modifier", 1.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier FALL_DAMAGE_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_FALL_RESISTANCE_UUID, INSTANCE, "Phoenix Fly Point Fall Damage Modifier", 500.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier TOUGHNESS_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_TOUGHNESS_UUID, INSTANCE, "Phoenix Fly Point Toughness Modifier", 1.0, AttributeModifier.Operation.ADDITION);

    public PhoenixFlyPointAbility(AbilityCore<PhoenixFlyPointAbility> core) {
        super(core);
        Predicate<LivingEntity> isMorphed = entity -> this.morphComponent.isMorphed();
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.REGEN_RATE, (AttributeModifier)REGEN_RATE_MODIFIER, isMorphed);
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.FALL_RESISTANCE, (AttributeModifier)FALL_DAMAGE_MODIFIER, isMorphed);
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.TOUGHNESS, (AttributeModifier)TOUGHNESS_MODIFIER, isMorphed);
        this.continuousComponent.addStartEvent(this::onContinuityStart).addEndEvent(this::onContinuityEnd);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        IAbilityData abilityDataProps = AbilityDataCapability.get(entity);
        if (abilityDataProps == null) {
            return;
        }
        PropelledFlightAbility flightAbility = abilityDataProps.getPassiveAbility(PhoenixFlightAbility.INSTANCE);
        if (flightAbility != null && !flightAbility.isPaused()) {
            PropelledFlightAbility.enableFlight((PlayerEntity)entity);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        IAbilityData abilityDataProps = AbilityDataCapability.get(entity);
        if (abilityDataProps == null) {
            return;
        }
        PropelledFlightAbility flightAbility = abilityDataProps.getPassiveAbility(PhoenixFlightAbility.INSTANCE);
        if (flightAbility != null) {
            PropelledFlightAbility.disableFlight((PlayerEntity)entity);
        }
    }

    @Override
    public MorphInfo getTransformation() {
        return (MorphInfo)ModMorphs.PHOENIX_FLY.get();
    }
}

