/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.toriphoenix;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import xyz.pixelatedw.mineminenomi.abilities.PropelledFlightAbility;
import xyz.pixelatedw.mineminenomi.abilities.toriphoenix.FujiazamiAbility;
import xyz.pixelatedw.mineminenomi.abilities.toriphoenix.PhoenixAssaultPointAbility;
import xyz.pixelatedw.mineminenomi.abilities.toriphoenix.PhoenixFlyPointAbility;
import xyz.pixelatedw.mineminenomi.abilities.toriphoenix.TenseiNoSoenAbility;
import xyz.pixelatedw.mineminenomi.api.IPlayerAbilities;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class PhoenixFlightAbility
extends PropelledFlightAbility {
    public static final AbilityCore<PhoenixFlightAbility> INSTANCE = new AbilityCore.Builder<PhoenixFlightAbility>("Phoenix Flight", AbilityCategory.DEVIL_FRUITS, AbilityType.PASSIVE, PhoenixFlightAbility::new).build();

    public PhoenixFlightAbility(AbilityCore<PhoenixFlightAbility> core) {
        super((AbilityCore<? extends PropelledFlightAbility>)core);
        super.addCanUseCheck(this::canFly);
        super.addDuringPassiveEvent(this::onDuringPassive);
    }

    private void onDuringPassive(LivingEntity entity) {
        boolean isPhoenixFlyPointActive;
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)player);
        PhoenixFlyPointAbility phoenixFlyPointAbility = abilityDataProps.getEquippedAbility(PhoenixFlyPointAbility.INSTANCE);
        double difference = DevilFruitHelper.getDifferenceToFloor((Entity)player);
        boolean bl = isPhoenixFlyPointActive = phoenixFlyPointAbility != null && phoenixFlyPointAbility.getComponent(ModAbilityKeys.CONTINUOUS).get().isContinuous();
        if (isPhoenixFlyPointActive) {
            if (((IPlayerAbilities)player.field_71075_bZ).hasCustomFlight() && !player.field_71075_bZ.field_75100_b) {
                player.field_71075_bZ.field_75100_b = true;
            }
            if (difference < 2.0) {
                AbilityHelper.setDeltaMovement((Entity)player, player.func_213322_ci().func_72441_c(0.0, 1.0, 0.0).func_216372_d(1.0, 0.25, 1.0));
            }
        }
    }

    @Override
    public float getMaxSpeed(LivingEntity entity) {
        float maxSpeed = 0.0f;
        IAbilityData abilityDataProps = AbilityDataCapability.get(entity);
        PhoenixAssaultPointAbility phoenixAssaultPointAbility = abilityDataProps.getEquippedAbility(PhoenixAssaultPointAbility.INSTANCE);
        PhoenixFlyPointAbility phoenixFlyPointAbility = abilityDataProps.getEquippedAbility(PhoenixFlyPointAbility.INSTANCE);
        if (phoenixAssaultPointAbility != null && phoenixAssaultPointAbility.isContinuous()) {
            maxSpeed = entity.func_70051_ag() ? 1.0f : 0.625f;
        } else if (phoenixFlyPointAbility != null && phoenixFlyPointAbility.isContinuous()) {
            maxSpeed = entity.func_70051_ag() ? 2.0f : 1.25f;
        }
        EffectInstance fatigueEffectInstance = entity.func_70660_b((Effect)ModEffects.FATIGUE_EFFECT.get());
        if (fatigueEffectInstance != null) {
            maxSpeed /= 1.0f + Math.min((float)fatigueEffectInstance.func_76458_c(), 3.0f);
        }
        return maxSpeed;
    }

    @Override
    protected float getAcceleration(LivingEntity entity) {
        IAbilityData abilityDataProps = AbilityDataCapability.get(entity);
        PhoenixAssaultPointAbility phoenixAssaultPointAbility = abilityDataProps.getEquippedAbility(PhoenixAssaultPointAbility.INSTANCE);
        PhoenixFlyPointAbility phoenixFlyPointAbility = abilityDataProps.getEquippedAbility(PhoenixFlyPointAbility.INSTANCE);
        if (phoenixAssaultPointAbility != null && phoenixAssaultPointAbility.isContinuous()) {
            return entity.func_70051_ag() ? 0.007f : 0.0035f;
        }
        if (phoenixFlyPointAbility != null && phoenixFlyPointAbility.isContinuous()) {
            return entity.func_70051_ag() ? 0.014f : 0.007f;
        }
        return 0.0f;
    }

    @Override
    protected int getHeightDifference(LivingEntity entity) {
        return 128;
    }

    @Override
    public float getSpeed(LivingEntity entity) {
        FujiazamiAbility fujiazamiAbility = AbilityDataCapability.get(entity).getEquippedAbility(FujiazamiAbility.INSTANCE);
        if (fujiazamiAbility != null && fujiazamiAbility.isContinuous()) {
            return 0.0f;
        }
        EffectInstance fatigueEffectInstance = entity.func_70660_b((Effect)ModEffects.FATIGUE_EFFECT.get());
        if (fatigueEffectInstance != null) {
            return this.speed * 1.0f - Math.min((float)fatigueEffectInstance.func_76458_c(), 3.0f);
        }
        return this.speed;
    }

    private AbilityUseResult canFly(LivingEntity entity, IAbility ability) {
        boolean isTenseiNoSoenActive;
        IAbilityData abilityDataProps = AbilityDataCapability.get(entity);
        PhoenixAssaultPointAbility phoenixAssaultPointAbility = abilityDataProps.getEquippedAbility(PhoenixAssaultPointAbility.INSTANCE);
        PhoenixFlyPointAbility phoenixFlyPointAbility = abilityDataProps.getEquippedAbility(PhoenixFlyPointAbility.INSTANCE);
        TenseiNoSoenAbility tenseiNoSoenAbility = abilityDataProps.getEquippedAbility(TenseiNoSoenAbility.INSTANCE);
        boolean bl = isTenseiNoSoenActive = tenseiNoSoenAbility != null && tenseiNoSoenAbility.isContinuous();
        if (phoenixAssaultPointAbility != null && phoenixAssaultPointAbility.isContinuous() || phoenixFlyPointAbility != null && phoenixFlyPointAbility.isContinuous() && !isTenseiNoSoenActive) {
            return AbilityUseResult.success();
        }
        return AbilityUseResult.fail(null);
    }
}

